/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.SimplePathMapping;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AbstractExporter;
import org.apache.jackrabbit.vault.packaging.ExportPostProcessor;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubPackageExportProcessor
implements ExportPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SubPackageExportProcessor.class);
    private JcrPackageManagerImpl mgr;
    private final Session session;
    private final LinkedHashMap<PackageId, String> subPackages = new LinkedHashMap();

    public SubPackageExportProcessor(JcrPackageManagerImpl jcrPackageManager, Session session) {
        this.mgr = jcrPackageManager;
        this.session = session;
    }

    @Override
    public void process(AbstractExporter exporter) {
        try {
            for (Map.Entry<PackageId, String> pkg : this.subPackages.entrySet()) {
                RepositoryAddress addr;
                String nodePath = pkg.getValue();
                if (Text.isDescendantOrEqual("/etc/packages", nodePath)) continue;
                String etcPath = "/etc/packages" + this.mgr.getRegistry().getRelativeInstallationPath(pkg.getKey()) + ".zip";
                etcPath = Text.getRelativeParent(etcPath, 1);
                DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                filter.add(new PathFilterSet(nodePath));
                try {
                    addr = new RepositoryAddress(Text.escapePath("/" + this.session.getWorkspace().getName() + Text.getRelativeParent(nodePath, 1)));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                VaultFileSystem jcrfs = Mounter.mount(null, filter, addr, etcPath, this.session);
                for (VaultFile vaultFile : jcrfs.getRoot().getChildren()) {
                    String path = "jcr_root/" + vaultFile.getName();
                    if (vaultFile.isDirectory()) {
                        exporter.createDirectory(vaultFile, path);
                        exporter.export(vaultFile, path);
                        continue;
                    }
                    if (path.endsWith("/.content.xml")) continue;
                    exporter.writeFile(vaultFile, path);
                }
                jcrfs.unmount();
            }
        }
        catch (Exception e) {
            log.error("Error during post processing", (Throwable)e);
        }
    }

    public WorkspaceFilter prepare(WorkspaceFilter originalFilter) throws RepositoryException {
        for (JcrPackage jcrPackage : this.mgr.listPackages(originalFilter)) {
            if (!jcrPackage.isValid() || jcrPackage.getSize() <= 0L) continue;
            this.subPackages.put(jcrPackage.getDefinition().getId(), jcrPackage.getNode().getPath());
        }
        WorkspaceFilter filter = originalFilter.translate(new SimplePathMapping("/etc/packages", this.mgr.getRegistry().getPackRootPaths()[0]));
        for (JcrPackage pkg : this.mgr.listPackages(filter)) {
            if (!pkg.isValid() || pkg.getSize() <= 0L) continue;
            this.subPackages.put(pkg.getDefinition().getId(), pkg.getNode().getPath());
        }
        if (this.subPackages.size() > 0) {
            PathFilterSet set;
            DefaultWorkspaceFilter defaultWorkspaceFilter = (DefaultWorkspaceFilter)filter.translate(PathMapping.IDENTITY);
            Iterator<PathFilterSet> iter = defaultWorkspaceFilter.getFilterSets().iterator();
            block2: while (iter.hasNext()) {
                set = iter.next();
                for (String root : this.mgr.getRegistry().getPackRootPaths()) {
                    if (!Text.isDescendantOrEqual(root, set.getRoot())) continue;
                    iter.remove();
                    continue block2;
                }
            }
            iter = defaultWorkspaceFilter.getPropertyFilterSets().iterator();
            block4: while (iter.hasNext()) {
                set = iter.next();
                for (String root : this.mgr.getRegistry().getPackRootPaths()) {
                    if (!Text.isDescendantOrEqual(root, set.getRoot())) continue;
                    iter.remove();
                    continue block4;
                }
            }
            for (Map.Entry<PackageId, String> pkg : this.subPackages.entrySet()) {
                String path = "/etc/packages" + this.mgr.getRegistry().getRelativeInstallationPath(pkg.getKey()) + ".zip";
                defaultWorkspaceFilter.add(new PathFilterSet(path));
            }
            return defaultWorkspaceFilter;
        }
        return null;
    }
}

