/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.jackrabbit.vault.util.xml.serialize.DOMSerializer;
import org.apache.jackrabbit.vault.util.xml.serialize.ElementState;
import org.apache.jackrabbit.vault.util.xml.serialize.EncodingInfo;
import org.apache.jackrabbit.vault.util.xml.serialize.IndentPrinter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.Printer;
import org.apache.jackrabbit.vault.util.xml.serialize.Serializer;
import org.apache.jackrabbit.vault.util.xml.xerces.dom.DOMErrorImpl;
import org.apache.jackrabbit.vault.util.xml.xerces.dom.DOMLocatorImpl;
import org.apache.jackrabbit.vault.util.xml.xerces.dom.DOMMessageFormatter;
import org.apache.jackrabbit.vault.util.xml.xerces.util.XMLChar;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class BaseMarkupSerializer
implements ContentHandler,
DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler,
DOMSerializer,
Serializer {
    protected short features = (short)-1;
    protected DOMErrorHandler fDOMErrorHandler;
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected EncodingInfo _encodingInfo;
    private ElementState[] _elementStates;
    private int _elementStateCount;
    private Vector _preRoot;
    protected boolean _started;
    private boolean _prepared;
    protected Map<String, String> _prefixes;
    protected String _docTypePublicId;
    protected String _docTypeSystemId;
    protected OutputFormat _format;
    protected Printer _printer;
    protected boolean _indenting;
    protected final StringBuffer fStrBuffer = new StringBuffer(40);
    private Writer _writer;
    private OutputStream _output;
    protected Node fCurrentNode = null;

    protected BaseMarkupSerializer(OutputFormat format) {
        this._elementStates = new ElementState[10];
        for (int i = 0; i < this._elementStates.length; ++i) {
            this._elementStates[i] = new ElementState();
        }
        this._format = format;
    }

    @Override
    public DocumentHandler asDocumentHandler() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public ContentHandler asContentHandler() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public DOMSerializer asDOMSerializer() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public void setOutputByteStream(OutputStream output) {
        if (output == null) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"output"});
            throw new NullPointerException(msg);
        }
        this._output = output;
        this._writer = null;
        this.reset();
    }

    @Override
    public void setOutputCharStream(Writer writer) {
        if (writer == null) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"writer"});
            throw new NullPointerException(msg);
        }
        this._writer = writer;
        this._output = null;
        this.reset();
    }

    @Override
    public void setOutputFormat(OutputFormat format) {
        if (format == null) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"format"});
            throw new NullPointerException(msg);
        }
        this._format = format;
        this.reset();
    }

    public boolean reset() {
        if (this._elementStateCount > 1) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ResetInMiddle", null);
            throw new IllegalStateException(msg);
        }
        this._prepared = false;
        this.fCurrentNode = null;
        this.fStrBuffer.setLength(0);
        return true;
    }

    protected void prepare() throws IOException {
        if (this._prepared) {
            return;
        }
        if (this._writer == null && this._output == null) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
            throw new IOException(msg);
        }
        this._encodingInfo = this._format.getEncodingInfo();
        if (this._output != null) {
            this._writer = this._encodingInfo.getWriter(this._output);
        }
        if (this._format.getIndenting()) {
            this._indenting = true;
            this._printer = new IndentPrinter(this._writer, this._format);
        } else {
            this._indenting = false;
            this._printer = new Printer(this._writer, this._format);
        }
        this._elementStateCount = 0;
        ElementState state = this._elementStates[0];
        state.namespaceURI = null;
        state.localName = null;
        state.rawName = null;
        state.preserveSpace = this._format.getPreserveSpace();
        state.empty = true;
        state.afterElement = false;
        state.afterComment = false;
        state.inCData = false;
        state.doCData = false;
        state.prefixes = null;
        this._docTypePublicId = this._format.getDoctypePublic();
        this._docTypeSystemId = this._format.getDoctypeSystem();
        this._started = false;
        this._prepared = true;
    }

    @Override
    public void serialize(Element elem) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(elem);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    @Override
    public void serialize(DocumentFragment frag) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(frag);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    @Override
    public void serialize(Document doc) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(doc);
        this.serializePreRoot();
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.prepare();
        }
        catch (IOException except) {
            throw new SAXException(except.toString());
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            if (state.inCData || state.doCData) {
                if (!state.inCData) {
                    this._printer.printText("<![CDATA[");
                    state.inCData = true;
                }
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                for (int index = start; index < length; ++index) {
                    char ch = chars[index];
                    if (ch == ']' && index + 2 < length && chars[index + 1] == ']' && chars[index + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        index += 2;
                        continue;
                    }
                    if (!XMLChar.isValid(ch)) {
                        if (++index < length) {
                            this.surrogates(ch, chars[index]);
                            continue;
                        }
                        this.fatalError("The character '" + ch + "' is an invalid XML character");
                        continue;
                    }
                    if (ch >= ' ' && this._encodingInfo.isPrintable(ch) && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t') {
                        this._printer.printText(ch);
                        continue;
                    }
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(ch));
                    this._printer.printText(";<![CDATA[");
                }
                this._printer.setNextIndent(saveIndent);
            } else if (state.preserveSpace) {
                int saveIndent = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(chars, start, length, true, state.unescaped);
                this._printer.setNextIndent(saveIndent);
            } else {
                this.printText(chars, start, length, false, state.unescaped);
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        try {
            this.content();
            if (this._indenting) {
                this._printer.setThisIndent(0);
                int i = start;
                while (length-- > 0) {
                    this._printer.printText(chars[i]);
                    ++i;
                }
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public final void processingInstruction(String target, String code) throws SAXException {
        try {
            this.processingInstructionIO(target, code);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void processingInstructionIO(String target, String code) throws IOException {
        ElementState state = this.content();
        int index = target.indexOf("?>");
        if (index >= 0) {
            this.fStrBuffer.append("<?").append(target.substring(0, index));
        } else {
            this.fStrBuffer.append("<?").append(target);
        }
        if (code != null) {
            this.fStrBuffer.append(' ');
            index = code.indexOf("?>");
            if (index >= 0) {
                this.fStrBuffer.append(code.substring(0, index));
            } else {
                this.fStrBuffer.append(code);
            }
        }
        this.fStrBuffer.append("?>");
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                state.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
    }

    @Override
    public void comment(char[] chars, int start, int length) throws SAXException {
        try {
            this.comment(new String(chars, start, length));
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void comment(String text) throws IOException {
        if (this._format.getOmitComments()) {
            return;
        }
        ElementState state = this.content();
        int index = text.indexOf("-->");
        if (index >= 0) {
            this.fStrBuffer.append("<!--").append(text.substring(0, index)).append("-->");
        } else {
            this.fStrBuffer.append("<!--").append(text).append("-->");
        }
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            if (this._indenting && !state.preserveSpace) {
                this._printer.breakLine();
            }
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                state.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
        state.afterComment = true;
        state.afterElement = false;
    }

    @Override
    public void startCDATA() {
        ElementState state = this.getElementState();
        state.doCData = true;
    }

    @Override
    public void endCDATA() {
        ElementState state = this.getElementState();
        state.doCData = false;
    }

    public void startNonEscaping() {
        ElementState state = this.getElementState();
        state.unescaped = true;
    }

    public void endNonEscaping() {
        ElementState state = this.getElementState();
        state.unescaped = false;
    }

    public void startPreserving() {
        ElementState state = this.getElementState();
        state.preserveSpace = true;
    }

    public void endPreserving() {
        ElementState state = this.getElementState();
        state.preserveSpace = false;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.serializePreRoot();
            this._printer.flush();
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.endCDATA();
            this.content();
            this._printer.printText('&');
            this._printer.printText(name);
            this._printer.printText(';');
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._prefixes == null) {
            this._prefixes = new TreeMap<String, String>();
        }
        this._prefixes.put(uri, prefix == null ? "" : prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this._printer.enterDTD();
            this._docTypePublicId = publicId;
            this._docTypeSystemId = systemId;
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ELEMENT ");
            this._printer.printText(name);
            this._printer.printText(' ');
            this._printer.printText(model);
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ATTLIST ");
            this._printer.printText(eName);
            this._printer.printText(' ');
            this._printer.printText(aName);
            this._printer.printText(' ');
            this._printer.printText(type);
            if (valueDefault != null) {
                this._printer.printText(' ');
                this._printer.printText(valueDefault);
            }
            if (value != null) {
                this._printer.printText(" \"");
                this.printEscaped(value);
                this._printer.printText('\"');
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ENTITY ");
            this._printer.printText(name);
            this._printer.printText(" \"");
            this.printEscaped(value);
            this._printer.printText("\">");
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this._printer.enterDTD();
            this.unparsedEntityDecl(name, publicId, systemId, null);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        try {
            this._printer.enterDTD();
            if (publicId == null) {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(name);
                this._printer.printText(" SYSTEM ");
                this.printDoctypeURL(systemId);
            } else {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(name);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(publicId);
                this._printer.printText(' ');
                this.printDoctypeURL(systemId);
            }
            if (notationName != null) {
                this._printer.printText(" NDATA ");
                this._printer.printText(notationName);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this._printer.enterDTD();
            if (publicId != null) {
                this._printer.printText("<!NOTATION ");
                this._printer.printText(name);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(publicId);
                if (systemId != null) {
                    this._printer.printText(' ');
                    this.printDoctypeURL(systemId);
                }
            } else {
                this._printer.printText("<!NOTATION ");
                this._printer.printText(name);
                this._printer.printText(" SYSTEM ");
                this.printDoctypeURL(systemId);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    protected void serializeNode(Node node) throws IOException {
        this.fCurrentNode = node;
        switch (node.getNodeType()) {
            case 3: {
                String text = node.getNodeValue();
                if (text == null || this._indenting && !this.getElementState().preserveSpace && text.replace('\n', ' ').trim().length() == 0) break;
                this.characters(text);
                break;
            }
            case 4: {
                String text = node.getNodeValue();
                if ((this.features & 8) != 0) {
                    if (text == null) break;
                    this.startCDATA();
                    this.characters(text);
                    this.endCDATA();
                    break;
                }
                this.characters(text);
                break;
            }
            case 8: {
                String text;
                if (this._format.getOmitComments() || (text = node.getNodeValue()) == null) break;
                this.comment(text);
                break;
            }
            case 5: {
                this.endCDATA();
                this.content();
                if ((this.features & 4) != 0 || node.getFirstChild() == null) {
                    this.checkUnboundNamespacePrefixedNode(node);
                    this._printer.printText("&");
                    this._printer.printText(node.getNodeName());
                    this._printer.printText(";");
                    break;
                }
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.serializeNode(child);
                }
                break;
            }
            case 7: {
                this.processingInstructionIO(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: {
                DocumentType docType = ((Document)node).getDoctype();
                if (docType != null) {
                    DOMImplementation domImpl = ((Document)node).getImplementation();
                    try {
                        this._printer.enterDTD();
                        this._docTypePublicId = docType.getPublicId();
                        this._docTypeSystemId = docType.getSystemId();
                        String internal = docType.getInternalSubset();
                        if (internal != null && internal.length() > 0) {
                            this._printer.printText(internal);
                        }
                        this.endDTD();
                    }
                    catch (NoSuchMethodError nsme) {
                        Class<?> docTypeClass = docType.getClass();
                        String docTypePublicId = null;
                        String docTypeSystemId = null;
                        try {
                            Method getPublicId = docTypeClass.getMethod("getPublicId", new Class[0]);
                            if (getPublicId.getReturnType().equals(String.class)) {
                                docTypePublicId = (String)getPublicId.invoke((Object)docType, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Method getSystemId = docTypeClass.getMethod("getSystemId", new Class[0]);
                            if (getSystemId.getReturnType().equals(String.class)) {
                                docTypeSystemId = (String)getSystemId.invoke((Object)docType, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this._printer.enterDTD();
                        this._docTypePublicId = docTypePublicId;
                        this._docTypeSystemId = docTypeSystemId;
                        this.endDTD();
                    }
                }
            }
            case 11: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.serializeNode(child);
                }
                break;
            }
        }
    }

    protected ElementState content() throws IOException {
        ElementState state = this.getElementState();
        if (!this.isDocumentState()) {
            if (state.inCData && !state.doCData) {
                this._printer.printText("]]>");
                state.inCData = false;
            }
            if (state.empty) {
                this._printer.printText('>');
                state.empty = false;
            }
            state.afterElement = false;
            state.afterComment = false;
        }
        return state;
    }

    protected void characters(String text) throws IOException {
        ElementState state = this.content();
        if (state.inCData || state.doCData) {
            if (!state.inCData) {
                this._printer.printText("<![CDATA[");
                state.inCData = true;
            }
            int saveIndent = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printCDATAText(text);
            this._printer.setNextIndent(saveIndent);
        } else if (state.preserveSpace) {
            int saveIndent = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(text, true, state.unescaped);
            this._printer.setNextIndent(saveIndent);
        } else {
            this.printText(text, false, state.unescaped);
        }
    }

    protected abstract String getEntityRef(int var1);

    protected abstract void serializeElement(Element var1) throws IOException;

    protected void serializePreRoot() throws IOException {
        if (this._preRoot != null) {
            for (int i = 0; i < this._preRoot.size(); ++i) {
                this.printText((String)this._preRoot.elementAt(i), true, true);
                if (!this._indenting) continue;
                this._printer.breakLine();
            }
            this._preRoot.removeAllElements();
        }
    }

    protected void printCDATAText(String text) throws IOException {
        int length = text.length();
        for (int index = 0; index < length; ++index) {
            char ch = text.charAt(index);
            if (ch == ']' && index + 2 < length && text.charAt(index + 1) == ']' && text.charAt(index + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                    this.modifyDOMError(msg, (short)1, this.fCurrentNode);
                    this.fDOMErrorHandler.handleError(this.fDOMError);
                }
                this._printer.printText("]]]]><![CDATA[>");
                index += 2;
                continue;
            }
            if (!XMLChar.isValid(ch)) {
                if (++index < length) {
                    this.surrogates(ch, text.charAt(index));
                    continue;
                }
                this.fatalError("The character '" + ch + "' is an invalid XML character");
                continue;
            }
            if (ch >= ' ' && this._encodingInfo.isPrintable(ch) && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t') {
                this._printer.printText(ch);
                continue;
            }
            this._printer.printText("]]>&#x");
            this._printer.printText(Integer.toHexString(ch));
            this._printer.printText(";<![CDATA[");
        }
    }

    protected void surrogates(int high, int low) throws IOException {
        if (XMLChar.isHighSurrogate(high)) {
            if (!XMLChar.isLowSurrogate(low)) {
                this.fatalError("The character '" + (char)low + "' is an invalid XML character");
            } else {
                int supplemental = XMLChar.supplemental((char)high, (char)low);
                if (!XMLChar.isValid(supplemental)) {
                    this.fatalError("The character '" + (char)supplemental + "' is an invalid XML character");
                } else if (this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(supplemental));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(supplemental);
                }
            }
        } else {
            this.fatalError("The character '" + (char)high + "' is an invalid XML character");
        }
    }

    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            while (length-- > 0) {
                char ch = chars[start];
                ++start;
                if (ch == '\n' || ch == '\r' || unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        } else {
            while (length-- > 0) {
                char ch = chars[start];
                ++start;
                if (ch == ' ' || ch == '\f' || ch == '\t' || ch == '\n' || ch == '\r') {
                    this._printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        }
    }

    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            for (int index = 0; index < text.length(); ++index) {
                char ch = text.charAt(index);
                if (ch == '\n' || ch == '\r' || unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        } else {
            for (int index = 0; index < text.length(); ++index) {
                char ch = text.charAt(index);
                if (ch == ' ' || ch == '\f' || ch == '\t' || ch == '\n' || ch == '\r') {
                    this._printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        }
    }

    protected void printDoctypeURL(String url) throws IOException {
        this._printer.printText('\"');
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) == '\"' || url.charAt(i) < ' ' || url.charAt(i) > '\u007f') {
                this._printer.printText('%');
                this._printer.printText(Integer.toHexString(url.charAt(i)));
                continue;
            }
            this._printer.printText(url.charAt(i));
        }
        this._printer.printText('\"');
    }

    protected void printEscaped(int ch) throws IOException {
        String charRef = this.getEntityRef(ch);
        if (charRef != null) {
            this._printer.printText('&');
            this._printer.printText(charRef);
            this._printer.printText(';');
        } else if (ch >= 32 && this._encodingInfo.isPrintable((char)ch) && ch != 247 || ch == 10 || ch == 13 || ch == 9) {
            if (ch < 65536) {
                this._printer.printText((char)ch);
            } else {
                this._printer.printText((char)((ch - 65536 >> 10) + 55296));
                this._printer.printText((char)((ch - 65536 & 0x3FF) + 56320));
            }
        } else {
            this.printHex(ch);
        }
    }

    final void printHex(int ch) throws IOException {
        this._printer.printText("&#x");
        this._printer.printText(Integer.toHexString(ch));
        this._printer.printText(';');
    }

    protected void printEscaped(String source) throws IOException {
        for (int i = 0; i < source.length(); ++i) {
            char lowch;
            int ch = source.charAt(i);
            if ((ch & 0xFC00) == 55296 && i + 1 < source.length() && ((lowch = source.charAt(i + 1)) & 0xFC00) == 56320) {
                ch = 65536 + (ch - 55296 << 10) + lowch - 56320;
                ++i;
            }
            this.printEscaped(ch);
        }
    }

    protected ElementState getElementState() {
        return this._elementStates[this._elementStateCount];
    }

    protected ElementState enterElementState(String namespaceURI, String localName, String rawName, boolean preserveSpace) {
        if (this._elementStateCount + 1 == this._elementStates.length) {
            int i;
            ElementState[] newStates = new ElementState[this._elementStates.length + 10];
            for (i = 0; i < this._elementStates.length; ++i) {
                newStates[i] = this._elementStates[i];
            }
            for (i = this._elementStates.length; i < newStates.length; ++i) {
                newStates[i] = new ElementState();
            }
            this._elementStates = newStates;
        }
        ++this._elementStateCount;
        ElementState state = this._elementStates[this._elementStateCount];
        state.namespaceURI = namespaceURI;
        state.localName = localName;
        state.rawName = rawName;
        state.preserveSpace = preserveSpace;
        state.empty = true;
        state.afterElement = false;
        state.afterComment = false;
        state.inCData = false;
        state.doCData = false;
        state.unescaped = false;
        state.prefixes = this._prefixes;
        this._prefixes = null;
        return state;
    }

    protected ElementState leaveElementState() {
        if (this._elementStateCount > 0) {
            this._prefixes = null;
            --this._elementStateCount;
            return this._elementStates[this._elementStateCount];
        }
        String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "Internal", null);
        throw new IllegalStateException(msg);
    }

    protected boolean isDocumentState() {
        return this._elementStateCount == 0;
    }

    protected String getPrefix(String namespaceURI) {
        String prefix;
        if (this._prefixes != null && (prefix = this._prefixes.get(namespaceURI)) != null) {
            return prefix;
        }
        if (this._elementStateCount == 0) {
            return null;
        }
        for (int i = this._elementStateCount; i > 0; --i) {
            if (this._elementStates[i].prefixes == null || (prefix = this._elementStates[i].prefixes.get(namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    protected DOMError modifyDOMError(String message, short severity, Node node) {
        this.fDOMError.reset();
        this.fDOMError.fMessage = message;
        this.fDOMError.fSeverity = severity;
        this.fDOMError.fLocator = new DOMLocatorImpl(-1, -1, -1, node, null);
        return this.fDOMError;
    }

    protected void fatalError(String message) throws IOException {
        if (this.fDOMErrorHandler == null) {
            throw new IOException(message);
        }
        this.modifyDOMError(message, (short)3, this.fCurrentNode);
        this.fDOMErrorHandler.handleError(this.fDOMError);
    }

    protected void checkUnboundNamespacePrefixedNode(Node node) throws IOException {
    }
}

