/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSAXImporter;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JcrSysViewTransformer
implements DocViewAdapter {
    private static final Logger log = LoggerFactory.getLogger(JcrSysViewTransformer.class);
    private ContentHandler handler;
    private Node tmpNode;
    private String rootName;
    private Node parent;
    private final String existingPath;

    public JcrSysViewTransformer(Node node) throws SAXException, RepositoryException {
        this(node, null);
    }

    JcrSysViewTransformer(Node node, String existingPath) throws RepositoryException, SAXException {
        Session session = node.getSession();
        this.parent = node;
        this.handler = session.getImportContentHandler(node.getPath(), existingPath != null ? 2 : 1);
        String[] prefixes = session.getNamespacePrefixes();
        this.handler.startDocument();
        for (String prefix : prefixes) {
            this.handler.startPrefixMapping(prefix, session.getNamespaceURI(prefix));
        }
        this.existingPath = existingPath;
        if (existingPath != null) {
            Node existingNode = session.getNode(existingPath);
            try {
                NodeIterator iter = existingNode.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    if (this.tmpNode == null) {
                        this.tmpNode = session.getRootNode().addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
                    }
                    try {
                        session.move(child.getPath(), this.tmpNode.getPath() + "/" + child.getName());
                    }
                    catch (RepositoryException e) {
                        log.error("Error while moving child node to temporary location. Child will be removed.", (Throwable)e);
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("error while moving child nodes (ignored)", (Throwable)e);
            }
        }
    }

    @Override
    public List<String> close() throws SAXException {
        this.handler.endDocument();
        ArrayList<String> paths = new ArrayList<String>();
        try {
            if (this.existingPath != null && this.parent.getSession().nodeExists(this.existingPath)) {
                this.addPaths(paths, this.parent.getSession().getNode(this.existingPath));
            } else if (this.rootName != null && this.parent.hasNode(this.rootName)) {
                this.addPaths(paths, this.parent.getNode(this.rootName));
            }
        }
        catch (RepositoryException e) {
            log.error("error while retrieving list of created nodes.");
        }
        if (this.tmpNode != null) {
            try {
                Session session = this.tmpNode.getSession();
                Node node = session.getNode(this.existingPath);
                NodeIterator iter = this.tmpNode.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    String newPath = node.getPath() + "/" + child.getName();
                    try {
                        session.move(child.getPath(), newPath);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to move child back to new location at {} due to: {}. Node will remain in temporary location: {}", new Object[]{newPath, e.getMessage(), child.getPath()});
                    }
                }
                this.tmpNode.remove();
            }
            catch (RepositoryException e) {
                log.error("Error while processing rescued child nodes");
            }
        }
        return paths;
    }

    private void addPaths(List<String> paths, Node node) throws RepositoryException {
        paths.add(node.getPath());
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.addPaths(paths, iter.nextNode());
        }
    }

    @Override
    public void startNode(DocViewNode ni) throws SAXException {
        DocViewSAXImporter.log.debug("Transforming element to sysview {}", (Object)ni.name);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", ni.name);
        this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
        for (DocViewProperty p : ni.props.values()) {
            if (p == null || p.values == null) continue;
            attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", p.name);
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue((int)p.type));
            this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
            for (String v : p.values) {
                this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", DocViewSAXImporter.EMPTY_ATTRIBUTES);
                this.handler.characters(v.toCharArray(), 0, v.length());
                this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
            }
            this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
        }
        if (this.rootName == null) {
            this.rootName = ni.name;
        }
    }

    @Override
    public void endNode() throws SAXException {
        this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
    }
}

