/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.impl.io.legacycnd.Lexer;
import org.apache.jackrabbit.vault.fs.impl.io.legacycnd.ParseException;
import org.apache.jackrabbit.vault.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CNDImporter {
    private static final Logger log = LoggerFactory.getLogger(CNDImporter.class);
    private Lexer lexer;
    private String currentToken;
    private Map<String, String> oldMappings = new HashMap<String, String>();

    public ImportInfoImpl doImport(Node parent, String name, Reader r, String systemId) throws RepositoryException {
        try {
            this.lexer = new Lexer(r, systemId);
            this.nextToken();
            ImportInfoImpl info = this.parse(parent, name);
            for (String prefix : this.oldMappings.keySet()) {
                String uri = this.oldMappings.get(prefix);
                try {
                    parent.getSession().setNamespacePrefix(prefix, uri);
                }
                catch (RepositoryException e) {}
            }
            return info;
        }
        catch (ParseException e) {
            log.error("Error while parsing.", (Throwable)e);
            return null;
        }
    }

    private ImportInfoImpl parse(Node parent, String name) throws ParseException, RepositoryException {
        while (!this.currentTokenEquals("eof") && this.doNameSpace(parent.getSession())) {
        }
        ImportInfoImpl info = new ImportInfoImpl();
        while (!this.currentTokenEquals("eof")) {
            Node node;
            String ntName = this.doNodeTypeName();
            if (name == null) {
                name = ntName;
            }
            if (parent.hasNode(name)) {
                parent.getNode(name).remove();
            }
            if (parent.hasNode(name)) {
                parent.getNode(name).remove();
                node = parent.addNode(name, "nt:nodeType");
                info.onReplaced(node.getPath());
            } else {
                node = parent.addNode(name, "nt:nodeType");
                info.onCreated(node.getPath());
            }
            node.setProperty("jcr:nodeTypeName", name);
            node.setProperty("jcr:hasOrderableChildNodes", false);
            node.setProperty("jcr:isMixin", false);
            this.doSuperTypes(node);
            this.doOptions(node);
            this.doItemDefs(node);
            name = null;
        }
        return info;
    }

    private boolean doNameSpace(Session session) throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return false;
        }
        this.nextToken();
        String prefix = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('=')) {
            this.lexer.fail("Missing = in namespace decl.");
        }
        this.nextToken();
        String uri = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('>')) {
            this.lexer.fail("Missing > in namespace decl.");
        }
        String oldPrefix = null;
        try {
            oldPrefix = session.getNamespacePrefix(uri);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            if (oldPrefix == null) {
                session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
            } else if (!oldPrefix.equals(prefix)) {
                this.oldMappings.put(oldPrefix, uri);
                session.setNamespacePrefix(prefix, uri);
            }
        }
        catch (RepositoryException e) {
            this.lexer.fail("unable to remap namespace", e);
        }
        this.nextToken();
        return true;
    }

    private String doNodeTypeName() throws ParseException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Missing '[' delimiter for beginning of node type name");
        }
        this.nextToken();
        String name = ISO9075.decode((String)this.currentToken);
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
        return name;
    }

    private static void setProperty(Node node, String name, List<String> values) throws RepositoryException {
        node.setProperty(name, values.toArray(new String[values.size()]));
    }

    private static void setProperty(Node node, String name, List<String> values, int type) throws RepositoryException {
        node.setProperty(name, values.toArray(new String[values.size()]), type);
    }

    private void doSuperTypes(Node ntd) throws ParseException, RepositoryException {
        ArrayList<String> supertypes = new ArrayList<String>();
        if (!this.currentTokenEquals('>')) {
            return;
        }
        do {
            this.nextToken();
            supertypes.add(ISO9075.decode((String)this.currentToken));
            this.nextToken();
        } while (this.currentTokenEquals(','));
        CNDImporter.setProperty(ntd, "jcr:supertypes", supertypes);
    }

    private void doOptions(Node ntd) throws ParseException, RepositoryException {
        if (this.currentTokenEquals(Lexer.ORDERABLE)) {
            ntd.setProperty("jcr:hasOrderableChildNodes", true);
            this.nextToken();
            if (this.currentTokenEquals(Lexer.MIXIN)) {
                ntd.setProperty("jcr:isMixin", true);
                this.nextToken();
            }
        } else if (this.currentTokenEquals(Lexer.MIXIN)) {
            ntd.setProperty("jcr:isMixin", true);
            this.nextToken();
            if (this.currentTokenEquals(Lexer.ORDERABLE)) {
                ntd.setProperty("jcr:hasOrderableChildNodes", true);
                this.nextToken();
            }
        }
    }

    private void doItemDefs(Node ntd) throws ParseException, RepositoryException {
        while (this.currentTokenEquals('-') || this.currentTokenEquals('+')) {
            if (this.currentTokenEquals('-')) {
                Node pdi = ntd.addNode("jcr:propertyDefinition");
                this.nextToken();
                this.doPropertyDefinition(pdi);
                continue;
            }
            if (!this.currentTokenEquals('+')) continue;
            Node ndi = ntd.addNode("jcr:childNodeDefinition");
            this.nextToken();
            this.doChildNodeDefinition(ndi);
        }
    }

    private void doPropertyDefinition(Node pdi) throws ParseException, RepositoryException {
        String name = ISO9075.decode((String)this.currentToken);
        if (!name.equals("") && !name.equals("*")) {
            pdi.setProperty("jcr:name", name);
        }
        pdi.setProperty("jcr:autoCreated", false);
        pdi.setProperty("jcr:mandatory", false);
        pdi.setProperty("jcr:multiple", false);
        pdi.setProperty("jcr:onParentVersion", "COPY");
        pdi.setProperty("jcr:protected", false);
        pdi.setProperty("jcr:requiredType", "UNDEFINED");
        this.nextToken();
        int type = this.doPropertyType(pdi);
        this.doPropertyDefaultValue(pdi, type);
        this.doPropertyAttributes(pdi);
        this.doPropertyValueConstraints(pdi);
    }

    private int doPropertyType(Node pdi) throws ParseException, RepositoryException {
        if (!this.currentTokenEquals('(')) {
            return 0;
        }
        this.nextToken();
        int type = 0;
        if (this.currentTokenEquals(Lexer.STRING)) {
            type = 1;
        } else if (this.currentTokenEquals(Lexer.BINARY)) {
            type = 2;
        } else if (this.currentTokenEquals(Lexer.LONG)) {
            type = 3;
        } else if (this.currentTokenEquals(Lexer.DOUBLE)) {
            type = 4;
        } else if (this.currentTokenEquals(Lexer.BOOLEAN)) {
            type = 6;
        } else if (this.currentTokenEquals(Lexer.DATE)) {
            type = 5;
        } else if (this.currentTokenEquals(Lexer.NAME)) {
            type = 7;
        } else if (this.currentTokenEquals(Lexer.PATH)) {
            type = 8;
        } else if (this.currentTokenEquals(Lexer.REFERENCE)) {
            type = 9;
        } else if (this.currentTokenEquals(Lexer.UNDEFINED)) {
            type = 0;
        } else {
            this.lexer.fail("Unknown property type '" + this.currentToken + "' specified");
        }
        pdi.setProperty("jcr:requiredType", PropertyType.nameFromValue((int)type).toUpperCase());
        this.nextToken();
        if (!this.currentTokenEquals(')')) {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
        this.nextToken();
        return type;
    }

    private void doPropertyAttributes(Node pdi) throws ParseException, RepositoryException {
        while (this.currentTokenEquals(Lexer.ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                Value name = pdi.getProperty("jcr:name").getValue();
                if (pdi.getParent().hasProperty("jcr:primaryItemName")) {
                    this.lexer.fail("More than one primary item specified in node type '" + name.getString() + "'");
                }
                pdi.getParent().setProperty("jcr:primaryItemName", name);
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                pdi.setProperty("jcr:autoCreated", true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                pdi.setProperty("jcr:mandatory", true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                pdi.setProperty("jcr:protected", true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                pdi.setProperty("jcr:multiple", true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                pdi.setProperty("jcr:onParentVersion", "COPY");
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                pdi.setProperty("jcr:onParentVersion", "VERSION");
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                pdi.setProperty("jcr:onParentVersion", "INITIALIZE");
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                pdi.setProperty("jcr:onParentVersion", "COMPUTE");
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                pdi.setProperty("jcr:onParentVersion", "IGNORE");
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                pdi.setProperty("jcr:onParentVersion", "ABORT");
            }
            this.nextToken();
        }
    }

    private void doPropertyDefaultValue(Node pdi, int type) throws ParseException, RepositoryException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        ArrayList<String> defaultValues = new ArrayList<String>();
        do {
            this.nextToken();
            defaultValues.add(this.currentToken);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        CNDImporter.setProperty(pdi, "jcr:defaultValues", defaultValues, type);
    }

    private void doPropertyValueConstraints(Node pdi) throws ParseException, RepositoryException {
        if (!this.currentTokenEquals('<')) {
            return;
        }
        ArrayList<String> constraints = new ArrayList<String>();
        do {
            this.nextToken();
            constraints.add(this.currentToken);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        CNDImporter.setProperty(pdi, "jcr:valueConstraints", constraints);
    }

    private void doChildNodeDefinition(Node ndi) throws ParseException, RepositoryException {
        String name = ISO9075.decode((String)this.currentToken);
        if (!name.equals("") && !name.equals("*")) {
            ndi.setProperty("jcr:name", name);
        }
        ndi.setProperty("jcr:autoCreated", false);
        ndi.setProperty("jcr:mandatory", false);
        ndi.setProperty("jcr:sameNameSiblings", false);
        ndi.setProperty("jcr:onParentVersion", "COPY");
        ndi.setProperty("jcr:protected", false);
        ndi.setProperty("jcr:requiredPrimaryTypes", Constants.EMPTY_STRING_ARRAY);
        this.nextToken();
        this.doChildNodeRequiredTypes(ndi);
        this.doChildNodeDefaultType(ndi);
        this.doChildNodeAttributes(ndi);
    }

    private void doChildNodeRequiredTypes(Node ndi) throws ParseException, RepositoryException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        do {
            this.nextToken();
            types.add(ISO9075.decode((String)this.currentToken));
            this.nextToken();
        } while (this.currentTokenEquals(','));
        CNDImporter.setProperty(ndi, "jcr:requiredPrimaryTypes", types);
        this.nextToken();
    }

    private void doChildNodeDefaultType(Node ndi) throws ParseException, RepositoryException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        this.nextToken();
        ndi.setProperty("jcr:defaultPrimaryType", ISO9075.decode((String)this.currentToken));
        this.nextToken();
    }

    private void doChildNodeAttributes(Node ndi) throws ParseException, RepositoryException {
        while (this.currentTokenEquals(Lexer.ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                Value name = ndi.getProperty("jcr:name").getValue();
                if (ndi.getParent().hasProperty("jcr:primaryItemName")) {
                    this.lexer.fail("More than one primary item specified in node type '" + name.getString() + "'");
                }
                ndi.getParent().setProperty("jcr:primaryItemName", name);
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                ndi.setProperty("jcr:autoCreated", true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                ndi.setProperty("jcr:mandatory", true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                ndi.setProperty("jcr:protected", true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                ndi.setProperty("jcr:sameNameSiblings", true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                ndi.setProperty("jcr:onParentVersion", "COPY");
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                ndi.setProperty("jcr:onParentVersion", "VERSION");
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                ndi.setProperty("jcr:onParentVersion", "INITIALIZE");
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                ndi.setProperty("jcr:onParentVersion", "COMPUTE");
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                ndi.setProperty("jcr:onParentVersion", "IGNORE");
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                ndi.setProperty("jcr:onParentVersion", "ABORT");
            }
            this.nextToken();
        }
    }

    private void nextToken() throws ParseException {
        this.currentToken = this.lexer.getNextToken();
    }

    private boolean currentTokenEquals(String[] s) {
        for (String value : s) {
            if (!this.currentToken.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean currentTokenEquals(char c) {
        return this.currentToken.length() == 1 && this.currentToken.charAt(0) == c;
    }

    private boolean currentTokenEquals(String s) {
        return this.currentToken.equals(s);
    }
}

