/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.aggregator;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.vault.fs.DirectoryArtifact;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.Dumpable;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ItemFilterSet;
import org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSerializer;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.jackrabbit.vault.util.Text;

public class FileAggregator
implements Aggregator,
Dumpable {
    private final ItemFilterSet contentFilter = new ItemFilterSet();

    @Override
    public boolean matches(Node node, String path) throws RepositoryException {
        if (node.isNodeType("nt:file")) {
            return node.hasProperty("jcr:content/jcr:data");
        }
        return node.isNodeType("nt:resource");
    }

    @Override
    public boolean includes(Node root, Node node, Property prop, String path) throws RepositoryException {
        if (node.getName().equals("jcr:content")) {
            String name;
            String string = name = path == null ? prop.getName() : Text.getName(path);
            if (name.equals("jcr:data")) {
                return false;
            }
            if (name.equals("jcr:lastModified")) {
                return false;
            }
            if (name.equals("jcr:uuid")) {
                return false;
            }
            if (name.equals("jcr:mimeType")) {
                String expected = MimeTypes.getMimeType(root.getName(), "application/octet-stream");
                return !expected.equals(prop.getString());
            }
            if (name.equals("jcr:encoding") && prop.getString().equals("utf-8")) {
                String mimeType = MimeTypes.getMimeType(root.getName(), "application/octet-stream");
                return MimeTypes.isBinary(mimeType);
            }
        } else if (node == root && node.isNodeType("nt:resource")) {
            String name;
            String string = name = path == null ? prop.getName() : Text.getName(path);
            if (name.equals("jcr:data")) {
                return false;
            }
            if (name.equals("jcr:lastModified")) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean includes(Node root, Node node, String path) throws RepositoryException {
        if (path == null) {
            path = node.getPath();
        }
        int depth = PathUtil.getDepth(path) - root.getDepth();
        boolean isFile = root.isNodeType("nt:file");
        if (depth == 0) {
            return true;
        }
        if (depth == 1 && isFile && node.getName().equals("jcr:content")) {
            return true;
        }
        return !this.contentFilter.isEmpty() && this.contentFilter.contains((Item)node, path, depth);
    }

    @Override
    public boolean hasFullCoverage() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public ArtifactSet createArtifacts(Aggregate aggregate) throws RepositoryException {
        boolean needsDir;
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        Node node = aggregate.getNode();
        ((AggregateManagerImpl)aggregate.getManager()).addNodeTypes(node);
        Node content = node;
        if (content.isNodeType("nt:file")) {
            content = node.getNode("jcr:content");
            ((AggregateManagerImpl)aggregate.getManager()).addNodeTypes(content);
        }
        long lastModified = 0L;
        String encoding = null;
        try {
            lastModified = content.getProperty("jcr:lastModified").getDate().getTimeInMillis();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        String mimeType = null;
        if (content.hasProperty("jcr:mimeType")) {
            try {
                mimeType = content.getProperty("jcr:mimeType").getString();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        if (mimeType == null) {
            mimeType = MimeTypes.getMimeType(node.getName(), "application/octet-stream");
        }
        if (content.hasProperty("jcr:encoding")) {
            try {
                encoding = content.getProperty("jcr:encoding").getString();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        boolean bl = needsDir = !node.getPrimaryNodeType().getName().equals("nt:file");
        if (!needsDir && node.hasProperty("jcr:mixinTypes")) {
            for (Value v : node.getProperty("jcr:mixinTypes").getValues()) {
                if (v.getString().equals("mix:lockable")) continue;
                needsDir = true;
                break;
            }
        }
        if (!needsDir) {
            boolean bl2 = needsDir = !content.getPrimaryNodeType().getName().equals("nt:resource");
        }
        if (!needsDir && content.hasProperty("jcr:mixinTypes")) {
            for (Value v : content.getProperty("jcr:mixinTypes").getValues()) {
                if (v.getString().equals("mix:lockable")) continue;
                needsDir = true;
                break;
            }
        }
        if (!needsDir) {
            boolean bl3 = needsDir = !MimeTypes.matches(node.getName(), mimeType, "application/octet-stream");
        }
        if (!needsDir && encoding != null) {
            needsDir = !"utf-8".equals(encoding) || MimeTypes.isBinary(mimeType);
        }
        String name = aggregate.getName();
        artifacts.add(null, name, "", ArtifactType.FILE, content.getProperty("jcr:data"), lastModified);
        if (needsDir) {
            DirectoryArtifact parent = new DirectoryArtifact(name, ".dir");
            artifacts.add(parent);
            DocViewSerializer ser = new DocViewSerializer(aggregate);
            artifacts.add((Artifact)parent, "", ".content.xml", ArtifactType.PRIMARY, ser, 0L);
        }
        return artifacts;
    }

    @Override
    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Node parent = node.getParent();
        node.remove();
        if (trySave) {
            parent.save();
        }
        return info;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }
}

