/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

class MutableNodeState
extends AbstractNodeState {
    private NodeState base;
    private final Map<String, PropertyState> properties = Maps.newHashMap();
    private final Map<String, MutableNodeState> nodes = Maps.newHashMap();
    private boolean replaced;

    MutableNodeState(@NotNull NodeState base) {
        Preconditions.checkNotNull((Object)base);
        this.base = ModifiedNodeState.unwrap(base, this.properties, this.nodes);
    }

    NodeState snapshot() {
        assert (this.base != null);
        if (this.properties.isEmpty() && this.nodes.isEmpty()) {
            return this.base;
        }
        return new ModifiedNodeState(this.base, this.properties, this.nodes);
    }

    void reset(NodeState newBase) {
        assert (this.base != null);
        Preconditions.checkNotNull((Object)newBase);
        this.base = ModifiedNodeState.unwrap(newBase, this.properties, this.nodes);
    }

    @NotNull
    MutableNodeState setChildNode(String name, NodeState state) throws IllegalArgumentException {
        assert (this.base != null);
        MutableNodeState child = this.nodes.get(name);
        if (child == null) {
            MutableNodeState.checkValidName(name);
            child = new MutableNodeState(state);
            if (this.base.hasChildNode(name)) {
                child.replaced = true;
            }
            this.nodes.put(name, child);
        } else {
            child.replaced = true;
            child.reset(state);
        }
        return child;
    }

    boolean isModified(NodeState before) {
        if (!this.exists()) {
            return false;
        }
        if (this.nodes.isEmpty() && this.properties.isEmpty()) {
            return EqualsDiff.modified(before, this.base);
        }
        for (Map.Entry<String, MutableNodeState> entry : this.nodes.entrySet()) {
            if (entry.getValue().exists() == before.hasChildNode(entry.getKey())) continue;
            return true;
        }
        for (Map.Entry<String, MutableNodeState> entry : this.properties.entrySet()) {
            PropertyState pState = (PropertyState)entry.getValue();
            if (pState != null && pState.equals(before.getProperty(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    boolean isReplaced(NodeState before) {
        return this.replaced;
    }

    boolean isReplaced(NodeState before, String name) {
        return before.hasProperty(name) && (!this.base.equals(before) || this.properties.containsKey(name));
    }

    boolean removeChildNode(String name) {
        assert (this.base != null);
        MutableNodeState child = this.nodes.get(name);
        if (child != null) {
            boolean existed = child.exists();
            child.reset(EmptyNodeState.MISSING_NODE);
            return existed;
        }
        this.nodes.put(name, new MutableNodeState(EmptyNodeState.MISSING_NODE));
        return this.base.hasChildNode(name);
    }

    boolean removeProperty(String name) {
        assert (this.base != null);
        if (this.base.hasProperty(name)) {
            this.properties.put(name, null);
            return true;
        }
        return this.properties.remove(name) != null;
    }

    void setProperty(PropertyState property) {
        String name = property.getName();
        MutableNodeState.checkValidName(name);
        this.properties.put(name, property);
    }

    @Override
    public String toString() {
        assert (this.base != null);
        StringBuilder builder = new StringBuilder();
        builder.append(this.base).append(" + {");
        String separator = " ";
        for (PropertyState propertyState : this.properties.values()) {
            builder.append(separator);
            separator = ", ";
            builder.append(propertyState);
        }
        for (Map.Entry entry : this.nodes.entrySet()) {
            builder.append(separator);
            separator = ", ";
            builder.append((String)entry.getKey()).append(" : ").append(entry.getValue());
        }
        builder.append(" }");
        return builder.toString();
    }

    @Override
    public boolean exists() {
        assert (this.base != null);
        return this.base.exists();
    }

    @Override
    public long getPropertyCount() {
        return ModifiedNodeState.getPropertyCount(this.base, this.properties);
    }

    @Override
    public boolean hasProperty(@NotNull String name) {
        return ModifiedNodeState.hasProperty(this.base, this.properties, name);
    }

    @Override
    public PropertyState getProperty(@NotNull String name) {
        return ModifiedNodeState.getProperty(this.base, this.properties, name);
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return ModifiedNodeState.getProperties(this.base, this.properties, true);
    }

    @Override
    public long getChildNodeCount(long max) {
        assert (this.base != null);
        return ModifiedNodeState.getChildNodeCount(this.base, this.nodes, max);
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        assert (this.base != null);
        NodeState child = this.nodes.get(name);
        if (child != null) {
            return child.exists();
        }
        return this.base.hasChildNode(name);
    }

    MutableNodeState getMutableChildNode(String name) {
        assert (this.base != null);
        MutableNodeState child = this.nodes.get(name);
        if (child == null) {
            child = new MutableNodeState(this.base.getChildNode(name));
            this.nodes.put(name, child);
        }
        return child;
    }

    @Override
    @NotNull
    public NodeState getChildNode(@NotNull String name) {
        NodeState child = this.nodes.get(name);
        if (child == null) {
            child = this.base.getChildNode(name);
        }
        return child;
    }

    @Override
    @NotNull
    public Iterable<String> getChildNodeNames() {
        assert (this.base != null);
        return ModifiedNodeState.getChildNodeNames(this.base, this.nodes, true);
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public NodeBuilder builder() {
        throw new UnsupportedOperationException();
    }
}

