/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

abstract class SinglePropertyState<T>
extends EmptyPropertyState {
    protected SinglePropertyState(@Nonnull String name) {
        super(name);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public abstract Conversions.Converter getConverter();

    private <S> S convertTo(Type<S> type) {
        switch (type.tag()) {
            case 1: {
                return (S)this.getConverter().toString();
            }
            case 2: {
                return (S)this.getConverter().toBinary();
            }
            case 3: {
                return (S)Long.valueOf(this.getConverter().toLong());
            }
            case 4: {
                return (S)Double.valueOf(this.getConverter().toDouble());
            }
            case 5: {
                return (S)this.getConverter().toDate();
            }
            case 6: {
                return (S)Boolean.valueOf(this.getConverter().toBoolean());
            }
            case 7: {
                return (S)this.getConverter().toString();
            }
            case 8: {
                return (S)this.getConverter().toString();
            }
            case 9: {
                return (S)this.getConverter().toString();
            }
            case 10: {
                return (S)this.getConverter().toString();
            }
            case 11: {
                return (S)this.getConverter().toString();
            }
            case 12: {
                return (S)this.getConverter().toDecimal();
            }
        }
        throw new IllegalArgumentException("Unknown type:" + type);
    }

    public abstract T getValue();

    @Nonnull
    public <S> S getValue(Type<S> type) {
        if (type.isArray()) {
            if (this.getType() == type.getBaseType()) {
                return (S)Collections.singleton(this.getValue());
            }
            return (S)Collections.singleton(this.convertTo(type.getBaseType()));
        }
        if (this.getType() == type) {
            return (S)this.getValue();
        }
        return this.convertTo(type);
    }

    @Nonnull
    public <S> S getValue(Type<S> type, int index) {
        Preconditions.checkArgument((!type.isArray() ? 1 : 0) != 0, (Object)"Type must not be an array type");
        if (index != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.getValue(type);
    }

    @Override
    public long size() {
        return ((String)this.convertTo(Type.STRING)).length();
    }

    @Override
    public long size(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.size();
    }

    @Override
    public int count() {
        return 1;
    }
}

