/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Blob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryBasedBlob
implements Blob {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryBasedBlob.class);
    private final Binary binary;

    public BinaryBasedBlob(Binary binary) {
        this.binary = binary;
    }

    @Nonnull
    public InputStream getNewStream() {
        try {
            return this.binary.getStream();
        }
        catch (RepositoryException e) {
            LOG.warn("Error retrieving stream from binary", (Throwable)e);
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    throw new IOException((Throwable)e);
                }
            };
        }
    }

    public long length() {
        try {
            return this.binary.getSize();
        }
        catch (RepositoryException e) {
            LOG.warn("Error determining length of binary", (Throwable)e);
            return -1L;
        }
    }

    public String getReference() {
        return null;
    }

    public String getContentIdentity() {
        return null;
    }
}

