/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RDBDocumentStoreDB {
    DEFAULT("default"){}
    ,
    H2("H2"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 1, 4, this.description);
        }

        @Override
        public String getInitializationStatement() {
            return "create alias if not exists unix_timestamp as $$ long unix_timestamp() { return System.currentTimeMillis()/1000L; } $$;";
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select unix_timestamp()";
        }
    }
    ,
    DERBY("Apache Derby"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 10, 11, this.description);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
            HashMap<String, String> result = new HashMap<String, String>();
            Connection con = null;
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("SELECT T.* FROM TABLE (SYSCS_DIAG.SPACE_TABLE(?,?)) AS T");){
                    stmt.setString(1, catalog.toUpperCase(Locale.ENGLISH));
                    stmt.setString(2, tableName.toUpperCase(Locale.ENGLISH));
                    try (ResultSet rs = stmt.executeQuery();){
                        long totalSize = 0L;
                        long totalIndexSize = 0L;
                        int nindexes = 0;
                        while (rs.next()) {
                            String conglomerateName = rs.getString("CONGLOMERATENAME");
                            int isIndex = rs.getInt("ISINDEX");
                            long numAllocatedPages = rs.getLong("NUMALLOCATEDPAGES");
                            long numFreePages = rs.getLong("NUMFREEPAGES");
                            long numUnfilledPages = rs.getLong("NUMUNFILLEDPAGES");
                            int pageSize = rs.getInt("PAGESIZE");
                            String raw = "NUMALLOCATEDPAGES=" + numAllocatedPages + ", NUMFREEPAGES=" + numFreePages + ", NUMUNFILLEDPAGES=" + numUnfilledPages + ", PAGESIZE=" + pageSize;
                            long size = (long)pageSize * (numAllocatedPages + numFreePages);
                            if (isIndex == 0) {
                                result.put("_data", raw);
                                result.put("storageSize", Long.toString(size));
                            } else {
                                result.put(conglomerateName + "._data", raw);
                                result.put("indexSizes." + conglomerateName, Long.toString(size));
                                totalIndexSize += size;
                                ++nindexes;
                            }
                            totalSize += (long)pageSize * (numAllocatedPages + numFreePages);
                        }
                        result.put("totalSize", Long.toString(totalSize));
                        result.put("totalIndexSize", Long.toString(totalIndexSize));
                        result.put("nindexes", Long.toString(nindexes));
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            return result;
        }
    }
    ,
    POSTGRES("PostgreSQL"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            String scanfor;
            String versionString;
            int p;
            String result = RDBJDBCTools.versionCheck(md, 9, 5, 9, 4, this.description);
            if (result.isEmpty() && md.getDriverMajorVersion() == 9 && md.getDriverMinorVersion() == 4 && (p = (versionString = md.getDriverVersion()).indexOf(scanfor = "9.4.")) >= 0) {
                StringBuilder build = new StringBuilder();
                for (char c : versionString.substring(p + scanfor.length()).toCharArray()) {
                    if (c < '0' || c > '9') break;
                    build.append(c);
                }
                if (Integer.parseInt(build.toString()) < 1208) {
                    result = "Unsupported " + this.description + " driver version: " + md.getDriverVersion() + ", found build " + build + ", but expected at least build 1208";
                }
            }
            return result;
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select extract(epoch from now())::integer";
        }

        @Override
        public String getTableCreationStatement(String tableName, int schema) {
            return "create table " + tableName + " (ID varchar(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, " + (schema >= 1 ? "VERSION smallint, " : "") + (schema >= 2 ? "SDTYPE smallint, SDMAXREVTIME bigint, " : "") + "DATA varchar(16384), BDATA bytea)";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block6: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    String cat = con.getCatalog();
                    stmt = con.prepareStatement("SELECT pg_encoding_to_char(encoding), datcollate FROM pg_database WHERE datname=?");
                    stmt.setString(1, cat);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put("pg_encoding_to_char(encoding)", rs.getString(1));
                        result.put("datcollate", rs.getString(2));
                    }
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block6;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
            Throwable throwable;
            PreparedStatement stmt;
            HashMap<String, String> result = new HashMap<String, String>();
            Connection con = null;
            SortedSet<String> indexNames = Collections.emptySortedSet();
            try {
                TreeSet<String> in = new TreeSet<String>();
                con = ch.getROConnection();
                stmt = con.prepareStatement("SELECT indexname FROM pg_indexes WHERE tablename=?");
                throwable = null;
                try {
                    stmt.setString(1, tableName.toLowerCase(Locale.ENGLISH));
                    ResultSet rs = stmt.executeQuery();
                    Object object = null;
                    try {
                        while (rs.next()) {
                            in.add(rs.getString(1));
                        }
                    }
                    catch (Throwable throwable2) {
                        object = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs != null) {
                            if (object != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Throwable rs) {
                    throwable = rs;
                    throw rs;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable rs) {
                                throwable.addSuppressed(rs);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                con.commit();
                indexNames = in;
                ch.closeConnection(con);
            }
            catch (SQLException ex) {
                try {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    ch.closeConnection(con);
                }
                catch (Throwable throwable4) {
                    ch.closeConnection(con);
                    throw throwable4;
                }
            }
            try {
                StringBuilder query = new StringBuilder("SELECT pg_total_relation_size(?), pg_table_size(?), pg_indexes_size(?)");
                indexNames.forEach(name -> query.append(", pg_relation_size(?)"));
                con = ch.getROConnection();
                stmt = con.prepareStatement(query.toString());
                throwable = null;
                try {
                    int i = 1;
                    stmt.setString(i++, tableName);
                    stmt.setString(i++, tableName);
                    stmt.setString(i++, tableName);
                    for (String name2 : indexNames) {
                        stmt.setString(i++, name2);
                    }
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            i = 1;
                            result.put("storageSize", rs.getString(i++));
                            result.put("size", rs.getString(i++));
                            result.put("totalIndexSize", rs.getString(i++));
                            for (String name3 : indexNames) {
                                result.put("indexSizes." + name3, rs.getString(i++));
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            return result;
        }
    }
    ,
    DB2("DB2"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 10, 5, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select cast (days(current_timestamp - current_timezone) - days('1970-01-01') as integer) * 86400 + midnight_seconds(current_timestamp - current_timezone) from sysibm.sysdummy1";
        }

        @Override
        public String getTableCreationStatement(String tableName, int schema) {
            return "create table " + tableName + " (ID varchar(512) not null, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, " + (schema >= 1 ? "VERSION smallint, " : "") + (schema >= 2 ? "SDTYPE smallint, SDMAXREVTIME bigint, " : "") + "DATA varchar(16384), BDATA blob(" + 0x40000000 + "))";
        }

        @Override
        public List<String> getIndexCreationStatements(String tableName, int schema) {
            ArrayList<String> statements = new ArrayList<String>();
            String pkName = tableName + "_pk";
            statements.add("create unique index " + pkName + " on " + tableName + " ( ID ) cluster");
            statements.add("alter table " + tableName + " add constraint " + pkName + " primary key ( ID )");
            statements.addAll(super.getIndexCreationStatements(tableName, schema));
            return statements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block8: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    String conSchema = ch.getSchema(con);
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT CODEPAGE, COLLATIONSCHEMA, COLLATIONNAME, TABSCHEMA FROM SYSCAT.COLUMNS WHERE COLNAME=? and COLNO=0 AND UPPER(TABNAME)=UPPER(?)");
                    if (conSchema != null) {
                        conSchema = conSchema.trim();
                        sb.append(" AND UPPER(TABSCHEMA)=UPPER(?)");
                    }
                    stmt = con.prepareStatement(sb.toString());
                    stmt.setString(1, "ID");
                    stmt.setString(2, tableName);
                    if (conSchema != null) {
                        stmt.setString(3, conSchema);
                    }
                    rs = stmt.executeQuery();
                    while (rs.next() && result.size() < 20) {
                        String schema = rs.getString("TABSCHEMA").trim();
                        result.put(schema + ".CODEPAGE", rs.getString("CODEPAGE").trim());
                        result.put(schema + ".COLLATIONSCHEMA", rs.getString("COLLATIONSCHEMA").trim());
                        result.put(schema + ".COLLATIONNAME", rs.getString("COLLATIONNAME").trim());
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block8;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
            HashMap<String, String> result = new HashMap<String, String>();
            Connection con = null;
            String tableStats = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.DB2.TABLE_STATS", "card npages mpages fpages overflow pctfree avgrowsize stats_time");
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("SELECT * FROM syscat.tables WHERE tabschema=? and tabname=?");){
                    stmt.setString(1, catalog.toUpperCase(Locale.ENGLISH));
                    stmt.setString(2, tableName.toUpperCase(Locale.ENGLISH));
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String data = this.extractFields(rs, tableStats);
                            result.put("_data", data);
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            String indexStats = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.DB2.INDEX_STATS", "indextype colnames pctfree clusterratio nleaf nlevels fullkeycard density indcard numrids numrids_deleted avgleafkeysize avgnleafkeysize remarks stats_time");
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("SELECT * FROM syscat.indexes WHERE tabschema=? and tabname=?");){
                    stmt.setString(1, catalog.toUpperCase(Locale.ENGLISH));
                    stmt.setString(2, tableName.toUpperCase(Locale.ENGLISH));
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String index = rs.getString("indname");
                            String data = this.extractFields(rs, indexStats);
                            result.put("index." + index + "._data", data);
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            return result;
        }

        @Override
        public String makeIndexConditionalForColumn(String columnName) {
            return " exclude null keys";
        }
    }
    ,
    ORACLE("Oracle"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 12, 1, 12, 2, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select (trunc(sys_extract_utc(systimestamp)) - to_date('01/01/1970', 'MM/DD/YYYY')) * 24 * 60 * 60 + to_number(to_char(sys_extract_utc(systimestamp), 'SSSSS')) from dual";
        }

        @Override
        public String getInitializationStatement() {
            return "ALTER SESSION SET NLS_SORT='BINARY'";
        }

        @Override
        public String getTableCreationStatement(String tableName, int schema) {
            return "create table " + tableName + " (ID varchar(512) not null primary key, MODIFIED number, HASBINARY number, DELETEDONCE number, MODCOUNT number, CMODCOUNT number, DSIZE number, " + (schema >= 1 ? "VERSION number, " : "") + (schema >= 2 ? "SDTYPE number, SDMAXREVTIME number, " : "") + "DATA varchar(4000), BDATA blob)";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block6: {
                Connection con = null;
                Statement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    stmt = con.createStatement();
                    rs = stmt.executeQuery("SELECT PARAMETER, VALUE from NLS_DATABASE_PARAMETERS WHERE PARAMETER IN ('NLS_COMP', 'NLS_CHARACTERSET')");
                    while (rs.next()) {
                        result.put(rs.getString(1), rs.getString(2));
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block6;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
            HashMap<String, String> result = new HashMap<String, String>();
            Connection con = null;
            String tableStats = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.ORACLE.TABLE_STATS", "num_rows blocks avg_row_len sample_size last_analyzed");
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("SELECT * FROM user_tables WHERE table_name=?");){
                    stmt.setString(1, tableName.toUpperCase(Locale.ENGLISH));
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String data = this.extractFields(rs, tableStats);
                            result.put("_data", data.toString());
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            String indexStats = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.ORACLE.INDEX_STATS", "blevel leaf_blocks distinct_keys avg_leaf_blocks_per_key avg_data_blocks_per_key clustering_factor num_rows sample_size last_analyzed");
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("SELECT * FROM user_indexes WHERE table_name=?");){
                    stmt.setString(1, tableName.toUpperCase(Locale.ENGLISH));
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String index = rs.getString("index_name");
                            String data = this.extractFields(rs, indexStats);
                            result.put("index." + index + "._data", data);
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            return result;
        }

        @Override
        public String getSmallintType() {
            return "number";
        }

        @Override
        public String getBigintType() {
            return "number";
        }
    }
    ,
    MYSQL("MySQL"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 5, 5, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select unix_timestamp()";
        }

        @Override
        public String getTableCreationStatement(String tableName, int schema) {
            return "create table " + tableName + " (ID varbinary(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, " + (schema >= 1 ? "VERSION smallint, " : "") + (schema >= 2 ? "SDTYPE smallint, SDMAXREVTIME bigint, " : "") + "DATA varchar(16000), BDATA longblob)";
        }

        @Override
        public FETCHFIRSTSYNTAX getFetchFirstSyntax() {
            return FETCHFIRSTSYNTAX.LIMIT;
        }

        @Override
        public RDBJDBCTools.PreparedStatementComponent getConcatQuery(final String appendData, int dataOctetLimit) {
            return new RDBJDBCTools.PreparedStatementComponent(){

                @Override
                public String getStatementComponent() {
                    return "CONCAT(DATA, ?)";
                }

                @Override
                public int setParameters(PreparedStatement stmt, int startIndex) throws SQLException {
                    stmt.setString(startIndex++, appendData);
                    return startIndex;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block7: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    stmt = con.prepareStatement("SHOW TABLE STATUS LIKE ?");
                    stmt.setString(1, tableName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put("collation", rs.getString("Collation"));
                    }
                    rs.close();
                    stmt.close();
                    stmt = con.prepareStatement("SHOW VARIABLES WHERE variable_name LIKE 'character\\_set\\_%' OR variable_name LIKE 'collation%' OR variable_name = 'max_allowed_packet'");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put(rs.getString(1), rs.getString(2));
                    }
                    rs.close();
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block7;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
            HashMap<String, String> result = new HashMap<String, String>();
            Connection con = null;
            String tableStats = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.MYSQL.TABLE_STATS", "engine version row_format rows avg_row_length data_length index_length data_free collation");
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("show table status from " + catalog + " where name=?");){
                    stmt.setString(1, tableName.toUpperCase(Locale.ENGLISH));
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            String data = this.extractFields(rs, tableStats);
                            result.put("_data", data.toString());
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            String indexStats = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.MYSQL.INDEX_STATS", "column_name cardinality index_type sub_part");
            try {
                con = ch.getROConnection();
                try (PreparedStatement stmt = con.prepareStatement("show index from " + tableName + " in " + catalog);
                     ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        String index = rs.getString("key_name");
                        String data = this.extractFields(rs, indexStats);
                        result.put("index." + index + "._data", data);
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            return result;
        }
    }
    ,
    MSSQL("Microsoft SQL Server"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 11, 0, this.description);
        }

        @Override
        public String getTableCreationStatement(String tableName, int schema) {
            return "create table " + tableName + " (ID varbinary(512) not null, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, " + (schema >= 1 ? "VERSION smallint, " : "") + (schema >= 2 ? "SDTYPE smallint, SDMAXREVTIME bigint, " : "") + "DATA nvarchar(4000), BDATA varbinary(max), constraint " + tableName + "_PK primary key clustered (ID ASC))";
        }

        @Override
        public FETCHFIRSTSYNTAX getFetchFirstSyntax() {
            return FETCHFIRSTSYNTAX.TOP;
        }

        @Override
        public RDBJDBCTools.PreparedStatementComponent getConcatQuery(final String appendData, final int dataOctetLimit) {
            return new RDBJDBCTools.PreparedStatementComponent(){

                @Override
                public String getStatementComponent() {
                    return "CASE WHEN LEN(DATA) < ? THEN (DATA + CAST(? AS nvarchar(" + dataOctetLimit + "))) ELSE (DATA + CAST(DATA AS nvarchar(max))) END";
                }

                @Override
                public int setParameters(PreparedStatement stmt, int startIndex) throws SQLException {
                    stmt.setInt(startIndex++, dataOctetLimit - appendData.length());
                    stmt.setString(startIndex++, appendData);
                    return startIndex;
                }
            };
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select datediff(second, dateadd(second, datediff(second, getutcdate(), getdate()), '1970-01-01'), getdate())";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block6: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    String cat = con.getCatalog();
                    stmt = con.prepareStatement("SELECT collation_name FROM sys.databases WHERE name=?");
                    stmt.setString(1, cat);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put("collation_name", rs.getString(1));
                    }
                    rs.close();
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block6;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }

        private long parseSize(String readable) {
            try {
                if (readable != null && readable.endsWith(" KB")) {
                    return 1024L * Long.parseLong(readable.substring(0, readable.length() - 3));
                }
                return -1L;
            }
            catch (NumberFormatException ex) {
                return -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
            Throwable throwable;
            ResultSet rs2;
            Throwable throwable2;
            PreparedStatement stmt;
            HashMap<String, String> result = new HashMap<String, String>();
            Connection con = null;
            try {
                con = ch.getROConnection();
                stmt = con.prepareStatement("exec sp_spaceused ?");
                throwable2 = null;
                try {
                    stmt.setString(1, tableName.toLowerCase(Locale.ENGLISH));
                    rs2 = stmt.executeQuery();
                    throwable = null;
                    try {
                        while (rs2.next()) {
                            long treserved = this.parseSize(rs2.getString("reserved"));
                            long tdata = this.parseSize(rs2.getString("data"));
                            long tindexSize = this.parseSize(rs2.getString("index_size"));
                            long tunused = this.parseSize(rs2.getString("unused"));
                            if (treserved >= 0L && tdata >= 0L && tindexSize >= 0L && tunused >= 0L) {
                                result.put("storageSize", Long.toString(treserved + tdata + tindexSize + tunused));
                                result.put("size", Long.toString(treserved + tdata + tunused));
                                result.put("totalIndexSize", Long.toString(tindexSize));
                            }
                            String data = this.extractFields(rs2, "rows reserved data index_size unused");
                            result.put("_data", data);
                        }
                    }
                    catch (Throwable treserved) {
                        throwable = treserved;
                        throw treserved;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable treserved) {
                                    throwable.addSuppressed(treserved);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                    con.commit();
                }
                catch (Throwable rs2) {
                    throwable2 = rs2;
                    throw rs2;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable rs2) {
                                throwable2.addSuppressed(rs2);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            try {
                con = ch.getROConnection();
                stmt = con.prepareStatement("SELECT i.[name] AS name, SUM(s.[row_count]) as rows, SUM(s.[used_page_count] * 8) as usedKB, SUM(s.[reserved_page_count] * 8) as reservedKB FROM sys.dm_db_partition_stats AS s INNER JOIN sys.indexes AS i ON s.[object_id] = i.[object_id]     AND s.[index_id] = i.[index_id] WHERE i.[object_id]=OBJECT_ID(?) GROUP BY i.[name]");
                throwable2 = null;
                try {
                    stmt.setString(1, tableName.toLowerCase(Locale.ENGLISH));
                    rs2 = stmt.executeQuery();
                    throwable = null;
                    try {
                        while (rs2.next()) {
                            String index = rs2.getString("name");
                            String data = this.extractFields(rs2, "rows usedKB reservedKB");
                            result.put("index." + index + "._data", data);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                    con.commit();
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                con.commit();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                LOG.debug("while getting diagnostics", (Throwable)ex);
            }
            finally {
                ch.closeConnection(con);
            }
            return result;
        }

        @Override
        public String makeIndexConditionalForColumn(String columnName) {
            return " where " + columnName + " is not null";
        }
    };

    private static final Logger LOG;
    private static final String SYSPROP_PREFIX = "org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore";
    protected String description;

    public String checkVersion(DatabaseMetaData md) throws SQLException {
        return "Unknown database type: " + md.getDatabaseProductName();
    }

    public FETCHFIRSTSYNTAX getFetchFirstSyntax() {
        return FETCHFIRSTSYNTAX.FETCHFIRST;
    }

    public String getCurrentTimeStampInSecondsSyntax() {
        return "";
    }

    public RDBJDBCTools.PreparedStatementComponent getConcatQuery(final String appendData, final int dataOctetLimit) {
        return new RDBJDBCTools.PreparedStatementComponent(){

            @Override
            public String getStatementComponent() {
                return "DATA || CAST(? AS varchar(" + dataOctetLimit + "))";
            }

            @Override
            public int setParameters(PreparedStatement stmt, int startIndex) throws SQLException {
                stmt.setString(startIndex++, appendData);
                return startIndex;
            }
        };
    }

    @NotNull
    public String getInitializationStatement() {
        return "";
    }

    public String getTableCreationStatement(String tableName, int schema) {
        return "create table " + tableName + " (ID varchar(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, " + (schema >= 1 ? "VERSION smallint, " : "") + (schema >= 2 ? "SDTYPE smallint, SDMAXREVTIME bigint, " : "") + "DATA varchar(16384), BDATA blob(" + 0x40000000 + "))";
    }

    public List<String> getIndexCreationStatements(String tableName, int level) {
        ArrayList result = Lists.newArrayList();
        result.add("create index " + tableName + "_MOD on " + tableName + " (MODIFIED)");
        if (level == 2) {
            result.add("create index " + tableName + "_VSN on " + tableName + " (VERSION)");
            result.add("create index " + tableName + "_SDT on " + tableName + " (SDTYPE)" + this.makeIndexConditionalForColumn("SDTYPE"));
            result.add("create index " + tableName + "_SDM on " + tableName + " (SDMAXREVTIME)" + this.makeIndexConditionalForColumn("SDMAXREVTIME"));
        }
        return result;
    }

    public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
        return "";
    }

    public Map<String, String> getAdditionalStatistics(RDBConnectionHandler ch, String catalog, String tableName) {
        return Collections.emptyMap();
    }

    public String getSmallintType() {
        return "smallint";
    }

    public String getBigintType() {
        return "bigint";
    }

    public String makeIndexConditionalForColumn(String columnName) {
        return "";
    }

    public String getModifiedIndexStatement(String tableName) {
        return "create index " + tableName + "_MOD on " + tableName + " (MODIFIED)";
    }

    public List<String> getTableUpgradeStatements(String tableName, int level) {
        String smallint = this.getSmallintType();
        String bigint = this.getBigintType();
        if (level == 1) {
            return Collections.singletonList("alter table " + tableName + " add VERSION " + smallint);
        }
        if (level == 2) {
            String[] statements = new String[]{"alter table " + tableName + " add SDTYPE " + smallint, "alter table " + tableName + " add SDMAXREVTIME " + bigint, "create index " + tableName + "_VSN on " + tableName + " (VERSION)", "create index " + tableName + "_SDT on " + tableName + " (SDTYPE)" + this.makeIndexConditionalForColumn("SDTYPE"), "create index " + tableName + "_SDM on " + tableName + " (SDMAXREVTIME)" + this.makeIndexConditionalForColumn("SDMAXREVTIME")};
            return Arrays.asList(statements);
        }
        throw new IllegalArgumentException("level must be 1 or 2");
    }

    protected String extractFields(ResultSet rs, String indexStats) throws SQLException {
        StringBuilder data = new StringBuilder();
        for (String f : indexStats.split(" ")) {
            String fn = f.trim();
            if (fn.isEmpty()) continue;
            if (data.length() != 0) {
                data.append(", ");
            }
            String v = rs.getString(fn);
            data.append(fn).append(": ").append(v == null ? v : v.trim());
        }
        return data.toString();
    }

    private RDBDocumentStoreDB(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    @NotNull
    public static RDBDocumentStoreDB getValue(String desc) {
        for (RDBDocumentStoreDB db : RDBDocumentStoreDB.values()) {
            if (db.description.equals(desc)) {
                return db;
            }
            if (db != DB2 || !desc.startsWith("DB2/")) continue;
            return db;
        }
        LOG.error("DB type " + desc + " unknown, trying default settings");
        RDBDocumentStoreDB.DEFAULT.description = desc + " - using default settings";
        return DEFAULT;
    }

    static {
        LOG = LoggerFactory.getLogger(RDBDocumentStoreDB.class);
    }

    public static enum FETCHFIRSTSYNTAX {
        FETCHFIRST,
        LIMIT,
        TOP;

    }
}

