/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClient;
import com.mongodb.session.ClientSession;
import com.mongodb.session.ServerSession;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

class MongoSessionFactory {
    private final MongoClient client;
    private final ClientSessionOptions options;
    private BsonDocument clusterTime;
    private BsonTimestamp operationTime;

    MongoSessionFactory(MongoClient client) {
        this.client = client;
        this.options = ClientSessionOptions.builder().causallyConsistent(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientSession createClientSession() {
        ClientSession s = this.client.startSession(this.options);
        MongoSessionFactory mongoSessionFactory = this;
        synchronized (mongoSessionFactory) {
            s.advanceClusterTime(this.clusterTime);
            s.advanceOperationTime(this.operationTime);
        }
        return new TrackingClientSession(s);
    }

    private class TrackingClientSession
    implements ClientSession {
        private final ClientSession session;

        TrackingClientSession(ClientSession session) {
            this.session = session;
        }

        public ClientSessionOptions getOptions() {
            return this.session.getOptions();
        }

        public boolean isCausallyConsistent() {
            return this.session.isCausallyConsistent();
        }

        public Object getOriginator() {
            return this.session.getOriginator();
        }

        public ServerSession getServerSession() {
            return this.session.getServerSession();
        }

        public BsonTimestamp getOperationTime() {
            return this.session.getOperationTime();
        }

        public void advanceOperationTime(BsonTimestamp operationTime) {
            this.session.advanceOperationTime(operationTime);
        }

        public void advanceClusterTime(BsonDocument clusterTime) {
            this.session.advanceClusterTime(clusterTime);
        }

        public BsonDocument getClusterTime() {
            return this.session.getClusterTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            TrackingClientSession trackingClientSession = this;
            synchronized (trackingClientSession) {
                this.session.advanceClusterTime(MongoSessionFactory.this.clusterTime);
                MongoSessionFactory.this.clusterTime = this.session.getClusterTime();
                this.session.advanceOperationTime(MongoSessionFactory.this.operationTime);
                MongoSessionFactory.this.operationTime = this.session.getOperationTime();
            }
            this.session.close();
        }
    }
}

