/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(VersionGCSupport.class);
    private final DocumentStore store;

    public VersionGCSupport(DocumentStore store) {
        this.store = store;
    }

    public Iterable<NodeDocument> getPossiblyDeletedDocs(final long fromModified, final long toModified) {
        return Iterables.filter(Utils.getSelectedDocuments(this.store, "_deletedOnce", 1L), (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument input) {
                return input.wasDeletedOnce() && this.modifiedGreaterThanEquals(input, fromModified) && this.modifiedLessThan(input, toModified);
            }

            private boolean modifiedGreaterThanEquals(NodeDocument doc, long time) {
                Long modified = doc.getModified();
                return modified != null && modified.compareTo(NodeDocument.getModifiedInSecs(time)) >= 0;
            }

            private boolean modifiedLessThan(NodeDocument doc, long time) {
                Long modified = doc.getModified();
                return modified != null && modified.compareTo(NodeDocument.getModifiedInSecs(time)) < 0;
            }
        });
    }

    @NotNull
    public DocumentStore getDocumentStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSplitDocuments(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        SplitDocumentCleanUp cu = this.createCleanUp(gcTypes, sweepRevs, oldestRevTimeStamp, stats);
        try {
            stats.splitDocGCCount += cu.disconnect().deleteSplitDocuments();
        }
        finally {
            Utils.closeIfCloseable(cu);
        }
    }

    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new SplitDocumentCleanUp(this.store, stats, this.identifyGarbage(gcTypes, sweepRevs, oldestRevTimeStamp));
    }

    protected Iterable<NodeDocument> identifyGarbage(final Set<NodeDocument.SplitDocType> gcTypes, final RevisionVector sweepRevs, final long oldestRevTimeStamp) {
        return Iterables.filter(Utils.getAllDocuments(this.store), (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument doc) {
                return gcTypes.contains((Object)doc.getSplitDocType()) && doc.hasAllRevisionLessThan(oldestRevTimeStamp) && !VersionGCSupport.isDefaultNoBranchSplitNewerThan(doc, sweepRevs);
            }
        });
    }

    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        long ts = 0L;
        long now = clock.getTime();
        long duration = (now - ts) / 2L;
        while (duration > precisionMs) {
            LOG.debug("find oldest _deletedOnce, check < {}", (Object)Utils.timestampToString(ts + duration));
            Iterable<NodeDocument> docs = this.getPossiblyDeletedDocs(ts, ts + duration);
            if (docs.iterator().hasNext()) {
                duration /= 2L;
            } else {
                ts += duration;
                duration /= 2L;
            }
            Utils.closeIfCloseable(docs);
        }
        LOG.debug("find oldest _deletedOnce to be {}", (Object)Utils.timestampToString(ts));
        return ts;
    }

    public long getDeletedOnceCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getDeletedOnceCount()");
    }

    protected static boolean isDefaultNoBranchSplitNewerThan(NodeDocument doc, RevisionVector sweepRevs) {
        if (doc.getSplitDocType() != NodeDocument.SplitDocType.DEFAULT_NO_BRANCH) {
            return false;
        }
        Revision r = (Revision)Iterables.getFirst(doc.getAllChanges(), null);
        return r != null && sweepRevs.isRevisionNewer(r);
    }
}

