/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TieredDiffCache
extends DiffCache {
    private Cache<RevisionsKey, RevisionsKey> localDiffMisses = CacheBuilder.newBuilder().maximumSize(128L).build();
    private final int clusterId;
    private final DiffCache localCache;
    private final DiffCache memoryCache;

    TieredDiffCache(DocumentNodeStoreBuilder<?> builder, int clusterId) {
        this.clusterId = clusterId;
        this.localCache = new LocalDiffCache(builder);
        this.memoryCache = new MemoryDiffCache(builder);
    }

    @Override
    public String getChanges(@NotNull RevisionVector from, @NotNull RevisionVector to, @NotNull String path, @Nullable DiffCache.Loader loader) {
        RevisionsKey k;
        if (Utils.isLocalChange(from, to, this.clusterId) && this.localDiffMisses.getIfPresent((Object)(k = new RevisionsKey(from, to))) == null) {
            String changes = this.localCache.getChanges(from, to, path, null);
            if (changes != null) {
                return changes;
            }
            this.localDiffMisses.put((Object)k, (Object)k);
        }
        return this.memoryCache.getChanges(from, to, path, loader);
    }

    @Override
    @NotNull
    public DiffCache.Entry newEntry(@NotNull RevisionVector from, @NotNull RevisionVector to, boolean local) {
        if (local) {
            return this.localCache.newEntry(from, to, true);
        }
        return this.memoryCache.newEntry(from, to, false);
    }

    @Override
    @NotNull
    public Iterable<CacheStats> getStats() {
        return Iterables.concat(this.localCache.getStats(), this.memoryCache.getStats());
    }
}

