/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RevisionVector
implements Iterable<Revision>,
Comparable<RevisionVector>,
CacheValue {
    private static final Logger log = LoggerFactory.getLogger(RevisionVector.class);
    private static final RevisionVector EMPTY = new RevisionVector(new Revision[0]);
    private final Revision[] revisions;
    private int hash;

    private RevisionVector(@NotNull Revision[] revisions, boolean checkUniqueClusterIds, boolean sort) {
        Preconditions.checkNotNull((Object)revisions);
        if (checkUniqueClusterIds) {
            RevisionVector.checkUniqueClusterIds(revisions);
        }
        if (sort) {
            Arrays.sort(revisions, RevisionComparator.INSTANCE);
        }
        this.revisions = revisions;
    }

    public RevisionVector(Revision ... revisions) {
        this(Arrays.copyOf(revisions, revisions.length), true, true);
    }

    public RevisionVector(@NotNull Iterable<Revision> revisions) {
        this((Revision[])Iterables.toArray(revisions, Revision.class), true, true);
    }

    public RevisionVector(@NotNull Set<Revision> revisions) {
        this((Revision[])Iterables.toArray(revisions, Revision.class), false, true);
    }

    public RevisionVector update(@NotNull Revision revision) {
        boolean sort;
        Revision[] newRevisions;
        Preconditions.checkNotNull((Object)revision);
        Revision existing = null;
        for (int i = 0; i < this.revisions.length; ++i) {
            Revision r = this.revisions[i];
            if (r.getClusterId() != revision.getClusterId()) continue;
            existing = r;
            break;
        }
        if (existing != null) {
            if (revision.equals(existing)) {
                return this;
            }
            newRevisions = Arrays.copyOf(this.revisions, this.revisions.length);
            newRevisions[i] = revision;
            sort = false;
        } else {
            newRevisions = new Revision[this.revisions.length + 1];
            System.arraycopy(this.revisions, 0, newRevisions, 0, this.revisions.length);
            newRevisions[this.revisions.length] = revision;
            sort = true;
        }
        return new RevisionVector(newRevisions, false, sort);
    }

    public RevisionVector remove(int clusterId) {
        if (this.revisions.length == 0) {
            return this;
        }
        boolean found = false;
        for (Revision r : this.revisions) {
            if (r.getClusterId() == clusterId) {
                found = true;
                break;
            }
            if (r.getClusterId() > clusterId) break;
        }
        if (!found) {
            return this;
        }
        Revision[] revs = new Revision[this.revisions.length - 1];
        int idx = 0;
        for (Revision r : this.revisions) {
            if (r.getClusterId() == clusterId) continue;
            revs[idx++] = r;
        }
        return new RevisionVector(revs, false, false);
    }

    public RevisionVector pmin(@NotNull RevisionVector vector) {
        Revision r;
        Revision other;
        if (this.revisions.length == 1 && vector.revisions.length == 1) {
            if (this.revisions[0].getClusterId() == vector.revisions[0].getClusterId()) {
                return this.revisions[0].compareRevisionTime(vector.revisions[0]) < 0 ? this : vector;
            }
            return EMPTY;
        }
        int capacity = Math.min(this.revisions.length, vector.revisions.length);
        ArrayList pmin = Lists.newArrayListWithCapacity((int)capacity);
        PeekingIterator it = Iterators.peekingIterator(vector.iterator());
        Revision[] revisionArray = this.revisions;
        int n = revisionArray.length;
        for (int i = 0; i < n && (other = this.peekRevision((PeekingIterator<Revision>)it, (r = revisionArray[i]).getClusterId())) != null; ++i) {
            if (other.getClusterId() != r.getClusterId()) continue;
            pmin.add(Utils.min(r, other));
        }
        return new RevisionVector((Revision[])Iterables.toArray((Iterable)pmin, Revision.class), false, false);
    }

    public RevisionVector pmax(@NotNull RevisionVector vector) {
        if (this.revisions.length == 1 && vector.revisions.length == 1) {
            if (this.revisions[0].getClusterId() == vector.revisions[0].getClusterId()) {
                return this.revisions[0].compareRevisionTime(vector.revisions[0]) > 0 ? this : vector;
            }
            return new RevisionVector(this.revisions[0], vector.revisions[0]);
        }
        int capacity = Math.max(this.revisions.length, vector.revisions.length);
        ArrayList pmax = Lists.newArrayListWithCapacity((int)capacity);
        PeekingIterator it = Iterators.peekingIterator(vector.iterator());
        for (Revision r : this.revisions) {
            while (it.hasNext() && ((Revision)it.peek()).getClusterId() < r.getClusterId()) {
                pmax.add(it.next());
            }
            Revision other = this.peekRevision((PeekingIterator<Revision>)it, r.getClusterId());
            if (other != null && other.getClusterId() == r.getClusterId()) {
                pmax.add(Utils.max(r, other));
                it.next();
                continue;
            }
            pmax.add(r);
        }
        Iterators.addAll((Collection)pmax, (Iterator)it);
        return new RevisionVector((Revision[])Iterables.toArray((Iterable)pmax, Revision.class), false, false);
    }

    public RevisionVector difference(RevisionVector vector) {
        ArrayList diff = Lists.newArrayListWithCapacity((int)this.revisions.length);
        PeekingIterator it = Iterators.peekingIterator(vector.iterator());
        for (Revision r : this.revisions) {
            Revision other = this.peekRevision((PeekingIterator<Revision>)it, r.getClusterId());
            if (r.equals(other)) continue;
            diff.add(r);
        }
        return new RevisionVector((Revision[])Iterables.toArray((Iterable)diff, Revision.class), false, false);
    }

    public boolean isRevisionNewer(@NotNull Revision revision) {
        Preconditions.checkNotNull((Object)revision);
        for (Revision r : this.revisions) {
            if (r.getClusterId() == revision.getClusterId()) {
                return r.compareRevisionTime(revision) < 0;
            }
            if (r.getClusterId() > revision.getClusterId()) break;
        }
        return true;
    }

    public boolean isBranch() {
        for (Revision r : this.revisions) {
            if (!r.isBranch()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Revision getBranchRevision() {
        for (Revision r : this.revisions) {
            if (!r.isBranch()) continue;
            return r;
        }
        throw new IllegalStateException("This vector does not contain a branch revision: " + this);
    }

    public Revision getRevision(int clusterId) {
        for (Revision r : this.revisions) {
            int cmp = Ints.compare((int)r.getClusterId(), (int)clusterId);
            if (cmp == 0) {
                return r;
            }
            if (cmp > 0) break;
        }
        return null;
    }

    public String asString() {
        int len = this.revisions.length;
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * Revision.REV_STRING_APPROX_SIZE + len - 1);
        return this.toStringBuilder(sb).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        for (int i = 0; i < this.revisions.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            this.revisions[i].toStringBuilder(sb);
        }
        return sb;
    }

    public static RevisionVector fromString(String s) {
        if (s.isEmpty()) {
            return EMPTY;
        }
        String[] list = s.split(",");
        Revision[] revisions = new Revision[list.length];
        for (int i = 0; i < list.length; ++i) {
            revisions[i] = Revision.fromString(list[i]);
        }
        return new RevisionVector(revisions);
    }

    public RevisionVector asTrunkRevision() {
        if (!this.isBranch()) {
            return this;
        }
        Revision[] revs = new Revision[this.revisions.length];
        for (int i = 0; i < this.revisions.length; ++i) {
            revs[i] = this.revisions[i].asTrunkRevision();
        }
        return new RevisionVector(revs, false, false);
    }

    public RevisionVector asBranchRevision(int clusterId) {
        boolean found = false;
        Revision[] revs = new Revision[this.revisions.length];
        for (int i = 0; i < this.revisions.length; ++i) {
            Revision r = this.revisions[i];
            if (r.getClusterId() == clusterId) {
                r = r.asBranchRevision();
                found = true;
            }
            revs[i] = r;
        }
        if (!found) {
            throw new IllegalArgumentException("RevisionVector [" + this.asString() + "] does not have a revision for clusterId " + clusterId);
        }
        return new RevisionVector(revs, false, false);
    }

    public int getDimensions() {
        return this.revisions.length;
    }

    public int getMemory() {
        long size = 32L + (long)this.revisions.length * 36L;
        if (size > Integer.MAX_VALUE) {
            log.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int compareTo(@NotNull RevisionVector other) {
        Iterator<Revision> it = other.iterator();
        for (Revision r : this.revisions) {
            if (!it.hasNext()) {
                return 1;
            }
            Revision otherRev = it.next();
            int cmp = -Ints.compare((int)r.getClusterId(), (int)otherRev.getClusterId());
            if (cmp != 0) {
                return cmp;
            }
            cmp = r.compareTo(otherRev);
            if (cmp == 0) continue;
            return cmp;
        }
        return it.hasNext() ? -1 : 0;
    }

    @Override
    public Iterator<Revision> iterator() {
        return new AbstractIterator<Revision>(){
            int i = 0;

            protected Revision computeNext() {
                if (this.i >= RevisionVector.this.revisions.length) {
                    return (Revision)this.endOfData();
                }
                return RevisionVector.this.revisions[this.i++];
            }
        };
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionVector other = (RevisionVector)o;
        return Arrays.equals(this.revisions, other.revisions);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.revisions);
        }
        return this.hash;
    }

    @Nullable
    private Revision peekRevision(PeekingIterator<Revision> it, int minClusterId) {
        while (it.hasNext() && ((Revision)it.peek()).getClusterId() < minClusterId) {
            it.next();
        }
        return it.hasNext() ? (Revision)it.peek() : null;
    }

    private static void checkUniqueClusterIds(Revision[] revisions) throws IllegalArgumentException {
        if (revisions.length < 2) {
            return;
        }
        HashSet known = Sets.newHashSetWithExpectedSize((int)revisions.length);
        for (Revision revision : revisions) {
            if (known.add(revision.getClusterId())) continue;
            throw new IllegalArgumentException("Multiple revisions with clusterId " + revision.getClusterId());
        }
    }

    private static final class RevisionComparator
    implements Comparator<Revision> {
        private static final Comparator<Revision> INSTANCE = new RevisionComparator();

        private RevisionComparator() {
        }

        @Override
        public int compare(Revision o1, Revision o2) {
            return Ints.compare((int)o1.getClusterId(), (int)o2.getClusterId());
        }
    }
}

