/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

class ResetDiff
implements NodeStateDiff {
    private final Revision revision;
    private final String path;
    private final Map<String, UpdateOp> operations;
    private UpdateOp update;

    ResetDiff(@NotNull Revision revision, @NotNull Map<String, UpdateOp> operations) {
        this(revision, "/", operations);
    }

    private ResetDiff(@NotNull Revision revision, @NotNull String path, @NotNull Map<String, UpdateOp> operations) {
        this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.operations = (Map)Preconditions.checkNotNull(operations);
    }

    public boolean propertyAdded(PropertyState after) {
        this.getUpdateOp().removeMapEntry(after.getName(), this.revision);
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.getUpdateOp().removeMapEntry(after.getName(), this.revision);
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.getUpdateOp().removeMapEntry(before.getName(), this.revision);
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        NodeDocument.removeCommitRoot(this.getUpdateOp(), this.revision);
        String p = PathUtils.concat((String)this.path, (String)name);
        ResetDiff diff = new ResetDiff(this.revision, p, this.operations);
        UpdateOp op = diff.getUpdateOp();
        NodeDocument.removeDeleted(op, this.revision);
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)diff);
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        String p = PathUtils.concat((String)this.path, (String)name);
        return after.compareAgainstBaseState(before, (NodeStateDiff)new ResetDiff(this.revision, p, this.operations));
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        String p = PathUtils.concat((String)this.path, (String)name);
        ResetDiff diff = new ResetDiff(this.revision, p, this.operations);
        NodeDocument.removeDeleted(diff.getUpdateOp(), this.revision);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, (NodeStateDiff)diff);
    }

    Map<String, UpdateOp> getOperations() {
        return this.operations;
    }

    private UpdateOp getUpdateOp() {
        if (this.update == null) {
            this.update = this.operations.get(this.path);
            if (this.update == null) {
                String id = Utils.getIdFromPath(this.path);
                this.update = new UpdateOp(id, false);
                this.operations.put(this.path, this.update);
            }
            NodeDocument.removeRevision(this.update, this.revision);
            NodeDocument.removeCommitRoot(this.update, this.revision);
        }
        return this.update;
    }
}

