/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class DocumentNodeBuilder
extends AbstractDocumentNodeBuilder {
    private final DocumentRootBuilder root;
    private NodeState base;
    private NodeState rootBase;

    DocumentNodeBuilder(MemoryNodeBuilder base, String name, DocumentRootBuilder root) {
        super(base, name);
        this.root = (DocumentRootBuilder)((Object)Preconditions.checkNotNull((Object)((Object)root)));
    }

    @NotNull
    public NodeState getBaseState() {
        if (this.base == null || this.rootBase != this.root.getBaseState()) {
            this.base = this.getParent().getBaseState().getChildNode(this.getName());
            this.rootBase = this.root.getBaseState();
        }
        return this.base;
    }

    @Override
    protected DocumentNodeBuilder createChildBuilder(String name) {
        return new DocumentNodeBuilder(this, name, this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveTo(@NotNull NodeBuilder newParent, @NotNull String newName) {
        Preconditions.checkNotNull((Object)newParent);
        AbstractNodeState.checkValidName((String)newName);
        if (this.isRoot() || !this.exists() || newParent.hasChildNode(newName)) {
            return false;
        }
        if (newParent instanceof DocumentNodeBuilder) {
            for (DocumentNodeBuilder parent = (DocumentNodeBuilder)newParent; parent != null; parent = (DocumentNodeBuilder)parent.getParent()) {
                if (parent == this) {
                    return false;
                }
                if (parent.getParent() == this.root) break;
            }
        }
        if (newParent.exists()) {
            NodeState rootState = this.root.getNodeState();
            boolean success = false;
            try {
                this.annotateSourcePath();
                NodeState nodeState = this.getNodeState();
                new ApplyDiff(newParent.child(newName)).apply(nodeState);
                DocumentNodeBuilder.removeRecursive(this);
                success = true;
                boolean bl = true;
                return bl;
            }
            finally {
                if (!success) {
                    this.root.reset(rootState);
                }
            }
        }
        return false;
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return this.root.createBlob(stream);
    }

    public boolean remove() {
        return DocumentNodeBuilder.removeRecursive(this);
    }

    private boolean removeInternal() {
        return super.remove();
    }

    private static boolean removeRecursive(DocumentNodeBuilder builder) {
        for (String name : builder.getChildNodeNames()) {
            DocumentNodeBuilder.removeRecursive(builder.getChildNode(name));
        }
        return builder.removeInternal();
    }
}

