/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;

public class RDBHelper {
    private static String[] databases = new String[]{"Apache Derby", "DB2", "H2", "Microsoft SQL Server", "MySQL", "Oracle", "PostgreSQL", "default"};

    public static void main(String[] args) {
        RDBOptions defaultOpts = new RDBOptions();
        int initial = defaultOpts.getInitialSchema();
        int upgradeTo = defaultOpts.getUpgradeToSchema();
        System.out.println("Table Creation Statements for RDBBlobStore and RDBDocumentStore");
        System.out.println("RDBDocumentStore initial version: " + initial + ", with modifications up to version: " + upgradeTo);
        for (String database : databases) {
            System.out.println(database);
            System.out.println();
            RDBDocumentStoreDB ddb = RDBDocumentStoreDB.getValue(database);
            RDBBlobStoreDB bdb = RDBBlobStoreDB.getValue(database);
            for (String table : RDBDocumentStore.getTableNames()) {
                System.out.println("  " + ddb.getTableCreationStatement(table, defaultOpts.getInitialSchema()));
                for (String s : ddb.getIndexCreationStatements(table, defaultOpts.getInitialSchema())) {
                    System.out.println("    " + s);
                }
                for (int level = initial + 1; level <= upgradeTo; ++level) {
                    for (String statement : ddb.getTableUpgradeStatements(table, level)) {
                        System.out.println("  " + statement);
                    }
                }
            }
            System.out.println();
            System.out.println("  " + bdb.getMetaTableCreationStatement("DATASTORE_META"));
            System.out.println("  " + bdb.getDataTableCreationStatement("DATASTORE_DATA"));
            System.out.println();
            System.out.println();
        }
    }
}

