/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBConnectionHandler
implements Closeable {
    private DataSource ds;
    private long closedTime = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(RDBConnectionHandler.class);
    private static final boolean CHECKCONNECTIONONCLOSE = Boolean.getBoolean("org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler.CHECKCONNECTIONONCLOSE");
    private Boolean setReadOnlyThrows = null;
    private Boolean setReadWriteThrows = null;

    public RDBConnectionHandler(@Nonnull DataSource ds) {
        this.ds = ds;
    }

    @Nonnull
    public Connection getROConnection() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        this.setReadOnly(c, true);
        return c;
    }

    @Nonnull
    public Connection getRWConnection() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        this.setReadOnly(c, false);
        return c;
    }

    public void rollbackConnection(@Nullable Connection c) {
        if (c != null) {
            try {
                c.rollback();
            }
            catch (SQLException ex) {
                LOG.error("error on rollback (ignored)", (Throwable)ex);
            }
        }
    }

    public void closeConnection(Connection c) {
        if (c != null) {
            try {
                if (CHECKCONNECTIONONCLOSE) {
                    try {
                        this.setReadOnly(c, !c.isReadOnly());
                        this.setReadOnly(c, !c.isReadOnly());
                    }
                    catch (SQLException ex2) {
                        LOG.error("got dirty connection", (Throwable)ex2);
                        throw new DocumentStoreException("dirty connection on close", ex2);
                    }
                }
                c.close();
            }
            catch (SQLException ex) {
                LOG.error("exception on connection close (ignored)", (Throwable)ex);
            }
        }
    }

    @CheckForNull
    public String getSchema(Connection c) {
        try {
            return (String)c.getClass().getMethod("getSchema", new Class[0]).invoke((Object)c, new Object[0]);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public boolean isClosed() {
        return this.ds == null;
    }

    @Override
    public void close() throws IOException {
        this.ds = null;
        this.closedTime = System.currentTimeMillis();
    }

    @Nonnull
    private DataSource getDataSource() throws IllegalStateException {
        DataSource result = this.ds;
        if (result == null) {
            throw new IllegalStateException("Connection handler is already closed (" + (System.currentTimeMillis() - this.closedTime) + "ms ago)");
        }
        return result;
    }

    @Nonnull
    private Connection getConnection() throws IllegalStateException, SQLException {
        long elapsed;
        long ts = System.currentTimeMillis();
        Connection c = this.getDataSource().getConnection();
        if (LOG.isDebugEnabled() && (elapsed = System.currentTimeMillis() - ts) >= 100L) {
            LOG.debug("Obtaining a new connection from " + this.ds + " took " + elapsed + "ms");
        }
        return c;
    }

    private void setReadOnly(Connection c, boolean ro) throws SQLException {
        if (ro) {
            if (this.setReadOnlyThrows == null) {
                try {
                    c.setReadOnly(true);
                    this.setReadOnlyThrows = Boolean.FALSE;
                }
                catch (SQLException ex) {
                    LOG.error("Connection class " + c.getClass() + " erroneously throws SQLException on setReadOnly(true); not trying again");
                    this.setReadOnlyThrows = Boolean.TRUE;
                }
            } else if (!this.setReadOnlyThrows.booleanValue()) {
                c.setReadOnly(true);
            }
        } else if (this.setReadWriteThrows == null) {
            try {
                c.setReadOnly(false);
                this.setReadWriteThrows = Boolean.FALSE;
            }
            catch (SQLException ex) {
                LOG.error("Connection class " + c.getClass() + " erroneously throws SQLException on setReadOnly(false); not trying again");
                this.setReadWriteThrows = Boolean.TRUE;
            }
        } else if (!this.setReadWriteThrows.booleanValue()) {
            c.setReadOnly(false);
        }
    }
}

