/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.replica;

import com.google.common.base.Function;

public class Timestamped<T> {
    private final T value;
    private final long operationTimestamp;

    public Timestamped(T value, long operationTimestamp) {
        this.value = value;
        this.operationTimestamp = operationTimestamp;
    }

    public T getValue() {
        return this.value;
    }

    public long getOperationTimestamp() {
        return this.operationTimestamp;
    }

    public static <T> Function<Timestamped<T>, T> getExtractFunction() {
        return new Function<Timestamped<T>, T>(){

            public T apply(Timestamped<T> input) {
                if (input == null) {
                    return null;
                }
                return input.value;
            }
        };
    }

    public String toString() {
        return "Timestamped[" + this.value + '(' + this.operationTimestamp + ")]";
    }
}

