/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.replica;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.ReplicaSetInfoListener;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalChanges
implements ReplicaSetInfoListener {
    private static final Logger LOG = LoggerFactory.getLogger(LocalChanges.class);
    private static final int SIZE_LIMIT = 100;
    final Map<String, Long> localChanges = new HashMap<String, Long>();
    private volatile long latestChange;
    private volatile boolean replicaActive;
    private volatile long rootTS;
    private final int clusterId;

    public LocalChanges(int clusterId) {
        this.clusterId = clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String id, long timestamp) {
        long localRootTS = this.rootTS;
        if (localRootTS != 0L && localRootTS > timestamp) {
            return;
        }
        LocalChanges localChanges = this;
        synchronized (localChanges) {
            if (this.latestChange != 0L && this.latestChange > timestamp) {
                return;
            }
            if (this.replicaActive) {
                this.localChanges.put(id, timestamp);
                if (this.localChanges.size() >= 100) {
                    this.localChanges.clear();
                    this.latestChange = timestamp;
                    LOG.debug("The local changes count == {}. Clearing the list and switching to the 'latest change' mode: {}", (Object)100, (Object)this.latestChange);
                }
            } else {
                this.latestChange = timestamp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mayContain(String documentId) {
        if (!this.replicaActive || this.latestChange != 0L) {
            return true;
        }
        LocalChanges localChanges = this;
        synchronized (localChanges) {
            return this.localChanges.containsKey(documentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mayContainChildrenOf(String parentId) {
        if (!this.replicaActive || this.latestChange != 0L) {
            return true;
        }
        LocalChanges localChanges = this;
        synchronized (localChanges) {
            for (String key : this.localChanges.keySet()) {
                if (!parentId.equals(Utils.getParentId(key))) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotRootRevisions(RevisionVector rootRevision) {
        if (rootRevision == null) {
            return;
        }
        Revision rootRevForLocalInstance = rootRevision.getRevision(this.clusterId);
        if (rootRevForLocalInstance == null) {
            return;
        }
        this.rootTS = rootRevForLocalInstance.getTimestamp();
        if (!this.replicaActive) {
            this.replicaActive = true;
            LOG.info("Replica set became active");
        }
        LocalChanges localChanges = this;
        synchronized (localChanges) {
            if (this.latestChange != 0L && this.latestChange <= this.rootTS) {
                this.latestChange = 0L;
            }
            Iterator<Long> it = this.localChanges.values().iterator();
            while (it.hasNext()) {
                if (it.next() > this.rootTS) continue;
                it.remove();
            }
        }
    }
}

