/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.ClusterStateChangeListener;
import org.apache.jackrabbit.oak.plugins.document.ClusterView;
import org.apache.jackrabbit.oak.plugins.document.ClusterViewDocument;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.spi.cluster.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.jackrabbit.oak.plugins.document.DocumentDiscoveryLiteService", immediate=true, service={DocumentDiscoveryLiteService.class, Observer.class})
public class DocumentDiscoveryLiteService
implements ClusterStateChangeListener,
Observer {
    static final String COMPONENT_NAME = "org.apache.jackrabbit.oak.plugins.document.DocumentDiscoveryLiteService";
    public static final String OAK_DISCOVERYLITE_CLUSTERVIEW = "oak.discoverylite.clusterview";
    private static final Logger logger = LoggerFactory.getLogger(DocumentDiscoveryLiteService.class);
    private int clusterNodeId = -1;
    private DocumentNodeStore documentNodeStore;
    private BackgroundWorker backgroundWorker;
    private ClusterViewDocument previousClusterViewDocument;
    private ClusterView previousClusterView;
    private volatile boolean hasInstancesWithBacklog;
    @Reference
    private DocumentNodeStore nodeStore;
    private Set<Integer> longTimeInactives = new HashSet<Integer>();

    private String getClusterViewAsDescriptorValue() {
        if (this.previousClusterView == null) {
            return null;
        }
        return this.previousClusterView.asDescriptorValue();
    }

    @Activate
    public void activate(ComponentContext context) {
        logger.trace("activate: start");
        this.documentNodeStore = this.nodeStore;
        this.documentNodeStore.setClusterStateChangeListener(this);
        this.clusterNodeId = this.documentNodeStore.getClusterId();
        this.backgroundWorker = new BackgroundWorker();
        Thread th = new Thread((Runnable)this.backgroundWorker, "DocumentDiscoveryLiteService-BackgroundWorker-[" + this.clusterNodeId + "]");
        th.setDaemon(true);
        th.start();
        if (context != null) {
            OsgiWhiteboard whiteboard = new OsgiWhiteboard(context.getBundleContext());
            whiteboard.register(Descriptors.class, (Object)new DiscoveryLiteDescriptor(), Collections.emptyMap());
        }
        logger.trace("activate: end");
    }

    @Deactivate
    protected void deactivate() {
        logger.trace("deactivate: deactivated");
        if (this.backgroundWorker != null) {
            this.backgroundWorker.stop();
            this.backgroundWorker = null;
        }
        logger.trace("deactivate: end");
    }

    private boolean checkView() {
        logger.trace("checkView: start");
        List<ClusterNodeInfoDocument> allClusterNodes = ClusterNodeInfoDocument.all(this.documentNodeStore.getDocumentStore());
        HashMap<Integer, ClusterNodeInfoDocument> allNodeIds = new HashMap<Integer, ClusterNodeInfoDocument>();
        HashMap<Integer, ClusterNodeInfoDocument> activeNotTimedOutNodes = new HashMap<Integer, ClusterNodeInfoDocument>();
        HashMap<Integer, ClusterNodeInfoDocument> activeButTimedOutNodes = new HashMap<Integer, ClusterNodeInfoDocument>();
        HashMap<Integer, ClusterNodeInfoDocument> recoveringNodes = new HashMap<Integer, ClusterNodeInfoDocument>();
        HashMap<Integer, ClusterNodeInfoDocument> backlogNodes = new HashMap<Integer, ClusterNodeInfoDocument>();
        HashMap<Integer, ClusterNodeInfoDocument> inactiveNoBacklogNodes = new HashMap<Integer, ClusterNodeInfoDocument>();
        for (ClusterNodeInfoDocument clusterNode : allClusterNodes) {
            allNodeIds.put(clusterNode.getClusterId(), clusterNode);
            if (clusterNode.isBeingRecovered()) {
                recoveringNodes.put(clusterNode.getClusterId(), clusterNode);
                continue;
            }
            if (!clusterNode.isActive()) {
                if (this.hasBacklog(clusterNode)) {
                    backlogNodes.put(clusterNode.getClusterId(), clusterNode);
                    continue;
                }
                inactiveNoBacklogNodes.put(clusterNode.getClusterId(), clusterNode);
                continue;
            }
            if (clusterNode.getLeaseEndTime() < System.currentTimeMillis()) {
                activeButTimedOutNodes.put(clusterNode.getClusterId(), clusterNode);
                continue;
            }
            activeNotTimedOutNodes.put(clusterNode.getClusterId(), clusterNode);
        }
        HashMap<Integer, ClusterNodeInfoDocument> allActives = new HashMap<Integer, ClusterNodeInfoDocument>(activeNotTimedOutNodes);
        allActives.putAll(activeButTimedOutNodes);
        logger.debug("checkView: active nodes: {}, timed out nodes: {}, recovering nodes: {}, backlog nodes: {}, inactive nodes: {}, total: {}, hence view nodes: {}", new Object[]{activeNotTimedOutNodes.size(), activeButTimedOutNodes.size(), recoveringNodes.size(), backlogNodes.size(), inactiveNoBacklogNodes.size(), allNodeIds.size(), allActives.size()});
        ClusterViewDocument originalView = this.previousClusterViewDocument;
        ClusterViewDocument newView = this.doCheckView(allActives.keySet(), recoveringNodes.keySet(), backlogNodes.keySet(), inactiveNoBacklogNodes.keySet());
        if (newView == null) {
            logger.trace("checkView: end. newView: null");
            return true;
        }
        boolean newHasInstancesWithBacklog = recoveringNodes.size() > 0 || backlogNodes.size() > 0;
        boolean changed = originalView == null || newView.getViewSeqNum() != originalView.getViewSeqNum() || newHasInstancesWithBacklog != this.hasInstancesWithBacklog;
        logger.debug("checkView: viewFine: {}, changed: {}, originalView: {}, newView: {}", new Object[]{newView != null, changed, originalView, newView});
        if (this.longTimeInactives.addAll(inactiveNoBacklogNodes.keySet())) {
            logger.debug("checkView: updated longTimeInactives to {} (inactiveNoBacklogNodes: {})", this.longTimeInactives, inactiveNoBacklogNodes);
        }
        if (changed) {
            String clusterId = ClusterRepositoryInfo.getOrCreateId((NodeStore)this.documentNodeStore);
            ClusterView v = ClusterView.fromDocument(this.clusterNodeId, clusterId, newView, backlogNodes.keySet());
            ClusterView previousView = this.previousClusterView;
            this.previousClusterView = v;
            this.hasInstancesWithBacklog = newHasInstancesWithBacklog;
            logger.info("checkView: view changed from: " + previousView + ", to: " + v + ", hasInstancesWithBacklog: " + this.hasInstancesWithBacklog);
            return true;
        }
        logger.debug("checkView: no changes whatsoever, still at view: " + this.previousClusterView);
        return this.hasInstancesWithBacklog;
    }

    private Revision getLastKnownRevision(int clusterNodeId) {
        String[] lastKnownRevisions = this.documentNodeStore.getMBean().getLastKnownRevisions();
        for (int i = 0; i < lastKnownRevisions.length; ++i) {
            String aLastKnownRevisionStr = lastKnownRevisions[i];
            String[] split = aLastKnownRevisionStr.split("=");
            if (split.length == 2) {
                try {
                    Integer id = Integer.parseInt(split[0]);
                    if (id == clusterNodeId) {
                        Revision lastKnownRev = Revision.fromString(split[1]);
                        logger.trace("getLastKnownRevision: end. clusterNode: {}, lastKnownRevision: {}", (Object)clusterNodeId, (Object)lastKnownRev);
                        return lastKnownRev;
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.warn("getLastKnownRevision: could not parse integer '" + split[0] + "': " + nfe, (Throwable)nfe);
                }
                continue;
            }
            logger.warn("getLastKnownRevision: cannot parse lastKnownRevision: " + aLastKnownRevisionStr);
        }
        logger.warn("getLastKnownRevision: no lastKnownRevision found for " + clusterNodeId);
        return null;
    }

    private boolean hasBacklog(ClusterNodeInfoDocument clusterNode) {
        boolean hasBacklog;
        Revision lastKnownRevision;
        if (logger.isTraceEnabled()) {
            logger.trace("hasBacklog: start. clusterNodeId: {}", (Object)clusterNode.getClusterId());
        }
        if ((lastKnownRevision = this.getLastKnownRevision(clusterNode.getClusterId())) == null) {
            logger.warn("hasBacklog: no lastKnownRevision found, hence cannot determine backlog for node " + clusterNode.getClusterId());
            return false;
        }
        String lastWrittenRootRevStr = clusterNode.getLastWrittenRootRev();
        if (lastWrittenRootRevStr == null) {
            boolean warn = false;
            Object oakVersion = clusterNode.get("oakVersion");
            if (oakVersion != null && oakVersion instanceof String) {
                try {
                    Version actual = Version.parseVersion((String)((String)oakVersion));
                    Version introduced = Version.parseVersion((String)"1.3.5");
                    if (actual.compareTo((Object)introduced) >= 0) {
                        warn = true;
                    }
                }
                catch (Exception e) {
                    logger.debug("hasBacklog: couldn't parse version " + oakVersion + " : " + e);
                    warn = true;
                }
            }
            if (warn) {
                logger.warn("hasBacklog: node has lastWrittenRootRev=null");
            } else {
                logger.debug("hasBacklog: node has lastWrittenRootRev=null");
            }
            return false;
        }
        Revision lastWrittenRootRev = Revision.fromString(lastWrittenRootRevStr);
        if (lastWrittenRootRev == null) {
            logger.warn("hasBacklog: node has no lastWrittenRootRev: " + clusterNode.getClusterId());
            return false;
        }
        boolean bl = hasBacklog = Revision.getTimestampDifference(lastKnownRevision, lastWrittenRootRev) < 0L;
        if (logger.isDebugEnabled()) {
            logger.debug("hasBacklog: clusterNodeId: {}, lastKnownRevision: {}, lastWrittenRootRev: {}, hasBacklog: {}", new Object[]{clusterNode.getClusterId(), lastKnownRevision, lastWrittenRootRev, hasBacklog});
        }
        return hasBacklog;
    }

    private ClusterViewDocument doCheckView(Set<Integer> activeNodes, Set<Integer> recoveringNodes, Set<Integer> backlogNodes, Set<Integer> inactiveNodes) {
        ClusterViewDocument newViewOrNull;
        logger.trace("doCheckView: start: activeNodes: {}, recoveringNodes: {}, backlogNodes: {}, inactiveNodes: {}", new Object[]{activeNodes, recoveringNodes, backlogNodes, inactiveNodes});
        HashSet<Integer> allInactives = new HashSet<Integer>();
        allInactives.addAll(inactiveNodes);
        allInactives.addAll(backlogNodes);
        if (activeNodes.size() == 0) {
            logger.warn("doCheckView: empty active ids. activeNodes:{}, recoveringNodes:{}, inactiveNodes:{}", new Object[]{activeNodes, recoveringNodes, inactiveNodes});
            return null;
        }
        try {
            newViewOrNull = ClusterViewDocument.readOrUpdate(this.documentNodeStore, activeNodes, recoveringNodes, allInactives);
        }
        catch (RuntimeException re) {
            logger.error("doCheckView: RuntimeException: re: " + re, (Throwable)re);
            return null;
        }
        catch (Error er) {
            logger.error("doCheckView: Error: er: " + er, (Throwable)er);
            return null;
        }
        logger.trace("doChckView: readOrUpdate result: {}", (Object)newViewOrNull);
        if (newViewOrNull == null) {
            logger.debug("doCheckView: newViewOrNull is null: " + newViewOrNull);
            return null;
        }
        if (this.previousClusterViewDocument == null) {
            this.previousClusterViewDocument = newViewOrNull;
            logger.debug("doCheckView: end. first ever view: {}", (Object)newViewOrNull);
            return newViewOrNull;
        }
        if (this.previousClusterViewDocument.getViewSeqNum() == newViewOrNull.getViewSeqNum()) {
            logger.debug("doCheckView: end. seqNum did not change. view: {}", (Object)newViewOrNull);
            return newViewOrNull;
        }
        logger.info("doCheckView: view has changed from: {} to: {} - sending event...", (Object)this.previousClusterViewDocument, (Object)newViewOrNull);
        this.previousClusterViewDocument = newViewOrNull;
        logger.debug("doCheckView: end. changed view: {}", (Object)newViewOrNull);
        return newViewOrNull;
    }

    @Override
    public void handleClusterStateChange() {
        this.wakeupBackgroundWorker(WakeupReason.CLUSTER_STATE_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupBackgroundWorker(WakeupReason wakeupReason) {
        BackgroundWorker bw = this.backgroundWorker;
        if (bw != null) {
            boolean hasInstancesWithBacklog = this.hasInstancesWithBacklog;
            if (wakeupReason == WakeupReason.BACKGROUND_READ_FINISHED && !hasInstancesWithBacklog) {
                logger.trace("wakeupBackgroundWorker: not waking up backgroundWorker, as we do not have any instances with backlog");
                return;
            }
            logger.trace("wakeupBackgroundWorker: waking up backgroundWorker, reason: {} (hasInstancesWithBacklog: {})", (Object)wakeupReason, (Object)hasInstancesWithBacklog);
            BackgroundWorker backgroundWorker = bw;
            synchronized (backgroundWorker) {
                bw.notifyAll();
            }
        }
    }

    public void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        if (info.isExternal()) {
            logger.trace("contentChanged: ignoring content change due to commit info belonging to external change");
            return;
        }
        logger.trace("contentChanged: handling content changed by waking up worker if necessary");
        this.wakeupBackgroundWorker(WakeupReason.BACKGROUND_READ_FINISHED);
    }

    private class DiscoveryLiteDescriptor
    implements Descriptors {
        final SimpleValueFactory factory = new SimpleValueFactory();

        private DiscoveryLiteDescriptor() {
        }

        public String[] getKeys() {
            return new String[]{DocumentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW};
        }

        public boolean isStandardDescriptor(String key) {
            return DocumentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
        }

        public boolean isSingleValueDescriptor(String key) {
            return DocumentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
        }

        public Value getValue(String key) {
            if (!DocumentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
                return null;
            }
            return this.factory.createValue(DocumentDiscoveryLiteService.this.getClusterViewAsDescriptorValue());
        }

        public Value[] getValues(String key) {
            if (!DocumentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
                return null;
            }
            return new Value[]{this.getValue(key)};
        }
    }

    private class BackgroundWorker
    implements Runnable {
        final Random random = new Random();
        boolean stopped = false;

        private BackgroundWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            logger.trace("stop: start");
            BackgroundWorker backgroundWorker = this;
            synchronized (backgroundWorker) {
                this.stopped = true;
            }
            logger.trace("stop: end");
        }

        @Override
        public void run() {
            logger.info("BackgroundWorker.run: start");
            try {
                this.doRun();
            }
            finally {
                logger.info("BackgroundWorker.run: end {finally}");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            while (!this.stopped) {
                try {
                    logger.trace("BackgroundWorker.doRun: going to call checkView");
                    boolean shortSleep = DocumentDiscoveryLiteService.this.checkView();
                    logger.trace("BackgroundWorker.doRun: checkView terminated with {} (=shortSleep)", (Object)shortSleep);
                    long sleepMillis = shortSleep ? (long)(50 + this.random.nextInt(450)) : 5000L;
                    logger.trace("BackgroundWorker.doRun: sleeping {}ms", (Object)sleepMillis);
                    BackgroundWorker backgroundWorker = this;
                    synchronized (backgroundWorker) {
                        if (this.stopped) {
                            return;
                        }
                        this.wait(sleepMillis);
                        if (this.stopped) {
                            return;
                        }
                    }
                    logger.trace("BackgorundWorker.doRun: done sleeping, looping");
                }
                catch (Exception e) {
                    logger.error("doRun: got an exception: " + e, (Throwable)e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e2) {
                        logger.error("doRun: got an exception while sleeping due to another exception: " + e2, (Throwable)e2);
                    }
                }
            }
        }
    }

    private static enum WakeupReason {
        CLUSTER_STATE_CHANGED,
        BACKGROUND_READ_FINISHED;

    }
}

