/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

final class CommitValueResolver {
    private static final List<String> COMMIT_ROOT_OR_REVISIONS = ImmutableList.of((Object)"_commitRoot", (Object)"_revisions");
    private final Cache<Revision, String> commitValueCache;
    private final Supplier<RevisionVector> sweepRevisions;

    CommitValueResolver(int cacheSize, Supplier<RevisionVector> sweepRevisions) {
        this.commitValueCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
        this.sweepRevisions = sweepRevisions;
    }

    String resolve(@Nonnull Revision changeRevision, @Nonnull NodeDocument doc) {
        String value = (String)this.commitValueCache.getIfPresent((Object)changeRevision);
        if (value != null) {
            return value;
        }
        if ((doc = this.resolveDocument(doc, changeRevision)) == null) {
            return null;
        }
        if (((RevisionVector)this.sweepRevisions.get()).isRevisionNewer(changeRevision)) {
            value = doc.resolveCommitValue(changeRevision);
        } else {
            NodeDocument.SplitDocType sdt = doc.getSplitDocType();
            if (sdt == NodeDocument.SplitDocType.NONE) {
                value = doc.getLocalBranchCommits().contains(changeRevision) ? doc.resolveCommitValue(changeRevision) : "c";
            } else if (sdt == NodeDocument.SplitDocType.DEFAULT_NO_BRANCH) {
                value = "c";
            } else {
                value = doc.resolveCommitValue(changeRevision);
                if (value == null) {
                    value = "c";
                }
            }
        }
        if (Utils.isCommitted(value)) {
            this.commitValueCache.put((Object)changeRevision, (Object)value);
        }
        return value;
    }

    @CheckForNull
    private NodeDocument resolveDocument(@Nonnull NodeDocument doc, @Nonnull Revision changeRevision) {
        if (doc.getLocalCommitRoot().containsKey(changeRevision) || doc.getLocalRevisions().containsKey(changeRevision)) {
            return doc;
        }
        NodeDocument d = null;
        for (String p : COMMIT_ROOT_OR_REVISIONS) {
            Iterator<NodeDocument> iterator = doc.getPreviousDocs(p, changeRevision).iterator();
            if (iterator.hasNext()) {
                NodeDocument prev;
                d = prev = iterator.next();
            }
            if (d == null) continue;
            break;
        }
        return d;
    }
}

