/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.guava.common.util.concurrent.UncheckedExecutionException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.BackgroundReadStats;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.BatchCommitQueue;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.CachingCommitValueResolver;
import org.apache.jackrabbit.oak.plugins.document.Changes;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.ClusterStateChangeListener;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitBuilder;
import org.apache.jackrabbit.oak.plugins.document.CommitQueue;
import org.apache.jackrabbit.oak.plugins.document.CommitValueResolver;
import org.apache.jackrabbit.oak.plugins.document.ConflictException;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.document.DocumentBroadcastConfig;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStateCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBeanImpl;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.ExternalChange;
import org.apache.jackrabbit.oak.plugins.document.FormatVersion;
import org.apache.jackrabbit.oak.plugins.document.JournalDiffLoader;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.JournalGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandler;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandlerFactory;
import org.apache.jackrabbit.oak.plugins.document.JsopNodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.LastRevRecoveryAgent;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.LeaseCheckMode;
import org.apache.jackrabbit.oak.plugins.document.MergeCommit;
import org.apache.jackrabbit.oak.plugins.document.MissingBcSweeper2;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NamePathRev;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentSweepListener;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentSweeper;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.PrefetchDispatcher;
import org.apache.jackrabbit.oak.plugins.document.RecoveryHandlerImpl;
import org.apache.jackrabbit.oak.plugins.document.ResetDiff;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.Sweep2Helper;
import org.apache.jackrabbit.oak.plugins.document.Sweep2StatusDocument;
import org.apache.jackrabbit.oak.plugins.document.UnmergedBranches;
import org.apache.jackrabbit.oak.plugins.document.UnsavedModifications;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundledDocumentDiffer;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundlingConfigHandler;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.prefetch.CacheWarming;
import org.apache.jackrabbit.oak.plugins.document.util.LeaseCheckDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.LoggingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.ReadOnlyDocumentStoreWrapperFactory;
import org.apache.jackrabbit.oak.plugins.document.util.ThrottlingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.TimingDocumentStoreWrapper;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.observation.ChangeSet;
import org.apache.jackrabbit.oak.spi.observation.ChangeSetBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.PrefetchNodeStore;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentNodeStore
implements NodeStore,
RevisionContext,
Observable,
Clusterable,
PrefetchNodeStore,
NodeStateDiffer {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStore.class);
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(DocumentNodeStore.class.getName() + ".perf")));
    private static final long ONE_MINUTE_MS = TimeUnit.MINUTES.toMillis(1L);
    public static final FormatVersion VERSION = FormatVersion.V1_8;
    public static final List<String> META_PROP_NAMES = ImmutableList.of((Object)":doc-pattern", (Object)":doc-self-path", (Object)":doc-has-child-non-bundled", (Object)":doc-has-child-bundled");
    private static final boolean FAST_DIFF = (Boolean)SystemPropertySupplier.create((String)"oak.documentMK.fastDiff", (Object)Boolean.TRUE).loggingTo(LOG).get();
    private boolean enableConcurrentAddRemove = (Boolean)SystemPropertySupplier.create((String)"oak.enableConcurrentAddRemove", (Object)Boolean.FALSE).loggingTo(LOG).get();
    private boolean fairBackgroundOperationLock = (Boolean)SystemPropertySupplier.create((String)"oak.fairBackgroundOperationLock", (Object)Boolean.TRUE).loggingTo(LOG).get();
    public static final String SYS_PROP_DISABLE_JOURNAL = "oak.disableJournalDiff";
    private boolean disableJournalDiff = (Boolean)SystemPropertySupplier.create((String)"oak.disableJournalDiff", (Object)Boolean.FALSE).loggingTo(LOG).get();
    private int journalPushThreshold = (Integer)SystemPropertySupplier.create((String)"oak.journalPushThreshold", (Object)100000).loggingTo(LOG).get();
    private int collisionGarbageBatchSize = (Integer)SystemPropertySupplier.create((String)"oak.documentMK.collisionGarbageBatchSize", (Object)1000).loggingTo(LOG).get();
    private final int createOrUpdateBatchSize = (Integer)SystemPropertySupplier.create((String)"oak.documentMK.createOrUpdateBatchSize", (Object)1000).loggingTo(LOG).get();
    public static final String SYS_PROP_DISABLE_SWEEP2 = "oak.documentMK.disableSweep2";
    private boolean disableSweep2 = (Boolean)SystemPropertySupplier.create((String)"oak.documentMK.disableSweep2", (Object)Boolean.FALSE).loggingTo(LOG).get();
    static final long DEFAULT_MAX_SERVER_TIME_DIFFERENCE = 2000L;
    private final long maxTimeDiffMillis = (Long)SystemPropertySupplier.create((String)"oak.documentMK.maxServerTimeDiffMillis", (Object)2000L).loggingTo(LOG).get();
    public static final String SYS_PROP_PREFETCH = "oak.documentstore.prefetch";
    private final boolean prefetchEnabled = (Boolean)SystemPropertySupplier.create((String)"oak.documentstore.prefetch", (Object)false).loggingTo(LOG).get();
    private final DocumentStore nonLeaseCheckingStore;
    private final DocumentStore store;
    private final DocumentNodeState missing;
    protected final CommitQueue commitQueue;
    private final BatchCommitQueue batchCommitQueue;
    private final ChangeDispatcher dispatcher;
    private int asyncDelay = 1000;
    private int maxBackOffMillis = (Integer)SystemPropertySupplier.create((String)"oak.maxBackOffMS", (Object)(this.asyncDelay * 2)).loggingTo(LOG).get();
    private int changeSetMaxItems = (Integer)SystemPropertySupplier.create((String)"oak.document.changeSet.maxItems", (Object)50).loggingTo(LOG).get();
    private int purgeUncommittedRevisions = (Integer)SystemPropertySupplier.create((String)"oak.document.purgeUncommittedRevisions.batchSize", (Object)50).loggingTo(LOG).get();
    private int changeSetMaxDepth = (Integer)SystemPropertySupplier.create((String)"oak.document.changeSet.maxDepth", (Object)9).loggingTo(LOG).get();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final AtomicBoolean stopLeaseUpdateThread = new AtomicBoolean();
    @NotNull
    private final ClusterNodeInfo clusterNodeInfo;
    private final int clusterId;
    private final ConcurrentMap<Integer, ClusterNodeInfoDocument> clusterNodes = Maps.newConcurrentMap();
    private final UnmergedBranches branches;
    private final UnsavedModifications unsavedLastRevisions = new UnsavedModifications();
    private final Map<String, String> splitCandidates = Maps.newConcurrentMap();
    private JournalEntry changes;
    private volatile DocumentNodeState root;
    private Thread backgroundReadThread;
    private final Object backgroundReadMonitor = new Object();
    private Thread backgroundUpdateThread;
    private Thread backgroundPurgeThread;
    private final Object backgroundWriteMonitor = new Object();
    @NotNull
    private Thread leaseUpdateThread;
    @NotNull
    private Thread clusterUpdateThread;
    private final Object backgroundSweepMonitor = new Object();
    private Thread backgroundSweepThread;
    private Thread backgroundSweep2Thread;
    private RevisionVector sweepRevisions = new RevisionVector(new Revision[0]);
    private final ReadWriteLock backgroundOperationLock = new ReentrantReadWriteLock(this.fairBackgroundOperationLock);
    private final ReadWriteLock mergeLock = new ReentrantReadWriteLock();
    private AtomicInteger simpleRevisionCounter;
    private final Cache<PathRev, DocumentNodeState> nodeCache;
    private final CacheStats nodeCacheStats;
    private final Cache<NamePathRev, DocumentNodeState.Children> nodeChildrenCache;
    private final CacheStats nodeChildrenCacheStats;
    private final DiffCache diffCache;
    private final CommitValueResolver commitValueResolver;
    private final BlobStore blobStore;
    private ClusterStateChangeListener clusterStateChangeListener;
    private final BlobSerializer blobSerializer = new BlobSerializer(){

        public String serialize(Blob blob) {
            String id;
            BlobStoreBlob bsb;
            BlobStore bsbBlobStore;
            if (blob instanceof BlobStoreBlob && (bsbBlobStore = (bsb = (BlobStoreBlob)blob).getBlobStore()) != null && bsbBlobStore.equals(DocumentNodeStore.this.blobStore)) {
                return bsb.getBlobId();
            }
            String reference = blob.getReference();
            if (reference != null && (id = DocumentNodeStore.this.blobStore.getBlobId(reference)) != null) {
                return id;
            }
            try {
                id = DocumentNodeStore.this.createBlob(blob.getNewStream()).getBlobId();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return id;
        }
    };
    private final Function<String, Long> binarySize = new Function<String, Long>(){

        public Long apply(@Nullable String input) {
            return DocumentNodeStore.this.getBinarySize(input);
        }
    };
    private final Clock clock;
    private final Checkpoints checkpoints;
    private final VersionGarbageCollector versionGarbageCollector;
    private final JournalGarbageCollector journalGarbageCollector;
    private final Iterable<ReferencedBlob> referencedBlobs;
    private final Executor executor;
    private final MissingLastRevSeeker lastRevSeeker;
    private final LastRevRecoveryAgent lastRevRecoveryAgent;
    private final boolean disableBranches;
    private PersistentCache persistentCache;
    private PersistentCache journalCache;
    private final DocumentNodeStoreMBean mbean;
    private final boolean readOnlyMode;
    private DocumentNodeStateCache nodeStateCache = DocumentNodeStateCache.NOOP;
    private final DocumentNodeStoreStatsCollector nodeStoreStatsCollector;
    private final BundlingConfigHandler bundlingConfigHandler = new BundlingConfigHandler();
    private final BundledDocumentDiffer bundledDocDiffer = new BundledDocumentDiffer(this);
    private final JournalPropertyHandlerFactory journalPropertyHandlerFactory;
    private final int updateLimit;
    private final Set<Revision> inDoubtTrunkCommits = Sets.newConcurrentHashSet();
    private final Predicate<Path> nodeCachePredicate;
    private final Feature prefetchFeature;
    private CacheWarming cacheWarming;

    public DocumentNodeStore(DocumentNodeStoreBuilder<?> builder) {
        this.nodeCachePredicate = builder.getNodeCachePathPredicate();
        this.updateLimit = builder.getUpdateLimit();
        this.commitValueResolver = new CachingCommitValueResolver(builder.getCommitValueCacheSize(), (Supplier<RevisionVector>)((Supplier)this::getSweepRevisions)).withEmptyCommitValueCache(builder.getCacheEmptyCommitValue() && builder.getReadOnlyMode(), builder.getClock(), builder.getJournalGCMaxAge());
        this.blobStore = builder.getBlobStore();
        this.nodeStoreStatsCollector = builder.getNodeStoreStatsCollector();
        if (builder.isUseSimpleRevision()) {
            this.simpleRevisionCounter = new AtomicInteger(0);
        }
        DocumentStore s = builder.getDocumentStore();
        this.checkServerTimeDifference(s);
        if (builder.getTiming()) {
            s = new TimingDocumentStoreWrapper(s);
        }
        if (builder.getLogging()) {
            s = builder.getLoggingPrefix() != null ? new LoggingDocumentStoreWrapper(s, builder.getLoggingPrefix()) : new LoggingDocumentStoreWrapper(s);
        }
        if (builder.getReadOnlyMode()) {
            s = ReadOnlyDocumentStoreWrapperFactory.getInstance(s);
            this.readOnlyMode = true;
        } else {
            this.readOnlyMode = false;
        }
        DocumentNodeStore.checkVersion(s, this.readOnlyMode);
        this.nonLeaseCheckingStore = s;
        this.executor = builder.getExecutor();
        this.lastRevSeeker = builder.createMissingLastRevSeeker();
        this.clock = builder.getClock();
        int cid = builder.getClusterId();
        cid = (Integer)SystemPropertySupplier.create((String)"oak.documentMK.clusterId", (Object)cid).loggingTo(LOG).get();
        if (this.readOnlyMode) {
            this.clusterNodeInfo = ClusterNodeInfo.getReadOnlyInstance(this.nonLeaseCheckingStore);
        } else {
            this.clusterNodeInfo = ClusterNodeInfo.getInstance(this.nonLeaseCheckingStore, new RecoveryHandlerImpl(this.nonLeaseCheckingStore, this.clock, this.lastRevSeeker), null, null, cid, builder.isClusterInvisible());
            DocumentNodeStore.checkRevisionAge(this.nonLeaseCheckingStore, this.clusterNodeInfo, this.clock);
        }
        this.clusterId = this.clusterNodeInfo.getId();
        if (Utils.isThrottlingEnabled(builder)) {
            s = new ThrottlingDocumentStoreWrapper(s, builder.getThrottlingStatsCollector());
        }
        this.clusterNodeInfo.setLeaseCheckMode(builder.getLeaseCheckMode());
        if (builder.getLeaseCheckMode() != LeaseCheckMode.DISABLED) {
            s = new LeaseCheckDocumentStoreWrapper(s, this.clusterNodeInfo);
            this.clusterNodeInfo.setLeaseFailureHandler(builder.getLeaseFailureHandler());
        }
        String threadNamePostfix = "(" + this.clusterId + ")";
        this.leaseUpdateThread = new Thread((Runnable)new BackgroundLeaseUpdate(this, this.stopLeaseUpdateThread), "DocumentNodeStore lease update thread " + threadNamePostfix);
        this.leaseUpdateThread.setDaemon(true);
        if (!this.readOnlyMode) {
            this.leaseUpdateThread.setPriority(10);
            this.leaseUpdateThread.start();
        }
        this.prefetchFeature = builder.getPrefetchFeature();
        this.cacheWarming = new CacheWarming(s);
        this.journalPropertyHandlerFactory = builder.getJournalPropertyHandlerFactory();
        this.store = s;
        this.changes = this.newJournalEntry();
        this.branches = new UnmergedBranches();
        this.asyncDelay = builder.getAsyncDelay();
        this.versionGarbageCollector = new VersionGarbageCollector(this, builder.createVersionGCSupport());
        this.versionGarbageCollector.setStatisticsProvider(builder.getStatisticsProvider());
        this.versionGarbageCollector.setGCMonitor(builder.getGCMonitor());
        this.journalGarbageCollector = new JournalGarbageCollector(this, builder.getJournalGCMaxAge());
        this.referencedBlobs = builder.createReferencedBlobs(this);
        this.lastRevRecoveryAgent = new LastRevRecoveryAgent(this.store, this, this.lastRevSeeker, clusterId -> this.signalClusterStateChange());
        this.disableBranches = builder.isDisableBranches();
        this.missing = new DocumentNodeState(this, new Path("missing"), new RevisionVector(new Revision(0L, 0, 0))){

            @Override
            public int getMemory() {
                return 8;
            }
        };
        this.nodeCache = builder.buildNodeCache(this);
        this.nodeCacheStats = new CacheStats(this.nodeCache, "Document-NodeState", builder.getWeigher(), builder.getNodeCacheSize());
        this.nodeChildrenCache = builder.buildChildrenCache(this);
        this.nodeChildrenCacheStats = new CacheStats(this.nodeChildrenCache, "Document-NodeChildren", builder.getWeigher(), builder.getChildrenCacheSize());
        this.diffCache = builder.getDiffCache(this.clusterId);
        NodeDocument rootDoc = this.store.find(Collection.NODES, Utils.getIdFromPath(Path.ROOT));
        if (rootDoc == null) {
            if (this.readOnlyMode) {
                throw new DocumentStoreException("Unable to initialize a read-only DocumentNodeStore. The DocumentStore nodes collection does not have a root document.");
            }
            Revision commitRev = this.newRevision();
            RevisionVector head = new RevisionVector(commitRev);
            Commit commit = new CommitBuilder(this, commitRev, null).addNode(Path.ROOT).build();
            try {
                commit.applyToDocumentStore();
            }
            catch (ConflictException e) {
                commit.rollback();
                throw new IllegalStateException("Conflict while creating root document", e);
            }
            this.unsavedLastRevisions.put(Path.ROOT, commitRev);
            this.sweepRevisions = this.sweepRevisions.pmax(head);
            this.setRoot(head);
            this.backgroundWrite();
            rootDoc = this.store.find(Collection.NODES, Utils.getIdFromPath(Path.ROOT));
            if (rootDoc == null) {
                throw new IllegalStateException("Root document does not exist");
            }
        } else {
            this.sweepRevisions = this.sweepRevisions.pmax(rootDoc.getSweepRevisions());
            this.initializeRootState(rootDoc);
            if (!rootDoc.getLastRev().containsKey(this.clusterId)) {
                RevisionVector rootRev = this.getRoot().getRootRevision();
                Revision initialRev = rootRev.getRevision(this.clusterId);
                if (initialRev == null) {
                    throw new IllegalStateException("missing revision for clusterId " + this.clusterId + ": " + rootRev);
                }
                this.unsavedLastRevisions.put(Path.ROOT, initialRev);
                this.sweepRevisions = this.sweepRevisions.pmax(new RevisionVector(initialRev));
                if (!this.readOnlyMode) {
                    this.backgroundWrite();
                }
            }
        }
        this.checkpoints = new Checkpoints(this);
        this.branches.init(this.store, this, this.purgeUncommittedRevisions);
        this.dispatcher = builder.isPrefetchExternalChanges() ? new PrefetchDispatcher((NodeState)this.getRoot(), this.executor) : new ChangeDispatcher((NodeState)this.getRoot());
        this.commitQueue = new CommitQueue(this);
        this.commitQueue.setStatisticsCollector(this.nodeStoreStatsCollector);
        this.commitQueue.setSuspendTimeoutMillis(builder.getSuspendTimeoutMillis());
        this.batchCommitQueue = new BatchCommitQueue(this.store);
        this.backgroundReadThread = new Thread((Runnable)new BackgroundReadOperation(this, this.isDisposed), "DocumentNodeStore background read thread " + threadNamePostfix);
        this.backgroundReadThread.setDaemon(true);
        this.backgroundPurgeThread = new Thread((Runnable)new BackgroundPurgeOperation(this, this.isDisposed), "DocumentNodeStore background purge thread " + threadNamePostfix);
        this.backgroundPurgeThread.setDaemon(true);
        this.backgroundUpdateThread = new Thread((Runnable)new BackgroundUpdateOperation(this, this.isDisposed), "DocumentNodeStore background update thread " + threadNamePostfix);
        this.backgroundUpdateThread.setDaemon(true);
        this.backgroundSweepThread = new Thread((Runnable)new BackgroundSweepOperation(this, this.isDisposed), "DocumentNodeStore background sweep thread " + threadNamePostfix);
        this.backgroundSweepThread.setDaemon(true);
        this.clusterUpdateThread = new Thread((Runnable)new BackgroundClusterUpdate(this, this.isDisposed), "DocumentNodeStore cluster update thread " + threadNamePostfix);
        this.clusterUpdateThread.setDaemon(true);
        this.clusterUpdateThread.start();
        this.backgroundReadThread.start();
        if (!this.readOnlyMode) {
            long sweep2Lock;
            this.runBackgroundUpdateOperations();
            if (this.disableSweep2) {
                try {
                    Sweep2StatusDocument sweep2Status = Sweep2StatusDocument.readFrom(this.store);
                    if (sweep2Status == null || !sweep2Status.isSwept()) {
                        Sweep2StatusDocument.forceReleaseSweep2LockAndMarkSwept(this.store, this.clusterId);
                    }
                }
                catch (Exception e) {
                    LOG.warn("<init> sweep2 is diabled as instructed by system property (oak.documentMK.disableSweep2=true) - however, got an Exception while storing sweep2 status in the settings collection: " + e, (Throwable)e);
                }
                sweep2Lock = -1L;
            } else {
                sweep2Lock = Sweep2Helper.acquireSweep2LockIfNecessary(this.store, this.clusterId);
            }
            this.backgroundSweep();
            this.backgroundUpdateThread.start();
            this.backgroundSweepThread.start();
            this.backgroundPurgeThread.start();
            if (sweep2Lock >= 0L) {
                this.backgroundSweep2Thread = new Thread((Runnable)new BackgroundSweep2Operation(this, this.isDisposed, sweep2Lock), "DocumentNodeStore background sweep2 thread " + threadNamePostfix);
                this.backgroundSweep2Thread.setDaemon(true);
                this.backgroundSweep2Thread.start();
            }
        }
        this.persistentCache = builder.getPersistentCache();
        if (!this.readOnlyMode && this.persistentCache != null) {
            DocumentBroadcastConfig broadcastConfig = new DocumentBroadcastConfig(this);
            this.persistentCache.setBroadcastConfig(broadcastConfig);
        }
        this.journalCache = builder.getJournalCache();
        this.mbean = this.createMBean(builder);
        LOG.info("ChangeSetBuilder enabled and size set to maxItems: {}, maxDepth: {}", (Object)this.changeSetMaxItems, (Object)this.changeSetMaxDepth);
        LOG.info("Initialized DocumentNodeStore with clusterNodeId: {}, updateLimit: {} ({})", new Object[]{this.clusterId, this.updateLimit, this.getClusterNodeInfoDisplayString()});
        if (!builder.isBundlingDisabled()) {
            this.bundlingConfigHandler.initialize(this, this.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Serializable message;
        LOG.info("Starting disposal of DocumentNodeStore with clusterNodeId: {} ({})", (Object)this.clusterId, (Object)this.getClusterNodeInfoDisplayString());
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isDisposed;
        synchronized (atomicBoolean) {
            this.isDisposed.notifyAll();
        }
        Utils.joinQuietly(this.backgroundReadThread, this.backgroundUpdateThread, this.backgroundSweepThread, this.backgroundSweep2Thread, this.backgroundPurgeThread);
        DocumentStoreException ex = null;
        if (!this.readOnlyMode) {
            try {
                Revision tombstone = this.commitQueue.createRevision();
                this.commitQueue.done(tombstone, new CommitQueue.Callback(){

                    @Override
                    public void headOfQueue(@NotNull Revision revision) {
                        DocumentNodeStore.this.setRoot(DocumentNodeStore.this.getHeadRevision().update(revision));
                        DocumentNodeStore.this.unsavedLastRevisions.put(Path.ROOT, revision);
                    }
                });
            }
            catch (DocumentStoreException e) {
                LOG.error("dispose: a DocumentStoreException happened during dispose's attempt to commit a tombstone: " + e, (Throwable)e);
                ex = e;
            }
        }
        try {
            this.bundlingConfigHandler.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing bundlingConfigHandler", (Object)this.bundlingConfigHandler, (Object)e);
        }
        if (!this.readOnlyMode) {
            try {
                this.internalRunBackgroundSweepOperation();
                this.internalRunBackgroundUpdateOperations();
            }
            catch (DocumentStoreException e) {
                LOG.error("dispose: a DocumentStoreException happened during dispose's last background ops: " + e, (Throwable)e);
                ex = e;
            }
        }
        Utils.joinQuietly(this.clusterUpdateThread);
        boolean isLeaseExpired = this.clusterNodeInfo.isLeaseExpired(this.clock.getTime());
        Thread.State leaseUpdateState = this.leaseUpdateThread.getState();
        if (leaseUpdateState == Thread.State.TERMINATED) {
            LOG.error("leaseUpdateThread (" + this.leaseUpdateThread.getName() + ") is terminated");
        }
        if (isLeaseExpired || LOG.isDebugEnabled()) {
            message = new StringBuilder("Status of lease update thread (" + this.leaseUpdateThread.getName() + "): " + leaseUpdateState + "; Stack Trace:");
            for (StackTraceElement se : this.leaseUpdateThread.getStackTrace()) {
                ((StringBuilder)message).append("\n\tat ");
                ((StringBuilder)message).append(se.toString());
            }
            if (isLeaseExpired) {
                LOG.info(((StringBuilder)message).toString());
            } else {
                LOG.debug(((StringBuilder)message).toString());
            }
        }
        LOG.debug("Stopping LeaseUpdate thread...");
        this.stopLeaseUpdateThread.set(true);
        message = this.stopLeaseUpdateThread;
        synchronized (message) {
            this.stopLeaseUpdateThread.notifyAll();
        }
        Utils.joinQuietly(this.leaseUpdateThread);
        LOG.debug("Stopped LeaseUpdate thread");
        if (ex == null) {
            this.clusterNodeInfo.dispose();
        }
        this.store.dispose();
        try {
            this.blobStore.close();
        }
        catch (Exception e) {
            LOG.debug("Error closing blob store " + this.blobStore, (Throwable)e);
        }
        if (this.persistentCache != null) {
            this.persistentCache.close();
        }
        if (this.journalCache != null) {
            this.journalCache.close();
        }
        Object result = "(successful)";
        if (ex != null) {
            result = "(with exception: " + ex.toString() + ")";
        }
        LOG.info("Disposed DocumentNodeStore with clusterNodeId: {}, {}", (Object)this.clusterId, result);
        if (ex != null) {
            throw ex;
        }
    }

    private String getClusterNodeInfoDisplayString() {
        return (this.readOnlyMode ? "readOnly:true, " : "") + this.clusterNodeInfo.toString().replaceAll("[\r\n\t]", " ").trim();
    }

    void setRoot(@NotNull RevisionVector newHead) {
        Preconditions.checkArgument((!newHead.isBranch() ? 1 : 0) != 0);
        this.root = this.getRoot(newHead);
    }

    @NotNull
    public DocumentStore getDocumentStore() {
        return this.store;
    }

    @NotNull
    Commit newCommit(@NotNull Changes changes, @Nullable RevisionVector base, @Nullable DocumentNodeStoreBranch branch) {
        if (base == null) {
            base = this.getHeadRevision();
        }
        if (base.isBranch()) {
            return this.newBranchCommit(changes, base, branch);
        }
        return this.newTrunkCommit(changes, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private MergeCommit newMergeCommit(@NotNull RevisionVector base, int numBranchCommits) {
        MergeCommit c;
        Preconditions.checkNotNull((Object)base);
        this.backgroundOperationLock.readLock().lock();
        boolean success = false;
        try {
            this.checkOpen();
            c = new MergeCommit(this, base, this.commitQueue.createRevisions(numBranchCommits));
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RevisionVector done(final @NotNull Commit c, boolean isBranch, final @NotNull CommitInfo info) {
        if (this.commitQueue.contains(c.getRevision())) {
            try {
                this.inDoubtTrunkCommits.remove(c.getRevision());
                final RevisionVector[] newHead = new RevisionVector[1];
                this.commitQueue.done(c.getRevision(), new CommitQueue.Callback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void headOfQueue(@NotNull Revision revision) {
                        RevisionVector before = DocumentNodeStore.this.getHeadRevision();
                        Revision r = c.getRevision();
                        newHead[0] = before.update(r);
                        boolean success = false;
                        boolean cacheUpdated = false;
                        try {
                            c.applyLastRevUpdates(false);
                            DocumentNodeStore.this.changes.modified(c.getModifiedPaths());
                            DocumentNodeStore.this.changes.readFrom(info);
                            DocumentNodeStore.this.changes.addChangeSet(DocumentNodeStore.getChangeSet(info));
                            success = true;
                            c.applyToCache(before, false);
                            cacheUpdated = true;
                            if (DocumentNodeStore.this.changes.getNumChangedNodes() >= DocumentNodeStore.this.journalPushThreshold) {
                                LOG.info("Pushing journal entry at {} as number of changes ({}) have reached threshold of {}", new Object[]{r, DocumentNodeStore.this.changes.getNumChangedNodes(), DocumentNodeStore.this.journalPushThreshold});
                                DocumentNodeStore.this.pushJournalEntry(r);
                            }
                        }
                        catch (Throwable e) {
                            if (success) {
                                if (cacheUpdated) {
                                    LOG.warn("Pushing journal entry at {} failed", (Object)revision, (Object)e);
                                } else {
                                    LOG.warn("Updating caches at {} failed", (Object)revision, (Object)e);
                                }
                            } else {
                                LOG.error("Applying in-memory changes at {} failed", (Object)revision, (Object)e);
                            }
                        }
                        finally {
                            DocumentNodeStore.this.setRoot(newHead[0]);
                            DocumentNodeStore.this.commitQueue.headRevisionChanged();
                            DocumentNodeStore.this.dispatcher.contentChanged((NodeState)DocumentNodeStore.this.getRoot(), info);
                        }
                    }
                });
                RevisionVector revisionVector = newHead[0];
                return revisionVector;
            }
            finally {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        try {
            c.applyLastRevUpdates(isBranch);
            c.applyToCache(c.getBaseRevision(), isBranch);
            RevisionVector revisionVector = c.getBaseRevision().update(c.getRevision().asBranchRevision());
            return revisionVector;
        }
        finally {
            if (this.isDisableBranches()) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void canceled(Commit c) {
        if (this.commitQueue.contains(c.getRevision())) {
            try {
                this.commitQueue.canceled(c.getRevision());
                if (!c.rollback()) return;
                this.inDoubtTrunkCommits.remove(c.getRevision());
                return;
            }
            finally {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        try {
            c.rollback();
            Branch b = this.branches.getBranch(c.getBaseRevision());
            if (b == null) return;
            b.removeCommit(c.getRevision().asBranchRevision());
            return;
        }
        finally {
            if (this.isDisableBranches()) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
    }

    public void setAsyncDelay(int delay) {
        this.asyncDelay = delay;
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    public void setMaxBackOffMillis(int time) {
        this.maxBackOffMillis = time;
    }

    public int getMaxBackOffMillis() {
        return this.maxBackOffMillis;
    }

    public int getChangeSetMaxItems() {
        return this.changeSetMaxItems;
    }

    public void setChangeSetMaxItems(int changeSetMaxItems) {
        this.changeSetMaxItems = changeSetMaxItems;
    }

    public int getChangeSetMaxDepth() {
        return this.changeSetMaxDepth;
    }

    public void setChangeSetMaxDepth(int changeSetMaxDepth) {
        this.changeSetMaxDepth = changeSetMaxDepth;
    }

    void setEnableConcurrentAddRemove(boolean b) {
        this.enableConcurrentAddRemove = b;
    }

    boolean getEnableConcurrentAddRemove() {
        return this.enableConcurrentAddRemove;
    }

    int getJournalPushThreshold() {
        return this.journalPushThreshold;
    }

    void setJournalPushThreshold(int journalPushThreshold) {
        this.journalPushThreshold = journalPushThreshold;
    }

    @NotNull
    public ClusterNodeInfo getClusterInfo() {
        return this.clusterNodeInfo;
    }

    public CacheStats getNodeCacheStats() {
        return this.nodeCacheStats;
    }

    public CacheStats getNodeChildrenCacheStats() {
        return this.nodeChildrenCacheStats;
    }

    @NotNull
    public Iterable<CacheStats> getDiffCacheStats() {
        return this.diffCache.getStats();
    }

    public Cache<PathRev, DocumentNodeState> getNodeCache() {
        return this.nodeCache;
    }

    public Cache<NamePathRev, DocumentNodeState.Children> getNodeChildrenCache() {
        return this.nodeChildrenCache;
    }

    public Predicate<Path> getNodeCachePredicate() {
        return this.nodeCachePredicate;
    }

    JournalEntry getCurrentJournalEntry() {
        return this.changes;
    }

    void invalidateNodeChildrenCache() {
        this.nodeChildrenCache.invalidateAll();
    }

    void invalidateNodeCache(String path, RevisionVector revision) {
        this.nodeCache.invalidate((Object)new PathRev(Path.fromString(path), revision));
    }

    public int getPendingWriteCount() {
        return this.unsavedLastRevisions.getPaths().size();
    }

    public boolean isDisableBranches() {
        return this.disableBranches;
    }

    public long getMaxTimeDiffMillis() {
        return this.maxTimeDiffMillis;
    }

    void addSplitCandidate(String id) {
        this.splitCandidates.put(id, id);
    }

    @Nullable
    AbstractDocumentNodeState getSecondaryNodeState(@NotNull Path path, @NotNull RevisionVector rootRevision, @NotNull RevisionVector rev) {
        return this.nodeStateCache.getDocumentNodeState(path, rootRevision, rev);
    }

    @NotNull
    public PropertyState createPropertyState(String name, String value) {
        return new DocumentPropertyState(this, name, (String)Preconditions.checkNotNull((Object)value));
    }

    @Nullable
    public DocumentNodeState getNode(final @NotNull Path path, final @NotNull RevisionVector rev) {
        Preconditions.checkNotNull((Object)rev);
        Preconditions.checkNotNull((Object)path);
        long start = PERFLOG.start();
        try {
            PathRev key = new PathRev(path, rev);
            DocumentNodeState node = (DocumentNodeState)((Object)this.nodeCache.get((Object)key, (Callable)new Callable<DocumentNodeState>(){

                @Override
                public DocumentNodeState call() throws Exception {
                    boolean nodeDoesNotExist = DocumentNodeStore.this.checkNodeNotExistsFromChildrenCache(path, rev);
                    if (nodeDoesNotExist) {
                        return DocumentNodeStore.this.missing;
                    }
                    DocumentNodeState n = DocumentNodeStore.this.readNode(path, rev);
                    if (n == null) {
                        n = DocumentNodeStore.this.missing;
                    }
                    return n;
                }
            }));
            DocumentNodeState result = node == this.missing || node.equals((Object)this.missing) ? null : node;
            PERFLOG.end(start, 1L, "getNode: path={}, rev={}", (Object)path, (Object)rev);
            return result;
        }
        catch (UncheckedExecutionException e) {
            throw DocumentStoreException.convert(e.getCause());
        }
        catch (ExecutionException e) {
            throw DocumentStoreException.convert(e.getCause());
        }
    }

    @Nullable
    DocumentNodeState getNodeIfCached(@NotNull Path path, @NotNull RevisionVector rev) {
        PathRev key = new PathRev(path, rev);
        DocumentNodeState state = (DocumentNodeState)((Object)this.nodeCache.getIfPresent((Object)key));
        if (state == this.missing) {
            state = DocumentNodeState.newMissingNode(this, path, rev);
        }
        return state;
    }

    @NotNull
    DocumentNodeState.Children getChildren(final @NotNull AbstractDocumentNodeState parent, final @NotNull String name, final int limit) throws DocumentStoreException {
        if (((AbstractDocumentNodeState)((Object)Preconditions.checkNotNull((Object)((Object)parent)))).hasNoChildren()) {
            return DocumentNodeState.NO_CHILDREN;
        }
        Path path = ((AbstractDocumentNodeState)((Object)Preconditions.checkNotNull((Object)((Object)parent)))).getPath();
        RevisionVector readRevision = parent.getLastRevision();
        try {
            NamePathRev key = DocumentNodeStore.childNodeCacheKey(path, readRevision, name);
            DocumentNodeState.Children children = (DocumentNodeState.Children)this.nodeChildrenCache.get((Object)key, (Callable)new Callable<DocumentNodeState.Children>(){

                @Override
                public DocumentNodeState.Children call() throws Exception {
                    return DocumentNodeStore.this.readChildren(parent, name, limit);
                }
            });
            if (children.children.size() < limit && children.hasMore) {
                children = this.readChildren(parent, name, limit);
                this.nodeChildrenCache.put((Object)key, (Object)children);
            }
            return children;
        }
        catch (UncheckedExecutionException e) {
            throw DocumentStoreException.convert(e.getCause(), "Error occurred while fetching children for path " + path);
        }
        catch (ExecutionException e) {
            throw DocumentStoreException.convert(e.getCause(), "Error occurred while fetching children for path " + path);
        }
    }

    DocumentNodeState.Children readChildren(@NotNull AbstractDocumentNodeState parent, @NotNull String name, int limit) {
        int numReturned;
        String queriedName = name;
        Path path = parent.getPath();
        RevisionVector rev = parent.getLastRevision();
        LOG.trace("Reading children for [{}] at rev [{}]", (Object)path, (Object)rev);
        DocumentNodeState.Children c = new DocumentNodeState.Children();
        int rawLimit = (int)Math.min(Integer.MAX_VALUE, (long)limit + 1L);
        do {
            Iterable<NodeDocument> docs = this.readChildDocs(path, name, rawLimit);
            numReturned = 0;
            for (NodeDocument doc : docs) {
                ++numReturned;
                Path p = doc.getPath();
                name = p.getName();
                DocumentNodeState child = this.getNode(p, rev);
                if (child == null) continue;
                if (c.children.size() < limit) {
                    c.children.add(p.getName());
                    continue;
                }
                c.hasMore = true;
                return c;
            }
        } while (numReturned >= rawLimit);
        c.hasMore = false;
        if (queriedName.isEmpty()) {
            Collections.sort(c.children);
        }
        return c;
    }

    @NotNull
    private Iterable<NodeDocument> readChildDocs(@NotNull Path path, @NotNull String name, int limit) {
        String to = Utils.getKeyUpperLimit((Path)Preconditions.checkNotNull((Object)path));
        String from = name.isEmpty() ? Utils.getKeyLowerLimit(path) : Utils.getIdFromPath(new Path(path, name));
        return this.store.query(Collection.NODES, from, to, limit);
    }

    @NotNull
    Iterable<DocumentNodeState> getChildNodes(final @NotNull DocumentNodeState parent, final @NotNull String name, int limit) {
        if (((DocumentNodeState)((Object)Preconditions.checkNotNull((Object)((Object)parent)))).hasNoChildren()) {
            return Collections.emptyList();
        }
        final RevisionVector readRevision = parent.getLastRevision();
        return Iterables.transform(this.getChildren((AbstractDocumentNodeState)parent, (String)name, (int)limit).children, (Function)new Function<String, DocumentNodeState>(){

            public DocumentNodeState apply(String input) {
                Path p = new Path(parent.getPath(), input);
                DocumentNodeState result = DocumentNodeStore.this.getNode(p, readRevision);
                if (result == null) {
                    String id = Utils.getIdFromPath(p);
                    String cachedDocStr = this.docAsString(id, true);
                    String uncachedDocStr = this.docAsString(id, false);
                    DocumentNodeStore.this.nodeCache.invalidate((Object)new PathRev(p, readRevision));
                    DocumentNodeStore.this.nodeChildrenCache.invalidate((Object)DocumentNodeStore.childNodeCacheKey(parent.getPath(), readRevision, name));
                    String exceptionMsg = String.format("Aborting getChildNodes() - DocumentNodeState is null for %s at %s {\"cachedDoc\":{%s}, \"uncachedDoc\":{%s}}", readRevision, p, cachedDocStr, uncachedDocStr);
                    throw new DocumentStoreException(exceptionMsg);
                }
                return result.withRootRevision(parent.getRootRevision(), parent.isFromExternalChange());
            }

            private String docAsString(String id, boolean cached) {
                try {
                    NodeDocument doc = cached ? DocumentNodeStore.this.store.find(Collection.NODES, id) : DocumentNodeStore.this.store.find(Collection.NODES, id, 0);
                    if (doc == null) {
                        return "<null>";
                    }
                    return doc.asString();
                }
                catch (DocumentStoreException e) {
                    return e.toString();
                }
            }
        });
    }

    @Nullable
    private DocumentNodeState readNode(Path path, RevisionVector readRevision) {
        long start = PERFLOG.start();
        String id = Utils.getIdFromPath(path);
        Revision lastRevision = this.getPendingModifications().get(path);
        NodeDocument doc = this.store.find(Collection.NODES, id);
        if (doc == null) {
            PERFLOG.end(start, 1L, "readNode: (document not found) path={}, readRevision={}", (Object)path, (Object)readRevision);
            return null;
        }
        DocumentNodeState result = doc.getNodeAtRevision(this, readRevision, lastRevision);
        PERFLOG.end(start, 1L, "readNode: path={}, readRevision={}", (Object)path, (Object)readRevision);
        return result;
    }

    public BundlingConfigHandler getBundlingConfigHandler() {
        return this.bundlingConfigHandler;
    }

    void applyChanges(RevisionVector before, RevisionVector after, Revision rev, Path path, boolean isNew, List<Path> added, List<Path> removed, List<Path> changed) {
        if (isNew) {
            NodeDocument doc = this.store.getIfCached(Collection.NODES, Utils.getIdFromPath(path));
            RevisionVector afterLastRev = after;
            if (doc != null) {
                afterLastRev = new RevisionVector(doc.getLastRev().values());
                afterLastRev = afterLastRev.update(rev);
            }
            if (added.isEmpty()) {
                if (doc != null && doc.hasChildren()) {
                    NamePathRev key = DocumentNodeStore.childNodeCacheKey(path, afterLastRev, "");
                    LOG.debug("nodeChildrenCache.put({},{})", (Object)key, (Object)"NO_CHILDREN");
                    this.nodeChildrenCache.put((Object)key, (Object)DocumentNodeState.NO_CHILDREN);
                }
            } else {
                DocumentNodeState.Children c = new DocumentNodeState.Children();
                TreeSet set = Sets.newTreeSet();
                for (Path p : added) {
                    set.add(p.getName());
                }
                c.children.addAll(set);
                NamePathRev key = DocumentNodeStore.childNodeCacheKey(path, afterLastRev, "");
                LOG.debug("nodeChildrenCache.put({},{})", (Object)key, (Object)c);
                this.nodeChildrenCache.put((Object)key, (Object)c);
            }
        } else {
            DocumentNodeState beforeState = this.getRoot(before);
            int depth = path.getDepth();
            for (int i = 1; i <= depth && beforeState != null; ++i) {
                RevisionVector lastRev;
                Path p = path.getAncestor(depth - i);
                PathRev key = new PathRev(p, lastRev = beforeState.getLastRevision());
                beforeState = (DocumentNodeState)((Object)this.nodeCache.getIfPresent((Object)key));
                if (!this.missing.equals((Object)beforeState)) continue;
                LOG.warn("Before state is missing {}. Invalidating affected cache entries.", (Object)key);
                this.store.invalidateCache(Collection.NODES, Utils.getIdFromPath(p));
                this.nodeCache.invalidate(key);
                this.nodeChildrenCache.invalidate((Object)DocumentNodeStore.childNodeCacheKey(path, lastRev, ""));
                beforeState = null;
            }
            DocumentNodeState.Children children = null;
            if (beforeState != null) {
                if (beforeState.hasNoChildren()) {
                    children = DocumentNodeState.NO_CHILDREN;
                } else {
                    NamePathRev key = DocumentNodeStore.childNodeCacheKey(path, beforeState.getLastRevision(), "");
                    children = (DocumentNodeState.Children)this.nodeChildrenCache.getIfPresent((Object)key);
                }
            }
            if (children != null) {
                Object c;
                AbstractSet afterChildren;
                NamePathRev afterKey = DocumentNodeStore.childNodeCacheKey(path, beforeState.getLastRevision().update(rev), "");
                if (added.isEmpty() && removed.isEmpty()) {
                    LOG.debug("nodeChildrenCache.put({},{})", (Object)afterKey, (Object)children);
                    this.nodeChildrenCache.put((Object)afterKey, (Object)children);
                } else if (!children.hasMore) {
                    afterChildren = Sets.newTreeSet(children.children);
                    for (Path p : added) {
                        afterChildren.add(p.getName());
                    }
                    for (Path p : removed) {
                        afterChildren.remove(p.getName());
                    }
                    c = new DocumentNodeState.Children();
                    ((DocumentNodeState.Children)c).children.addAll(afterChildren);
                    if (((DocumentNodeState.Children)c).children.size() <= 1600) {
                        LOG.debug("nodeChildrenCache.put({},{})", (Object)afterKey, c);
                        this.nodeChildrenCache.put((Object)afterKey, c);
                    } else {
                        LOG.info("not caching more than {} child names for {}", (Object)1600, (Object)path);
                    }
                } else if (added.isEmpty()) {
                    afterChildren = Sets.newLinkedHashSet(children.children);
                    for (Path p : removed) {
                        afterChildren.remove(p.getName());
                    }
                    c = new DocumentNodeState.Children();
                    ((DocumentNodeState.Children)c).children.addAll(afterChildren);
                    ((DocumentNodeState.Children)c).hasMore = true;
                    LOG.debug("nodeChildrenCache.put({},{})", (Object)afterKey, c);
                    this.nodeChildrenCache.put((Object)afterKey, c);
                }
            }
        }
    }

    void revisionsMerged(@NotNull Iterable<Revision> revisions) {
        this.changes.branchCommit(revisions);
    }

    @Nullable
    NodeDocument updateCommitRoot(UpdateOp commit, Revision commitRev) throws DocumentStoreException {
        boolean batch = true;
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> op : commit.getChanges().entrySet()) {
            String name = op.getKey().getName();
            if (NodeDocument.isRevisionsEntry(name) || "_modified".equals(name)) continue;
            batch = false;
            break;
        }
        try {
            if (batch) {
                return this.batchUpdateCommitRoot(commit);
            }
            return this.store.findAndUpdate(Collection.NODES, commit);
        }
        catch (DocumentStoreException e) {
            return this.verifyCommitRootUpdateApplied(commit, commitRev, e);
        }
    }

    private NodeDocument verifyCommitRootUpdateApplied(UpdateOp commit, Revision commitRev, DocumentStoreException e) throws DocumentStoreException {
        LOG.info("Update of commit root failed with exception", (Throwable)e);
        int numRetries = 10;
        for (int i = 0; i < numRetries; ++i) {
            NodeDocument commitRootDoc;
            LOG.info("Checking if change made it to the DocumentStore anyway {}/{} ...", (Object)(i + 1), (Object)numRetries);
            try {
                commitRootDoc = this.store.find(Collection.NODES, commit.getId(), 0);
            }
            catch (Exception ex) {
                LOG.info("Failed to read commit root document", (Throwable)ex);
                continue;
            }
            if (commitRootDoc == null) {
                LOG.info("Commit root document missing for {}", (Object)commit.getId());
                break;
            }
            if (!commitRootDoc.getLocalRevisions().containsKey(commitRev)) break;
            LOG.info("Update made it to the store even though the call failed with an exception. Previous exception will be suppressed. {}", (Object)commit);
            NodeDocument before = Collection.NODES.newDocument(this.store);
            commitRootDoc.deepCopy(before);
            UpdateUtils.applyChanges(before, commit.getReverseOperation());
            return before;
        }
        LOG.info("Update didn't make it to the store. Re-throwing the exception");
        throw e;
    }

    private NodeDocument batchUpdateCommitRoot(UpdateOp commit) throws DocumentStoreException {
        try {
            return this.batchCommitQueue.updateDocument(commit).call();
        }
        catch (InterruptedException e) {
            throw DocumentStoreException.convert((Throwable)e, "Interrupted while updating commit root document");
        }
        catch (Exception e) {
            throw DocumentStoreException.convert((Throwable)e, "Update of commit root document failed");
        }
    }

    @NotNull
    DocumentNodeState getRoot(@NotNull RevisionVector revision) {
        DocumentNodeState root = this.getNode(Path.ROOT, revision);
        if (root == null) {
            throw new IllegalStateException("root node does not exist at revision " + revision);
        }
        return root;
    }

    @NotNull
    DocumentNodeStoreBranch createBranch(DocumentNodeState base) {
        return new DocumentNodeStoreBranch(this, base, this.mergeLock);
    }

    @NotNull
    RevisionVector rebase(@NotNull RevisionVector branchHead, @NotNull RevisionVector base) {
        Preconditions.checkNotNull((Object)branchHead);
        Preconditions.checkNotNull((Object)base);
        if (this.disableBranches) {
            return branchHead;
        }
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            return base.asBranchRevision(this.getClusterId());
        }
        if (b.getBase(branchHead.getBranchRevision()).equals(base)) {
            return branchHead;
        }
        Revision head = this.newRevision().asBranchRevision();
        b.rebase(head, base);
        return base.update(head);
    }

    @NotNull
    RevisionVector reset(@NotNull RevisionVector branchHead, @NotNull RevisionVector ancestor) {
        Preconditions.checkNotNull((Object)branchHead);
        Preconditions.checkNotNull((Object)ancestor);
        Branch b = this.getBranches().getBranch(branchHead);
        if (b == null) {
            throw new DocumentStoreException("Empty branch cannot be reset");
        }
        if (!b.getCommits().last().equals(branchHead.getRevision(this.getClusterId()))) {
            throw new DocumentStoreException(branchHead + " is not the head of a branch");
        }
        Revision ancestorRev = ancestor.getBranchRevision();
        if (!b.containsCommit(ancestorRev) && !b.getBase().asBranchRevision(this.getClusterId()).equals(ancestor)) {
            throw new DocumentStoreException(ancestor + " is not an ancestor revision of " + branchHead);
        }
        ArrayList<Revision> revs = new ArrayList<Revision>();
        if (!b.containsCommit(ancestorRev)) {
            revs.add(ancestorRev);
        }
        revs.addAll(b.getCommits().tailSet(ancestorRev));
        UpdateOp rootOp = new UpdateOp(Utils.getIdFromPath(Path.ROOT), false);
        HashMap operations = Maps.newHashMap();
        AtomicReference<Revision> currentRev = new AtomicReference<Revision>();
        for (Revision r : Lists.reverse(revs)) {
            operations.clear();
            Revision previous = currentRev.getAndSet(r);
            if (previous == null) continue;
            NodeDocument.removeCollision(rootOp, previous.asTrunkRevision());
            NodeDocument.removeRevision(rootOp, previous.asTrunkRevision());
            NodeDocument.removeBranchCommit(rootOp, previous.asTrunkRevision());
            Branch.BranchCommit bc = b.getCommit(previous);
            if (bc.isRebase()) continue;
            DocumentNodeState branchState = this.getRoot(bc.getBase().update(previous));
            DocumentNodeState baseState = this.getRoot(bc.getBase().update(r));
            LOG.debug("reset: comparing branch {} with base {}", (Object)branchState.getRootRevision(), (Object)baseState.getRootRevision());
            branchState.compareAgainstBaseState((NodeState)baseState, new ResetDiff(previous.asTrunkRevision(), operations));
            LOG.debug("reset: applying {} operations", (Object)operations.size());
            for (List ops : Iterables.partition(operations.values(), (int)this.getCreateOrUpdateBatchSize())) {
                this.store.createOrUpdate(Collection.NODES, ops);
            }
        }
        this.store.findAndUpdate(Collection.NODES, rootOp);
        for (Revision r : revs) {
            if (r.equals(ancestorRev)) continue;
            b.removeCommit(r);
        }
        return ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    RevisionVector merge(@NotNull RevisionVector branchHead, @NotNull CommitInfo info) throws ConflictException, CommitFailedException {
        RevisionVector newHead;
        Branch b = this.getBranches().getBranch(branchHead);
        RevisionVector base = branchHead;
        if (b != null) {
            base = b.getBase(branchHead.getBranchRevision());
        }
        int numBranchCommits = b != null ? b.getCommits().size() : 1;
        boolean success = false;
        MergeCommit commit = this.newMergeCommit(base, numBranchCommits);
        try {
            UpdateOp op = new UpdateOp(Utils.getIdFromPath(Path.ROOT), false);
            NodeDocument.setModified(op, commit.getRevision());
            if (b != null) {
                this.checkBranchAge(b);
                commit.addBranchCommits(b);
                Iterator mergeCommits = commit.getMergeRevisions().iterator();
                for (Revision rev : b.getCommits()) {
                    rev = rev.asTrunkRevision();
                    String commitTag = "c-" + mergeCommits.next();
                    NodeDocument.setRevision(op, rev, commitTag);
                    op.containsMapEntry("_collisions", rev, false);
                }
                if (this.store.findAndUpdate(Collection.NODES, op) != null) {
                    b.applyTo(this.getPendingModifications(), commit.getRevision());
                    this.getBranches().remove(b);
                } else {
                    NodeDocument root = Utils.getRootDocument(this.store);
                    Set<Revision> conflictRevs = root.getConflictsFor(b.getCommits());
                    String msg = "Conflicting concurrent change. Update operation failed: " + op;
                    throw new ConflictException(msg, conflictRevs);
                }
            }
            newHead = this.done(commit, false, info);
            success = true;
        }
        finally {
            if (!success) {
                this.canceled(commit);
            }
        }
        return newHead;
    }

    @Override
    public boolean compare(final @NotNull AbstractDocumentNodeState node, final @NotNull AbstractDocumentNodeState base, @NotNull NodeStateDiff diff) {
        if (!AbstractNodeState.comparePropertiesAgainstBaseState((NodeState)node, (NodeState)base, (NodeStateDiff)diff)) {
            return false;
        }
        if (node.hasNoChildren() && base.hasNoChildren()) {
            return true;
        }
        return new JsopNodeStateDiffer(this.diffCache.getChanges(base.getRootRevision(), node.getRootRevision(), node.getPath(), new DiffCache.Loader(){

            @Override
            public String call() {
                return DocumentNodeStore.this.diffImpl(base, node);
            }
        })).withoutPropertyChanges().compare(node, base, diff);
    }

    LastRevTracker createTracker(final @NotNull Revision r, boolean isBranchCommit) {
        if (isBranchCommit && !this.disableBranches) {
            Revision branchRev = r.asBranchRevision();
            return this.branches.getBranchCommit(branchRev);
        }
        return new LastRevTracker(){

            @Override
            public void track(Path path) {
                DocumentNodeStore.this.unsavedLastRevisions.put(path, r);
            }
        };
    }

    long suspendUntilAll(@NotNull Set<Revision> conflictRevisions) {
        long time = this.clock.getTime();
        if (this.getAsyncDelay() == 0) {
            HashSet<Revision> onlyLocal = new HashSet<Revision>(conflictRevisions.size());
            for (Revision r : conflictRevisions) {
                if (r.getClusterId() != this.getClusterId()) continue;
                onlyLocal.add(r);
            }
            this.commitQueue.suspendUntilAll(onlyLocal);
        } else {
            this.commitQueue.suspendUntilAll(conflictRevisions);
        }
        return this.clock.getTime() - time;
    }

    public Closeable addObserver(Observer observer) {
        return this.dispatcher.addObserver(observer);
    }

    @NotNull
    public DocumentNodeState getRoot() {
        return this.root;
    }

    @NotNull
    public NodeState merge(@NotNull NodeBuilder builder, @NotNull CommitHook commitHook, @NotNull CommitInfo info) throws CommitFailedException {
        return DocumentNodeStore.asDocumentRootBuilder(builder).merge(commitHook, info);
    }

    @NotNull
    public NodeState rebase(@NotNull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).rebase();
    }

    public NodeState reset(@NotNull NodeBuilder builder) {
        return DocumentNodeStore.asDocumentRootBuilder(builder).reset();
    }

    @NotNull
    public BlobStoreBlob createBlob(InputStream inputStream) throws IOException {
        return new BlobStoreBlob(this.blobStore, this.blobStore.writeBlob(inputStream));
    }

    public Blob getBlob(@NotNull String reference) {
        String blobId = this.blobStore.getBlobId(reference);
        if (blobId != null) {
            return new BlobStoreBlob(this.blobStore, blobId);
        }
        LOG.debug("No blobId found matching reference [{}]", (Object)reference);
        return null;
    }

    public Blob getBlobFromBlobId(String blobId) {
        return new BlobStoreBlob(this.blobStore, blobId);
    }

    @NotNull
    public String checkpoint(long lifetime, @NotNull Map<String, String> properties) {
        this.checkOpen();
        return this.checkpoints.create(lifetime, properties).toString();
    }

    @NotNull
    public String checkpoint(long lifetime) {
        this.checkOpen();
        Map<String, String> empty = Collections.emptyMap();
        return this.checkpoint(lifetime, empty);
    }

    @NotNull
    public Map<String, String> checkpointInfo(@NotNull String checkpoint) {
        this.checkOpen();
        Revision r = Revision.fromString(checkpoint);
        Checkpoints.Info info = (Checkpoints.Info)this.checkpoints.getCheckpoints().get(r);
        if (info == null) {
            return Collections.emptyMap();
        }
        return info.get();
    }

    @NotNull
    public Iterable<String> checkpoints() {
        this.checkOpen();
        final long now = this.clock.getTime();
        return Iterables.transform((Iterable)Iterables.filter(this.checkpoints.getCheckpoints().entrySet(), (Predicate)new Predicate<Map.Entry<Revision, Checkpoints.Info>>(){

            public boolean apply(Map.Entry<Revision, Checkpoints.Info> cp) {
                return cp.getValue().getExpiryTime() > now;
            }
        }), (Function)new Function<Map.Entry<Revision, Checkpoints.Info>, String>(){

            public String apply(Map.Entry<Revision, Checkpoints.Info> cp) {
                return cp.getKey().toString();
            }
        });
    }

    @Nullable
    public NodeState retrieve(@NotNull String checkpoint) {
        this.checkOpen();
        RevisionVector rv = this.getCheckpoints().retrieve(checkpoint);
        if (rv == null) {
            return null;
        }
        this.suspendUntilAll(Sets.newHashSet((Iterable)rv));
        return this.getRoot(rv);
    }

    public boolean release(@NotNull String checkpoint) {
        this.checkOpen();
        this.checkpoints.release(checkpoint);
        return true;
    }

    @Override
    public UnmergedBranches getBranches() {
        return this.branches;
    }

    @Override
    public UnsavedModifications getPendingModifications() {
        return this.unsavedLastRevisions;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    @NotNull
    public RevisionVector getHeadRevision() {
        return this.root.getRootRevision();
    }

    @Override
    @NotNull
    public Revision newRevision() {
        if (this.simpleRevisionCounter != null) {
            return new Revision(this.simpleRevisionCounter.getAndIncrement(), 0, this.clusterId);
        }
        Revision r = Revision.newRevision(this.clusterId);
        if (this.clusterNodeInfo.getLeaseCheckMode() == LeaseCheckMode.STRICT) {
            long leaseEnd = this.clusterNodeInfo.getLeaseEndTime();
            if (r.getTimestamp() >= leaseEnd) {
                String msg = String.format("Cannot use new revision %s with timestamp %s >= lease end %s", r, r.getTimestamp(), leaseEnd);
                throw new DocumentStoreException(msg);
            }
        }
        return r;
    }

    @Override
    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public String getCommitValue(@NotNull Revision changeRevision, @NotNull NodeDocument doc) {
        return this.commitValueResolver.resolve(changeRevision, doc);
    }

    public void runBackgroundOperations() {
        this.runBackgroundSweepOperation();
        this.runBackgroundUpdateOperations();
        this.runBackgroundReadOperations();
    }

    void runBackgroundUpdateOperations() {
        if (this.readOnlyMode || this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundUpdateOperations();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                return;
            }
            LOG.warn("Background update operation failed (will be retried with next run): " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunBackgroundUpdateOperations() {
        BackgroundWriteStats stats;
        Object object = this.backgroundWriteMonitor;
        synchronized (object) {
            long start;
            long time = start = this.clock.getTime();
            this.cleanOrphanedBranches();
            this.cleanRootCollisions();
            long cleanTime = this.clock.getTime() - time;
            time = this.clock.getTime();
            this.backgroundSplit();
            long splitTime = this.clock.getTime() - time;
            time = this.clock.getTime();
            this.maybeRefreshHeadRevision();
            long refreshTime = this.clock.getTime() - time;
            stats = this.backgroundWrite();
            stats.refresh = refreshTime;
            stats.split = splitTime;
            stats.clean = cleanTime;
            stats.totalWriteTime = this.clock.getTime() - start;
            String msg = "Background operations stats ({})";
            this.logBackgroundOperation(start, msg, stats);
        }
        this.nodeStoreStatsCollector.doneBackgroundUpdate(stats);
    }

    void runBackgroundReadOperations() {
        if (this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundReadOperations();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                return;
            }
            LOG.warn("Background read operation failed: " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunBackgroundReadOperations() {
        BackgroundReadStats readStats = null;
        Object object = this.backgroundReadMonitor;
        synchronized (object) {
            long start = this.clock.getTime();
            readStats = this.backgroundRead();
            readStats.totalReadTime = this.clock.getTime() - start;
            String msg = "Background read operations stats (read:{} {})";
            this.logBackgroundOperation(start, msg, readStats.totalReadTime, readStats);
        }
        this.nodeStoreStatsCollector.doneBackgroundRead(readStats);
    }

    void runBackgroundSweepOperation() {
        if (this.readOnlyMode || this.isDisposed.get()) {
            return;
        }
        try {
            this.internalRunBackgroundSweepOperation();
        }
        catch (RuntimeException e) {
            if (this.isDisposed.get()) {
                return;
            }
            LOG.warn("Background sweep operation failed (will be retried with next run): " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunBackgroundSweepOperation() throws DocumentStoreException {
        BackgroundWriteStats stats = new BackgroundWriteStats();
        Object object = this.backgroundSweepMonitor;
        synchronized (object) {
            long start = this.clock.getTime();
            stats.num = this.backgroundSweep();
            stats.sweep = this.clock.getTime() - start;
            String msg = "Background sweep operation stats ({})";
            this.logBackgroundOperation(start, msg, stats);
        }
        this.nodeStoreStatsCollector.doneBackgroundUpdate(stats);
    }

    private void logBackgroundOperation(long startTime, String message, Object ... arguments) {
        if (this.clock.getTime() - startTime > TimeUnit.SECONDS.toMillis(10L)) {
            LOG.info(message, arguments);
        } else {
            LOG.debug(message, arguments);
        }
    }

    boolean renewClusterIdLease() {
        Stopwatch sw = Stopwatch.createStarted();
        boolean renewedOrException = true;
        try {
            renewedOrException = this.clusterNodeInfo.renewLease();
        }
        finally {
            if (renewedOrException) {
                this.nodeStoreStatsCollector.doneLeaseUpdate(sw.elapsed(TimeUnit.MICROSECONDS));
            }
        }
        return renewedOrException;
    }

    boolean updateClusterState() {
        boolean hasChanged = false;
        HashSet clusterIds = Sets.newHashSet();
        for (ClusterNodeInfoDocument doc : ClusterNodeInfoDocument.all(this.nonLeaseCheckingStore)) {
            int cId = doc.getClusterId();
            clusterIds.add(cId);
            ClusterNodeInfoDocument old = (ClusterNodeInfoDocument)this.clusterNodes.get(cId);
            if (old != null && !old.isActive() && !doc.isActive()) continue;
            this.clusterNodes.put(cId, doc);
            if (old != null && old.isActive() == doc.isActive()) continue;
            hasChanged = true;
        }
        return hasChanged |= this.clusterNodes.keySet().retainAll(clusterIds);
    }

    @NotNull
    private RevisionVector getMinExternalRevisions() {
        return Utils.getStartRevisions(this.clusterNodes.values()).remove(this.getClusterId());
    }

    private BackgroundReadStats backgroundRead() {
        return new ExternalChange(this){

            @Override
            void invalidateCache(@NotNull Iterable<String> paths) {
                this.stats.cacheStats = DocumentNodeStore.this.store.invalidateCache(Utils.pathToId(paths));
            }

            @Override
            void invalidateCache() {
                this.stats.cacheStats = DocumentNodeStore.this.store.invalidateCache();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void updateHead(@NotNull Set<Revision> externalChanges, @NotNull RevisionVector sweepRevs, @Nullable Iterable<String> changedPaths) {
                long time = DocumentNodeStore.this.clock.getTime();
                DocumentNodeStore.this.backgroundOperationLock.writeLock().lock();
                try {
                    RevisionVector oldHead;
                    this.stats.lock = DocumentNodeStore.this.clock.getTime() - time;
                    RevisionVector newHead = oldHead = DocumentNodeStore.this.getHeadRevision();
                    for (Revision r : externalChanges) {
                        newHead = newHead.update(r);
                    }
                    DocumentNodeStore.this.setRoot(newHead);
                    DocumentNodeStore.this.sweepRevisions = DocumentNodeStore.this.sweepRevisions.pmax(sweepRevs);
                    DocumentNodeStore.this.commitQueue.headRevisionChanged();
                    time = DocumentNodeStore.this.clock.getTime();
                    if (changedPaths != null) {
                        try {
                            JournalEntry.applyTo(changedPaths, DocumentNodeStore.this.diffCache, Path.ROOT, oldHead, newHead);
                        }
                        catch (Exception e1) {
                            LOG.error("backgroundRead: Exception while processing external changes from journal: " + e1, (Throwable)e1);
                        }
                    }
                    this.stats.populateDiffCache = DocumentNodeStore.this.clock.getTime() - time;
                    time = DocumentNodeStore.this.clock.getTime();
                    ChangeSet changeSet = this.getChangeSetBuilder().build();
                    LOG.debug("Dispatching external change with ChangeSet {}", (Object)changeSet);
                    DocumentNodeStore.this.dispatcher.contentChanged((NodeState)DocumentNodeStore.this.getRoot().fromExternalChange(), DocumentNodeStore.newCommitInfo(changeSet, this.getJournalPropertyHandler()));
                }
                finally {
                    DocumentNodeStore.this.backgroundOperationLock.writeLock().unlock();
                }
                this.stats.dispatchChanges = DocumentNodeStore.this.clock.getTime() - time;
            }
        }.process();
    }

    private static CommitInfo newCommitInfo(@NotNull ChangeSet changeSet, JournalPropertyHandler journalPropertyHandler) {
        SimpleCommitContext commitContext = new SimpleCommitContext();
        commitContext.set("oak.observation.changeSet", (Object)changeSet);
        journalPropertyHandler.addTo((CommitContext)commitContext);
        ImmutableMap info = ImmutableMap.of((Object)"oak.commitAttributes", (Object)commitContext);
        return new CommitInfo("oak:unknown", "oak:unknown", (Map)info, true);
    }

    private static ChangeSet getChangeSet(CommitInfo info) {
        CommitContext commitContext = (CommitContext)info.getInfo().get("oak.commitAttributes");
        if (commitContext == null) {
            return null;
        }
        return (ChangeSet)commitContext.get("oak.observation.changeSet");
    }

    private ChangeSetBuilder newChangeSetBuilder() {
        return new ChangeSetBuilder(this.changeSetMaxItems, this.changeSetMaxDepth);
    }

    private void cleanOrphanedBranches() {
        Branch b;
        while ((b = this.branches.pollOrphanedBranch()) != null) {
            LOG.debug("Cleaning up orphaned branch with base revision: {}, commits: {}", (Object)b.getBase(), b.getCommits());
            UpdateOp op = new UpdateOp(Utils.getIdFromPath(Path.ROOT), false);
            for (Revision r : b.getCommits()) {
                r = r.asTrunkRevision();
                NodeDocument.removeRevision(op, r);
                NodeDocument.removeBranchCommit(op, r);
            }
            this.store.findAndUpdate(Collection.NODES, op);
        }
    }

    private void cleanRootCollisions() {
        String id = Utils.getIdFromPath(Path.ROOT);
        NodeDocument root = this.store.find(Collection.NODES, id);
        if (root != null) {
            this.cleanCollisions(root, Integer.MAX_VALUE);
        }
    }

    private void cleanCollisions(NodeDocument doc, int limit) {
        RevisionVector head = this.getHeadRevision();
        SortedMap<Revision, String> map = doc.getLocalMap("_collisions");
        UpdateOp op = new UpdateOp(doc.getId(), false);
        for (Revision r : map.keySet()) {
            if (r.getClusterId() != this.clusterId || this.branches.getBranchCommit(r) != null || head.isRevisionNewer(r)) continue;
            NodeDocument.removeCollision(op, r);
            if (--limit > 0) continue;
            break;
        }
        if (op.hasChanges()) {
            LOG.debug("Removing collisions {} on {}", op.getChanges().keySet(), (Object)doc.getId());
            this.store.findAndUpdate(Collection.NODES, op);
        }
    }

    private void backgroundSplit() {
        int initialCapacity = this.getCreateOrUpdateBatchSize() + 4;
        HashSet<Path> invalidatedPaths = new HashSet<Path>(initialCapacity);
        HashSet<Path> pathsToInvalidate = new HashSet<Path>(initialCapacity);
        RevisionVector head = this.getHeadRevision();
        ArrayList<UpdateOp> splitOpsPhase1 = new ArrayList<UpdateOp>(initialCapacity);
        ArrayList<UpdateOp> splitOpsPhase2 = new ArrayList<UpdateOp>(initialCapacity);
        ArrayList<String> removeCandidates = new ArrayList<String>(initialCapacity);
        for (String id : this.splitCandidates.keySet()) {
            removeCandidates.add(id);
            NodeDocument doc = this.store.find(Collection.NODES, id);
            if (doc == null) continue;
            this.cleanCollisions(doc, this.collisionGarbageBatchSize);
            Iterator<UpdateOp> it = doc.split(this, head, this.binarySize).iterator();
            while (it.hasNext()) {
                UpdateOp op = it.next();
                Path path = doc.getPath();
                if (this.unsavedLastRevisions.get(path) == null && !invalidatedPaths.contains(path)) {
                    pathsToInvalidate.add(path);
                }
                if (it.hasNext()) {
                    splitOpsPhase1.add(op);
                    continue;
                }
                splitOpsPhase2.add(op);
            }
            if (splitOpsPhase1.size() < this.getCreateOrUpdateBatchSize() && splitOpsPhase2.size() < this.getCreateOrUpdateBatchSize()) continue;
            this.invalidatePaths(pathsToInvalidate);
            this.batchSplit(splitOpsPhase1);
            this.batchSplit(splitOpsPhase2);
            invalidatedPaths.addAll(pathsToInvalidate);
            pathsToInvalidate.clear();
            splitOpsPhase1.clear();
            splitOpsPhase2.clear();
            this.splitCandidates.keySet().removeAll(removeCandidates);
            removeCandidates.clear();
        }
        if (splitOpsPhase1.size() + splitOpsPhase2.size() > 0) {
            this.invalidatePaths(pathsToInvalidate);
            this.batchSplit(splitOpsPhase1);
            this.batchSplit(splitOpsPhase2);
        }
        this.splitCandidates.keySet().removeAll(removeCandidates);
    }

    private void invalidatePaths(@NotNull Set<Path> pathsToInvalidate) {
        if (pathsToInvalidate.isEmpty()) {
            return;
        }
        JournalEntry entry = Collection.JOURNAL.newDocument(this.getDocumentStore());
        entry.modified(pathsToInvalidate);
        Revision r = this.newRevision().asBranchRevision();
        UpdateOp journalOp = entry.asUpdateOp(r);
        if (!this.store.create(Collection.JOURNAL, Collections.singletonList(journalOp))) {
            String msg = "Unable to create journal entry " + journalOp.getId() + " for document invalidation. Will be retried with next background split operation.";
            throw new DocumentStoreException(msg);
        }
        this.changes.invalidate(Collections.singletonList(r));
        LOG.debug("Journal entry {} created for split of document(s) {}", (Object)journalOp.getId(), pathsToInvalidate);
    }

    private void batchSplit(@NotNull List<UpdateOp> splitOps) {
        if (splitOps.isEmpty()) {
            return;
        }
        List<NodeDocument> beforeList = this.store.createOrUpdate(Collection.NODES, splitOps);
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < splitOps.size(); ++i) {
                NodeDocument before;
                UpdateOp op = splitOps.get(i);
                NodeDocument nodeDocument = before = beforeList.size() > i ? beforeList.get(i) : null;
                if (before != null) {
                    NodeDocument after = this.store.find(Collection.NODES, op.getId());
                    if (after == null) continue;
                    LOG.debug("Split operation on {}. Size before: {}, after: {}", new Object[]{op.getId(), before.getMemory(), after.getMemory()});
                    continue;
                }
                LOG.debug("Split operation created {}", (Object)op.getId());
            }
        }
    }

    @NotNull
    Set<String> getSplitCandidates() {
        return Collections.unmodifiableSet(this.splitCandidates.keySet());
    }

    @NotNull
    RevisionVector getSweepRevisions() {
        return this.sweepRevisions;
    }

    int getCreateOrUpdateBatchSize() {
        return this.createOrUpdateBatchSize;
    }

    private BackgroundWriteStats backgroundWrite() {
        return this.unsavedLastRevisions.persist(this.getDocumentStore(), new Supplier<Revision>(){

            public Revision get() {
                return DocumentNodeStore.this.getSweepRevisions().getRevision(DocumentNodeStore.this.getClusterId());
            }
        }, new UnsavedModifications.Snapshot(){

            @Override
            public void acquiring(Revision mostRecent) {
                DocumentNodeStore.this.pushJournalEntry(mostRecent);
            }
        }, this.backgroundOperationLock.writeLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRefreshHeadRevision() {
        if (this.isDisposed.get() || this.isDisableBranches()) {
            return;
        }
        DocumentNodeState rootState = this.getRoot();
        Revision head = rootState.getRootRevision().getRevision(this.clusterId);
        Revision lastRev = rootState.getLastRevision().getRevision(this.clusterId);
        long oneMinuteAgo = this.clock.getTime() - ONE_MINUTE_MS;
        if (head != null && head.getTimestamp() < oneMinuteAgo || lastRev != null && lastRev.getTimestamp() < oneMinuteAgo) {
            boolean success = false;
            Commit c = this.newTrunkCommit(nop -> {}, this.getHeadRevision());
            try {
                c.markChanged(Path.ROOT);
                this.done(c, false, CommitInfo.EMPTY);
                success = true;
            }
            finally {
                if (!success) {
                    this.canceled(c);
                }
            }
        }
    }

    boolean backgroundSweep2(long sweep2Lock) throws DocumentStoreException {
        Sweep2StatusDocument statusDoc;
        if (sweep2Lock == 0L) {
            sweep2Lock = Sweep2Helper.acquireSweep2LockIfNecessary(this.store, this.clusterId);
            if (sweep2Lock == 0L) {
                return false;
            }
            if (sweep2Lock == -1L) {
                return true;
            }
        }
        if ((statusDoc = Sweep2StatusDocument.readFrom(this.store)) != null && statusDoc.isChecking()) {
            LOG.info("backgroundSweep2: checking whether sweep2 is necessary...");
            if (!Sweep2Helper.isSweep2Necessary(this.store)) {
                LOG.info("backgroundSweep2: sweep2 check determined a sweep2 is NOT necessary. Marking sweep2 status as 'swept'.");
                if (!Sweep2StatusDocument.forceReleaseSweep2LockAndMarkSwept(this.store, this.clusterId)) {
                    LOG.error("backgroundSweep2 : failed to update the sweep2 status to 'swept'. Aborting sweep2 for now.");
                }
                return true;
            }
            LOG.info("backgroundSweep2: sweep2 check determined a sweep2 IS necessary. Marking sweep2 status as 'sweeping'.");
        }
        if ((sweep2Lock = Sweep2StatusDocument.acquireOrUpdateSweep2Lock(this.store, this.clusterId, true)) == 0L) {
            LOG.info("backgroundSweep2: could not update the sweep2 lock to sweeping, someone got in between. Retry later.");
            return false;
        }
        if (sweep2Lock == -1L) {
            LOG.info("backgroundSweep2: meanwhile, someone else concluded sweep2 is done.");
            return true;
        }
        LinkedList<Integer> includedClusterIds = new LinkedList<Integer>();
        for (Revision aSweepRev : this.sweepRevisions) {
            includedClusterIds.add(aSweepRev.getClusterId());
        }
        LOG.info("backgroundSweep2: starting sweep2 (includedClusterIds={})", includedClusterIds);
        int num = this.forceBackgroundSweep2(includedClusterIds);
        LOG.info("backgroundSweep2: finished sweep2, num swept=" + num);
        if (!Sweep2StatusDocument.forceReleaseSweep2LockAndMarkSwept(this.store, this.clusterId)) {
            LOG.error("backgroundSweep2 : sweep2 finished but we failed to update the sweep2 status accordingly");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int forceBackgroundSweep2(List<Integer> includedClusterIds) throws DocumentStoreException {
        RevisionVector emptySweepRevision = new RevisionVector(new Revision[0]);
        CachingCommitValueResolver cvr = new CachingCommitValueResolver(0, (Supplier<RevisionVector>)((Supplier)() -> emptySweepRevision));
        MissingBcSweeper2 sweeper = new MissingBcSweeper2(this, cvr, includedClusterIds, this.isDisposed);
        LOG.info("Starting document sweep2. Head: {}, starting at 0", (Object)this.getHeadRevision());
        Iterable<NodeDocument> docs = this.lastRevSeeker.getCandidates(0L);
        try {
            final AtomicInteger numUpdates = new AtomicInteger();
            sweeper.sweep2(docs, new NodeDocumentSweepListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sweepUpdate(final Map<Path, UpdateOp> updates) throws DocumentStoreException {
                    DocumentNodeStore.this.backgroundOperationLock.readLock().lock();
                    try {
                        boolean success = false;
                        Revision r = DocumentNodeStore.this.commitQueue.createRevision();
                        try {
                            DocumentNodeStore.this.commitQueue.done(r, new CommitQueue.Callback(){

                                @Override
                                public void headOfQueue(@NotNull Revision revision) {
                                    this.writeUpdates(updates, revision);
                                }
                            });
                            success = true;
                        }
                        finally {
                            if (!success && DocumentNodeStore.this.commitQueue.contains(r)) {
                                DocumentNodeStore.this.commitQueue.canceled(r);
                            }
                        }
                    }
                    finally {
                        DocumentNodeStore.this.backgroundOperationLock.readLock().unlock();
                    }
                }

                private void writeUpdates(Map<Path, UpdateOp> updates, Revision revision) throws DocumentStoreException {
                    JournalEntry entry = Collection.JOURNAL.newDocument(DocumentNodeStore.this.getDocumentStore());
                    entry.modified(updates.keySet());
                    Revision r = DocumentNodeStore.this.newRevision().asBranchRevision();
                    if (!DocumentNodeStore.this.store.create(Collection.JOURNAL, Collections.singletonList(entry.asUpdateOp(r)))) {
                        String msg = "Unable to create journal entry for document invalidation. Will be retried with next background sweep2 operation.";
                        throw new DocumentStoreException(msg);
                    }
                    DocumentNodeStore.this.changes.invalidate(Collections.singleton(r));
                    DocumentNodeStore.this.unsavedLastRevisions.put(Path.ROOT, revision);
                    RevisionVector newHead = DocumentNodeStore.this.getHeadRevision().update(revision);
                    DocumentNodeStore.this.setRoot(newHead);
                    DocumentNodeStore.this.commitQueue.headRevisionChanged();
                    DocumentNodeStore.this.store.createOrUpdate(Collection.NODES, Lists.newArrayList(updates.values()));
                    numUpdates.addAndGet(updates.size());
                    LOG.debug("Background sweep2 updated {}", updates.keySet());
                }
            });
            int n = numUpdates.get();
            return n;
        }
        finally {
            Utils.closeIfCloseable(docs);
        }
    }

    private int backgroundSweep() throws DocumentStoreException {
        Revision head = this.getHeadRevision().getRevision(this.clusterId);
        if (head == null) {
            return 0;
        }
        TreeSet garbage = Sets.newTreeSet(StableRevisionComparator.INSTANCE);
        for (Revision r : this.inDoubtTrunkCommits) {
            if (r.compareRevisionTime(head) >= 0) continue;
            garbage.add(r);
        }
        Revision sweepRev = this.sweepRevisions.getRevision(this.clusterId);
        if (garbage.isEmpty() && sweepRev != null) {
            this.updateSweepRevision(head);
            return 0;
        }
        Revision startRev = new Revision(0L, 0, this.clusterId);
        if (!garbage.isEmpty()) {
            startRev = (Revision)garbage.first();
        }
        Object reason = "";
        if (!garbage.isEmpty()) {
            reason = garbage.size() + " garbage revision(s)";
        }
        if (sweepRev == null) {
            if (!((String)reason).isEmpty()) {
                reason = (String)reason + ", ";
            }
            reason = (String)reason + "no sweepRevision for " + this.clusterId;
        }
        int num = this.forceBackgroundSweep(startRev, (String)reason);
        this.inDoubtTrunkCommits.removeAll(garbage);
        return num;
    }

    private void purgeUnmergedBranchCommitAndCollisionMarkers(ClusterNodeInfoDocument cluster) {
        this.branches.purgeUnmergedBranchCommitAndCollisionMarkers(this.store, cluster.getClusterId(), this.purgeUncommittedRevisions, cluster.isOlderThanLastWrittenRootRevPredicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int forceBackgroundSweep(Revision startRev, String reason) throws DocumentStoreException {
        NodeDocumentSweeper sweeper = new NodeDocumentSweeper(this, false);
        LOG.info("Starting document sweep. Head: {}, starting at {} (reason: {})", new Object[]{sweeper.getHeadRevision(), startRev, reason});
        Iterable<NodeDocument> docs = this.lastRevSeeker.getCandidates(startRev.getTimestamp());
        try {
            final AtomicInteger numUpdates = new AtomicInteger();
            Revision newSweepRev = sweeper.sweep(docs, new NodeDocumentSweepListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sweepUpdate(final Map<Path, UpdateOp> updates) throws DocumentStoreException {
                    DocumentNodeStore.this.backgroundOperationLock.readLock().lock();
                    try {
                        boolean success = false;
                        Revision r = DocumentNodeStore.this.commitQueue.createRevision();
                        try {
                            DocumentNodeStore.this.commitQueue.done(r, new CommitQueue.Callback(){

                                @Override
                                public void headOfQueue(@NotNull Revision revision) {
                                    this.writeUpdates(updates, revision);
                                }
                            });
                            success = true;
                        }
                        finally {
                            if (!success && DocumentNodeStore.this.commitQueue.contains(r)) {
                                DocumentNodeStore.this.commitQueue.canceled(r);
                            }
                        }
                    }
                    finally {
                        DocumentNodeStore.this.backgroundOperationLock.readLock().unlock();
                    }
                }

                private void writeUpdates(Map<Path, UpdateOp> updates, Revision revision) throws DocumentStoreException {
                    JournalEntry entry = Collection.JOURNAL.newDocument(DocumentNodeStore.this.getDocumentStore());
                    entry.modified(updates.keySet());
                    Revision r = DocumentNodeStore.this.newRevision().asBranchRevision();
                    if (!DocumentNodeStore.this.store.create(Collection.JOURNAL, Collections.singletonList(entry.asUpdateOp(r)))) {
                        String msg = "Unable to create journal entry for document invalidation. Will be retried with next background sweep operation.";
                        throw new DocumentStoreException(msg);
                    }
                    DocumentNodeStore.this.changes.invalidate(Collections.singleton(r));
                    DocumentNodeStore.this.unsavedLastRevisions.put(Path.ROOT, revision);
                    RevisionVector newHead = DocumentNodeStore.this.getHeadRevision().update(revision);
                    DocumentNodeStore.this.setRoot(newHead);
                    DocumentNodeStore.this.commitQueue.headRevisionChanged();
                    DocumentNodeStore.this.store.createOrUpdate(Collection.NODES, Lists.newArrayList(updates.values()));
                    numUpdates.addAndGet(updates.size());
                    LOG.debug("Background sweep updated {}", updates.keySet());
                }
            });
            if (newSweepRev != null) {
                this.updateSweepRevision(newSweepRev);
            }
            int n = numUpdates.get();
            return n;
        }
        finally {
            Utils.closeIfCloseable(docs);
        }
    }

    private void updateSweepRevision(Revision newSweepRevision) {
        this.backgroundOperationLock.readLock().lock();
        try {
            this.sweepRevisions = this.sweepRevisions.pmax(new RevisionVector(newSweepRevision));
        }
        finally {
            this.backgroundOperationLock.readLock().unlock();
        }
    }

    private void checkServerTimeDifference(DocumentStore s) throws AssertionError {
        try {
            if (this.maxTimeDiffMillis >= 0L) {
                long timeDiff = s.determineServerTimeDifferenceMillis();
                LOG.info("Server time difference: {}ms (max allowed: {}ms)", (Object)timeDiff, (Object)this.maxTimeDiffMillis);
                if (Math.abs(timeDiff) > this.maxTimeDiffMillis) {
                    throw new AssertionError((Object)("Server clock seems off (" + timeDiff + "ms) by more than configured amount (" + this.maxTimeDiffMillis + "ms)"));
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Got RuntimeException while trying to determine time difference to server: " + e, (Throwable)e);
        }
    }

    private static void checkVersion(DocumentStore store, boolean readOnlyMode) throws DocumentStoreException {
        FormatVersion storeVersion = FormatVersion.versionOf(store);
        if (!VERSION.canRead(storeVersion)) {
            throw new DocumentStoreException("Cannot open DocumentNodeStore. Existing data in DocumentStore was written with more recent version. Store version: " + storeVersion + ", this version: " + VERSION);
        }
        if (!readOnlyMode) {
            if (storeVersion == FormatVersion.V0) {
                VERSION.writeTo(store);
                LOG.info("FormatVersion set to {}", (Object)VERSION);
            } else if (!VERSION.equals(storeVersion)) {
                throw new DocumentStoreException("Cannot open DocumentNodeStore in read-write mode. Existing data in DocumentStore was written with older version. Store version: " + storeVersion + ", this version: " + VERSION + ". Use the oak-run-" + Utils.getModuleVersion() + ".jar tool with the unlockUpgrade command first.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkRevisionAge(DocumentStore store, ClusterNodeInfo info, Clock clock) throws DocumentStoreException {
        boolean success = false;
        try {
            Utils.checkRevisionAge(store, info, clock);
            success = true;
        }
        finally {
            if (!success) {
                info.dispose();
            }
        }
    }

    private void pushJournalEntry(Revision r) throws DocumentStoreException {
        if (!this.changes.hasChanges()) {
            LOG.debug("Not pushing journal as there are no changes");
        } else if (this.store.create(Collection.JOURNAL, Collections.singletonList(this.changes.asUpdateOp(r)))) {
            this.changes = this.newJournalEntry();
        } else {
            LOG.error("Failed to write to journal({}), accumulating changes for future write (~{} bytes, {} paths)", new Object[]{r, this.changes.getMemory(), this.changes.getNumChangedNodes()});
        }
    }

    private long getBinarySize(@Nullable String json) {
        if (json == null) {
            return -1L;
        }
        DocumentPropertyState p = new DocumentPropertyState(this, "p", json);
        if (p.getType().tag() != 2) {
            return -1L;
        }
        long size = 0L;
        if (p.isArray()) {
            for (int i = 0; i < p.count(); ++i) {
                size += p.size(i);
            }
        } else {
            size = p.size();
        }
        return size;
    }

    private JournalEntry newJournalEntry() {
        return new JournalEntry(this.store, true, this.newChangeSetBuilder(), this.journalPropertyHandlerFactory.newHandler());
    }

    private void initializeRootState(NodeDocument rootDoc) {
        Preconditions.checkState((this.root == null ? 1 : 0) != 0);
        try {
            Utils.alignWithExternalRevisions(rootDoc, this.clock, this.clusterId, this.maxTimeDiffMillis);
        }
        catch (InterruptedException e) {
            throw new DocumentStoreException("Interrupted while aligning with external revision: " + rootDoc.getLastRev());
        }
        RevisionVector headRevision = new RevisionVector(rootDoc.getLastRev().values()).update(this.newRevision());
        this.setRoot(headRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Commit newTrunkCommit(@NotNull Changes changes, @NotNull RevisionVector base) {
        Commit c;
        Preconditions.checkArgument((!((RevisionVector)Preconditions.checkNotNull((Object)base)).isBranch() ? 1 : 0) != 0, (Object)("base must not be a branch revision: " + base));
        CommitBuilder commitBuilder = this.newCommitBuilder(base, null);
        changes.with(commitBuilder);
        boolean success = false;
        this.backgroundOperationLock.readLock().lock();
        try {
            this.checkOpen();
            c = commitBuilder.build(this.commitQueue.createRevision());
            this.inDoubtTrunkCommits.add(c.getRevision());
            success = true;
        }
        finally {
            if (!success) {
                this.backgroundOperationLock.readLock().unlock();
            }
        }
        return c;
    }

    @NotNull
    private Commit newBranchCommit(@NotNull Changes changes, @NotNull RevisionVector base, @Nullable DocumentNodeStoreBranch branch) {
        Preconditions.checkArgument((boolean)((RevisionVector)Preconditions.checkNotNull((Object)base)).isBranch(), (Object)("base must be a branch revision: " + base));
        this.checkOpen();
        Revision commitRevision = this.newRevision();
        CommitBuilder commitBuilder = this.newCommitBuilder(base, commitRevision);
        changes.with(commitBuilder);
        if (this.isDisableBranches()) {
            this.backgroundOperationLock.readLock().lock();
        } else {
            Revision rev = commitRevision.asBranchRevision();
            Branch b = this.getBranches().getBranch(base);
            if (b == null) {
                this.getBranches().create(base.asTrunkRevision(), rev, branch);
                LOG.debug("Branch created with base revision {}", (Object)base);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Branch created", (Throwable)new Exception());
                }
            } else {
                b.addCommit(rev);
            }
        }
        return commitBuilder.build();
    }

    @NotNull
    private CommitBuilder newCommitBuilder(@NotNull RevisionVector base, @Nullable Revision commitRevision) {
        CommitBuilder cb = commitRevision != null ? new CommitBuilder(this, commitRevision, base) : new CommitBuilder(this, base);
        RevisionVector startRevs = Utils.getStartRevisions(this.clusterNodes.values());
        return cb.withStartRevisions(startRevs);
    }

    private void checkOpen() throws IllegalStateException {
        if (this.isDisposed.get()) {
            throw new IllegalStateException("This DocumentNodeStore is disposed");
        }
    }

    private boolean checkNodeNotExistsFromChildrenCache(Path path, RevisionVector rev) {
        Path parentPath = path.getParent();
        if (parentPath == null) {
            return false;
        }
        NamePathRev key = DocumentNodeStore.childNodeCacheKey(parentPath, rev, "");
        DocumentNodeState.Children children = (DocumentNodeState.Children)this.nodeChildrenCache.getIfPresent((Object)key);
        String lookupChildName = path.getName();
        if (children == null) {
            return false;
        }
        if (children.hasMore) {
            return false;
        }
        int childPosition = Collections.binarySearch(children.children, lookupChildName);
        if (childPosition < 0) {
            LOG.trace("Child node as per path {} does not exist at revision {}", (Object)path, (Object)rev);
            return true;
        }
        return false;
    }

    private String diffImpl(AbstractDocumentNodeState from, AbstractDocumentNodeState to) throws DocumentStoreException {
        long start;
        int max = DocumentNodeStoreBuilder.MANY_CHILDREN_THRESHOLD;
        boolean debug = LOG.isDebugEnabled();
        long getChildrenDoneIn = start = debug ? DocumentNodeStore.now() : 0L;
        String diff = null;
        String diffAlgo = null;
        RevisionVector fromRev = null;
        RevisionVector toRev = null;
        long minTimestamp = Utils.getMinTimestampForDiff(from.getRootRevision(), to.getRootRevision(), this.getMinExternalRevisions());
        long minJournalTimestamp = this.newRevision().getTimestamp() - this.journalGarbageCollector.getMaxRevisionAgeMillis() / 2L;
        Revision tailRev = this.journalGarbageCollector.getTailRevision();
        if (!this.disableJournalDiff && tailRev.getTimestamp() < minTimestamp && minJournalTimestamp < minTimestamp) {
            try {
                diff = new JournalDiffLoader(from, to, this).call();
                diffAlgo = "diffJournalChildren";
                fromRev = from.getRootRevision();
                toRev = to.getRootRevision();
            }
            catch (RuntimeException e) {
                LOG.warn("diffJournalChildren failed with " + e.getClass().getSimpleName() + ", falling back to classic diff", (Throwable)e);
            }
        }
        if (diff == null) {
            fromRev = from.getLastRevision();
            toRev = to.getLastRevision();
            JsopStream w = new JsopStream();
            boolean continueDiff = this.bundledDocDiffer.diff(from, to, (JsopWriter)w);
            if (continueDiff) {
                DocumentNodeState.Children fromChildren = this.getChildren(from, "", max);
                DocumentNodeState.Children toChildren = this.getChildren(to, "", max);
                long l = getChildrenDoneIn = debug ? DocumentNodeStore.now() : 0L;
                if (!fromChildren.hasMore && !toChildren.hasMore) {
                    diffAlgo = "diffFewChildren";
                    this.diffFewChildren((JsopWriter)w, from.getPath(), fromChildren, fromRev, toChildren, toRev);
                } else if (FAST_DIFF) {
                    diffAlgo = "diffManyChildren";
                    fromRev = from.getRootRevision();
                    toRev = to.getRootRevision();
                    this.diffManyChildren((JsopWriter)w, from.getPath(), fromRev, toRev);
                } else {
                    diffAlgo = "diffAllChildren";
                    max = Integer.MAX_VALUE;
                    fromChildren = this.getChildren(from, "", max);
                    toChildren = this.getChildren(to, "", max);
                    this.diffFewChildren((JsopWriter)w, from.getPath(), fromChildren, fromRev, toChildren, toRev);
                }
            } else {
                diffAlgo = "allBundledChildren";
            }
            diff = w.toString();
        }
        if (debug) {
            long end = DocumentNodeStore.now();
            LOG.debug("Diff performed via '{}' at [{}] between revisions [{}] => [{}] took {} ms ({} ms), diff '{}', external '{}", new Object[]{diffAlgo, from.getPath(), fromRev, toRev, end - start, getChildrenDoneIn - start, diff, to.isFromExternalChange()});
        }
        return diff;
    }

    private void diffManyChildren(JsopWriter w, Path path, RevisionVector fromRev, RevisionVector toRev) {
        long minTimestamp = Utils.getMinTimestampForDiff(fromRev, toRev, this.getMinExternalRevisions());
        for (RevisionVector r : new RevisionVector[]{fromRev, toRev}) {
            Branch b;
            if (!r.isBranch() || (b = this.branches.getBranch(r)) == null) continue;
            minTimestamp = Math.min(b.getBase().getRevision(this.clusterId).getTimestamp(), minTimestamp);
        }
        long minValue = NodeDocument.getModifiedInSecs(minTimestamp);
        String fromKey = Utils.getKeyLowerLimit(path);
        String toKey = Utils.getKeyUpperLimit(path);
        HashSet paths = Sets.newHashSet();
        LOG.debug("diffManyChildren: path: {}, fromRev: {}, toRev: {}", new Object[]{path, fromRev, toRev});
        for (NodeDocument doc : this.store.query(Collection.NODES, fromKey, toKey, "_modified", minValue, Integer.MAX_VALUE, Lists.newArrayList((Object[])new String[]{"_path"}))) {
            paths.add(doc.getPath());
        }
        LOG.debug("diffManyChildren: Affected paths: {}", (Object)paths.size());
        Revision minRev = new Revision(minTimestamp, 0, this.getClusterId());
        DocumentNodeStore.addPathsForDiff(path, paths, this.getPendingModifications().getPaths(minRev));
        for (RevisionVector rv : new RevisionVector[]{fromRev, toRev}) {
            if (!rv.isBranch()) continue;
            Revision r = rv.getBranchRevision();
            Branch b = this.branches.getBranch(rv);
            if (b == null) continue;
            DocumentNodeStore.addPathsForDiff(path, paths, b.getModifiedPathsUntil(r));
        }
        for (Path p : paths) {
            DocumentNodeState fromNode = this.getNode(p, fromRev);
            DocumentNodeState toNode = this.getNode(p, toRev);
            String name = p.getName();
            LOG.trace("diffManyChildren: Changed Path {}", (Object)path);
            if (fromNode != null) {
                if (toNode != null) {
                    RevisionVector a = fromNode.getLastRevision();
                    RevisionVector b = toNode.getLastRevision();
                    if (a == null && b == null || a != null && b != null && a.equals(b)) continue;
                    w.tag('^').key(name).object().endObject();
                    continue;
                }
                w.tag('-').value(name);
                continue;
            }
            if (toNode == null) continue;
            w.tag('+').key(name).object().endObject();
        }
    }

    private static void addPathsForDiff(Path path, Set<Path> paths, Iterable<Path> modified) {
        for (Path p : modified) {
            Path parent;
            if (p.isRoot() || !path.equals(parent = p.getParent())) continue;
            paths.add(p);
        }
    }

    private void diffFewChildren(JsopWriter w, Path parentPath, DocumentNodeState.Children fromChildren, RevisionVector fromRev, DocumentNodeState.Children toChildren, RevisionVector toRev) {
        HashSet childrenSet = Sets.newHashSet(toChildren.children);
        for (String n : fromChildren.children) {
            if (!childrenSet.contains(n)) {
                w.tag('-').value(n);
                continue;
            }
            Path path = new Path(parentPath, n);
            DocumentNodeState n1 = this.getNode(path, fromRev);
            DocumentNodeState n2 = this.getNode(path, toRev);
            Preconditions.checkNotNull((Object)((Object)n1), (String)"Node at [%s] not found for fromRev [%s]", (Object)path, (Object)fromRev);
            Preconditions.checkNotNull((Object)((Object)n2), (String)"Node at [%s] not found for toRev [%s]", (Object)path, (Object)toRev);
            if (n1.getLastRevision().equals(n2.getLastRevision())) continue;
            w.tag('^').key(n).object().endObject();
        }
        childrenSet = Sets.newHashSet(fromChildren.children);
        for (String n : toChildren.children) {
            if (childrenSet.contains(n)) continue;
            w.tag('+').key(n).object().endObject();
        }
    }

    private static NamePathRev childNodeCacheKey(@NotNull Path path, @NotNull RevisionVector readRevision, @NotNull String name) {
        return new NamePathRev(name, path, readRevision);
    }

    private static DocumentRootBuilder asDocumentRootBuilder(NodeBuilder builder) throws IllegalArgumentException {
        if (!(builder instanceof DocumentRootBuilder)) {
            throw new IllegalArgumentException("builder must be a " + DocumentRootBuilder.class.getName());
        }
        return (DocumentRootBuilder)builder;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private void checkBranchAge(Branch b) throws CommitFailedException {
        long journalMaxAge = this.journalGarbageCollector.getMaxRevisionAgeMillis();
        long branchMaxAge = journalMaxAge / 2L;
        long created = b.getCommits().first().getTimestamp();
        long branchAge = this.newRevision().getTimestamp() - created;
        if (branchAge > branchMaxAge) {
            String msg = "Long running commit detected. Branch was created " + Utils.timestampToString(created) + ". Consider breaking the commit down into smaller pieces or increasing the 'journalGCMaxAge' currently set to " + journalMaxAge + " ms (" + TimeUnit.MILLISECONDS.toMinutes(journalMaxAge) + " min).";
            throw new CommitFailedException("Oak", 200, msg);
        }
    }

    @Nullable
    public MarkSweepGarbageCollector createBlobGarbageCollector(long blobGcMaxAgeInSecs, String repositoryId, Whiteboard whiteboard, StatisticsProvider statisticsProvider) {
        MarkSweepGarbageCollector blobGC = null;
        if (this.blobStore instanceof GarbageCollectableBlobStore) {
            try {
                blobGC = new MarkSweepGarbageCollector((BlobReferenceRetriever)new DocumentBlobReferenceRetriever(this), (GarbageCollectableBlobStore)this.blobStore, this.executor, TimeUnit.SECONDS.toMillis(blobGcMaxAgeInSecs), repositoryId, whiteboard, statisticsProvider);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while initializing the MarkSweepGarbageCollector", e);
            }
        }
        return blobGC;
    }

    void setClusterStateChangeListener(ClusterStateChangeListener clusterStateChangeListener) {
        this.clusterStateChangeListener = clusterStateChangeListener;
    }

    private void signalClusterStateChange() {
        if (this.clusterStateChangeListener != null) {
            this.clusterStateChangeListener.handleClusterStateChange();
        }
    }

    public DocumentNodeStoreMBean getMBean() {
        return this.mbean;
    }

    private DocumentNodeStoreMBean createMBean(DocumentNodeStoreBuilder<?> builder) {
        return new DocumentNodeStoreMBeanImpl(this, builder.getStatisticsProvider().getStats(), this.clusterNodes.values(), builder.getRevisionGCMaxAge());
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    BlobSerializer getBlobSerializer() {
        return this.blobSerializer;
    }

    public Iterator<ReferencedBlob> getReferencedBlobsIterator() {
        return this.referencedBlobs.iterator();
    }

    public DiffCache getDiffCache() {
        return this.diffCache;
    }

    public Checkpoints getCheckpoints() {
        return this.checkpoints;
    }

    @NotNull
    public VersionGarbageCollector getVersionGarbageCollector() {
        return this.versionGarbageCollector;
    }

    @NotNull
    public JournalGarbageCollector getJournalGarbageCollector() {
        return this.journalGarbageCollector;
    }

    @NotNull
    public LastRevRecoveryAgent getLastRevRecoveryAgent() {
        return this.lastRevRecoveryAgent;
    }

    public String getInstanceId() {
        return String.valueOf(this.getClusterId());
    }

    public String getVisibilityToken() {
        DocumentNodeState theRoot = this.root;
        if (theRoot == null) {
            return "";
        }
        return theRoot.getRootRevision().asString();
    }

    private boolean isVisible(RevisionVector rv) {
        DocumentNodeState localRoot = this.root;
        if (localRoot == null) {
            return false;
        }
        return Utils.isGreaterOrEquals(localRoot.getRootRevision(), rv);
    }

    public boolean isVisible(@NotNull String visibilityToken, long maxWaitMillis) throws InterruptedException {
        if (Strings.isNullOrEmpty((String)visibilityToken)) {
            throw new IllegalArgumentException("visibilityToken must not be null or empty");
        }
        RevisionVector visibilityTokenRv = RevisionVector.fromString(visibilityToken);
        if (this.isVisible(visibilityTokenRv)) {
            return true;
        }
        this.commitQueue.suspendUntilAll(Sets.newHashSet((Iterable)visibilityTokenRv), maxWaitMillis);
        return this.isVisible(visibilityTokenRv);
    }

    public DocumentNodeStoreStatsCollector getStatsCollector() {
        return this.nodeStoreStatsCollector;
    }

    public DocumentNodeStateCache getNodeStateCache() {
        return this.nodeStateCache;
    }

    public void setNodeStateCache(DocumentNodeStateCache nodeStateCache) {
        this.nodeStateCache = nodeStateCache;
    }

    public JournalPropertyHandlerFactory getJournalPropertyHandlerFactory() {
        return this.journalPropertyHandlerFactory;
    }

    int getUpdateLimit() {
        return this.updateLimit;
    }

    boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    public void prefetch(java.util.Collection<String> paths, NodeState rootState) {
        if (paths != null && rootState instanceof DocumentNodeState && this.isPrefetchEnabled()) {
            this.cacheWarming.prefetch(paths, (DocumentNodeState)rootState);
        }
    }

    private boolean isPrefetchEnabled() {
        return this.prefetchEnabled || this.prefetchFeature != null && this.prefetchFeature.isEnabled();
    }

    private static class BackgroundClusterUpdate
    extends NodeStoreTask {
        BackgroundClusterUpdate(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed, (Supplier<Integer>)Suppliers.ofInstance((Object)1000));
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            if (nodeStore.updateClusterState()) {
                nodeStore.signalClusterStateChange();
            }
        }
    }

    private static class BackgroundLeaseUpdate
    extends NodeStoreTask {
        private long lastRenewClusterIdLeaseCall = -1L;
        private long elapsedForPreviousRenewal = -1L;
        private static int INTERVAL_MS = 1000;
        private static int TOLERANCE_FOR_WARNING_MS = 2000;

        BackgroundLeaseUpdate(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed, (Supplier<Integer>)Suppliers.ofInstance((Object)INTERVAL_MS));
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            long diff;
            Clock clock = nodeStore.getClock();
            long now = clock.getTime();
            if (this.lastRenewClusterIdLeaseCall >= 0L && (diff = now - this.lastRenewClusterIdLeaseCall) > (long)(INTERVAL_MS + TOLERANCE_FOR_WARNING_MS)) {
                String renewTimeMessage = this.elapsedForPreviousRenewal <= 0L ? "" : String.format(" (of which the last update operation took %dms)", this.elapsedForPreviousRenewal);
                LOG.warn("BackgroundLeaseUpdate.execute: time since last renewClusterIdLease() call longer than expected: {}ms{} (expected ~{}ms)", new Object[]{diff, renewTimeMessage, INTERVAL_MS});
            }
            this.lastRenewClusterIdLeaseCall = now;
            nodeStore.renewClusterIdLease();
            this.elapsedForPreviousRenewal = clock.getTime() - now;
        }
    }

    private static class BackgroundSweep2Operation
    extends NodeStoreTask {
        private final long sweep2Lock;
        private int retryCount = 0;

        BackgroundSweep2Operation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed, long sweep2Lock) {
            super(nodeStore, isDisposed, (Supplier<Integer>)Suppliers.ofInstance((Object)Math.min(60000, 60 * nodeStore.getAsyncDelay())));
            if (sweep2Lock < 0L) {
                throw new IllegalArgumentException("sweep2Lock must not be negative");
            }
            this.sweep2Lock = sweep2Lock;
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            if (this.retryCount > 0) {
                LOG.info("BackgroundSweep2Operation.execute: retrying sweep2. retryCount=" + this.retryCount);
            }
            if (nodeStore.backgroundSweep2(this.sweep2Lock)) {
                this.done();
            }
            if (++this.retryCount % 5 == 0) {
                LOG.info("BackgroundSweep2Operation.execute: another instance is currently (still) executing sweep2. Waiting for its outcome. retryCount=" + this.retryCount);
            }
        }

        private void done() {
            this.ref.clear();
        }
    }

    private static class BackgroundPurgeOperation
    extends NodeStoreTask {
        BackgroundPurgeOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed, (Supplier<Integer>)Suppliers.ofInstance((Object)60000));
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            Clock clock = nodeStore.getClock();
            long now = clock.getTime();
            boolean debug = LOG.isDebugEnabled();
            if (debug) {
                LOG.debug("BackgroundPurgeOperation.execute: started purging for non active clusterIds");
            }
            ClusterNodeInfoDocument.all(nodeStore.nonLeaseCheckingStore).stream().filter(cluster -> !cluster.isActive()).filter(cluster -> Objects.nonNull(cluster.getLastWrittenRootRev())).forEach(x$0 -> nodeStore.purgeUnmergedBranchCommitAndCollisionMarkers((ClusterNodeInfoDocument)x$0));
            if (debug) {
                LOG.debug("BackgroundPurgeOperation.execute: done purging for non active clusterIds, time taken {}ms", (Object)(clock.getTime() - now));
            }
        }
    }

    private static class BackgroundSweepOperation
    extends NodeStoreTask {
        BackgroundSweepOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed, BackgroundSweepOperation.getDelay(nodeStore));
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            nodeStore.backgroundSweep();
        }

        private static Supplier<Integer> getDelay(DocumentNodeStore ns) {
            int delay = 0;
            if (ns.getAsyncDelay() != 0) {
                delay = (int)TimeUnit.SECONDS.toMillis(5L);
            }
            return Suppliers.ofInstance((Object)delay);
        }
    }

    static class BackgroundReadOperation
    extends NodeStoreTask {
        BackgroundReadOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundReadOperations();
        }
    }

    static class BackgroundUpdateOperation
    extends NodeStoreTask {
        BackgroundUpdateOperation(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            super(nodeStore, isDisposed);
        }

        @Override
        protected void execute(@NotNull DocumentNodeStore nodeStore) {
            nodeStore.runBackgroundUpdateOperations();
        }
    }

    private static abstract class NodeStoreTask
    implements Runnable {
        final WeakReference<DocumentNodeStore> ref;
        private final AtomicBoolean isDisposed;
        private final Supplier<Integer> delaySupplier;
        private boolean failing;

        NodeStoreTask(DocumentNodeStore nodeStore, AtomicBoolean isDisposed, Supplier<Integer> delay) {
            this.ref = new WeakReference<DocumentNodeStore>(nodeStore);
            this.isDisposed = isDisposed;
            if (delay == null) {
                delay = new Supplier<Integer>(){

                    public Integer get() {
                        DocumentNodeStore ns = (DocumentNodeStore)ref.get();
                        return ns != null ? ns.getAsyncDelay() : 0;
                    }
                };
            }
            this.delaySupplier = delay;
        }

        NodeStoreTask(DocumentNodeStore nodeStore, AtomicBoolean isDisposed) {
            this(nodeStore, isDisposed, null);
        }

        protected abstract void execute(@NotNull DocumentNodeStore var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int delay = (Integer)this.delaySupplier.get();
            while (delay != 0 && !this.isDisposed.get()) {
                AtomicBoolean atomicBoolean = this.isDisposed;
                synchronized (atomicBoolean) {
                    try {
                        this.isDisposed.wait(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                DocumentNodeStore nodeStore = (DocumentNodeStore)this.ref.get();
                if (nodeStore == null) break;
                try {
                    this.execute(nodeStore);
                    if (this.failing) {
                        LOG.info("Background operation {} successful again", (Object)this.getClass().getSimpleName());
                        this.failing = false;
                    }
                }
                catch (Throwable t) {
                    this.failing = true;
                    LOG.warn("Background operation failed: " + t.toString(), t);
                }
                delay = (Integer)this.delaySupplier.get();
            }
        }
    }
}

