/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.plugins.document.BatchCommit;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BatchCommitQueue {
    private static final Logger LOG = LoggerFactory.getLogger(BatchCommitQueue.class);
    private final Map<String, BatchCommit> pending = Maps.newHashMap();
    private final Map<String, BatchCommit> inProgress = Maps.newHashMap();
    private final DocumentStore store;

    BatchCommitQueue(@NotNull DocumentStore store) {
        this.store = (DocumentStore)Preconditions.checkNotNull((Object)store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Callable<NodeDocument> updateDocument(UpdateOp op) {
        String id = op.getId();
        BatchCommitQueue batchCommitQueue = this;
        synchronized (batchCommitQueue) {
            BatchCommit commit = this.inProgress.get(id);
            if (commit != null) {
                LOG.debug("Commit with id {} in progress", (Object)id);
                commit = this.pending.get(id);
                if (commit == null) {
                    LOG.debug("Creating pending BatchCommit for id {}", (Object)id);
                    commit = new BatchCommit(id, this, true);
                    this.pending.put(id, commit);
                }
            } else {
                commit = new BatchCommit(id, this, false);
                LOG.debug("Adding inProgress BatchCommit for id {}", (Object)id);
                this.inProgress.put(id, commit);
            }
            LOG.debug("Enqueueing operation with id {}", (Object)id);
            return commit.enqueue(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finished(BatchCommit commit) {
        String id = commit.getId();
        BatchCommitQueue batchCommitQueue = this;
        synchronized (batchCommitQueue) {
            LOG.debug("BatchCommit finished with id {}", (Object)id);
            if (this.inProgress.remove(id) == null) {
                throw new IllegalStateException("BatchCommit for " + id + " is not in progress");
            }
            commit = this.pending.remove(id);
            if (commit != null) {
                LOG.debug("Moving pending BatchCommit to inProgress with id {}", (Object)id);
                this.inProgress.put(id, commit);
                commit.release();
                LOG.debug("BatchCommit released with id {}", (Object)id);
            }
        }
    }

    DocumentStore getStore() {
        return this.store;
    }
}

