/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.SystemPropertySupplier;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMissingLastRevSeeker
extends MissingLastRevSeeker {
    private static final Logger LOG = LoggerFactory.getLogger(RDBMissingLastRevSeeker.class);
    private static final int DEFAULTMODE = 2;
    private static final int MODE = SystemPropertySupplier.create(RDBMissingLastRevSeeker.class.getName() + ".MODE", 2).loggingTo(LOG).validateWith(value -> value == 1 || value == 2).formatSetMessage((name, value) -> String.format("Strategy for %s set to %s (via system property %s)", RDBMissingLastRevSeeker.class.getName(), name, value)).get();
    private final RDBDocumentStore store;

    public RDBMissingLastRevSeeker(RDBDocumentStore store, Clock clock) {
        super(store, clock);
        this.store = store;
    }

    @Override
    @NotNull
    public Iterable<NodeDocument> getCandidates(long startTime) {
        LOG.debug("Running getCandidates() in mode " + MODE);
        if (MODE == 1) {
            return super.getCandidates(startTime);
        }
        ArrayList<RDBDocumentStore.QueryCondition> conditions = new ArrayList<RDBDocumentStore.QueryCondition>();
        conditions.add(new RDBDocumentStore.QueryCondition("_modified", ">=", NodeDocument.getModifiedInSecs(startTime)));
        conditions.add(new RDBDocumentStore.QueryCondition("_sdType", "is null"));
        return this.store.queryAsIterable(Collection.NODES, null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, conditions, Integer.MAX_VALUE, null);
    }
}

