/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheActionDispatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheActionDispatcher.class);
    private static final long DEFAULT_MAX_MEMORY = 0x2000000L;
    static final int MAX_SIZE = 16384;
    final BlockingQueue<CacheAction> queue = new ArrayBlockingQueue<CacheAction>(16384);
    private final long maxMemory;
    private long memory = 0L;
    private final Object monitor = new Object();
    private volatile boolean isRunning = true;

    public CacheActionDispatcher() {
        this(0x2000000L);
    }

    CacheActionDispatcher(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning) {
            try {
                CacheAction action = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                if (action == null || !this.isRunning) continue;
                Object object = this.monitor;
                synchronized (object) {
                    this.memory -= (long)action.getMemory();
                }
                action.execute();
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted the queue.poll()", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(CacheAction action) {
        int m = action.getMemory();
        Object object = this.monitor;
        synchronized (object) {
            if (this.memory + (long)m <= this.maxMemory && this.queue.offer(action)) {
                this.memory += (long)m;
                return true;
            }
        }
        return false;
    }

    long getMemory() {
        return this.memory;
    }
}

