/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DocumentNodeStoreMBeanImpl
extends AnnotatedStandardMBean
implements DocumentNodeStoreMBean {
    private static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
    private static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
    private static final String COMPOSITE_INFO = "composite.checkpoint.";
    private final DocumentNodeStore nodeStore;
    private final RepositoryStatistics repoStats;
    private final Iterable<ClusterNodeInfoDocument> clusterNodes;
    private final long revisionGCMaxAgeMillis;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    DocumentNodeStoreMBeanImpl(DocumentNodeStore nodeStore, RepositoryStatistics repoStats, Iterable<ClusterNodeInfoDocument> clusterNodes, long revisionGCMaxAgeMillis) {
        super(DocumentNodeStoreMBean.class);
        this.nodeStore = nodeStore;
        this.repoStats = repoStats;
        this.clusterNodes = clusterNodes;
        this.revisionGCMaxAgeMillis = revisionGCMaxAgeMillis;
    }

    @Override
    public String getRevisionComparatorState() {
        return "";
    }

    @Override
    public String getHead() {
        return this.nodeStore.getHeadRevision().toString();
    }

    @Override
    public int getClusterId() {
        return this.nodeStore.getClusterId();
    }

    @Override
    public int getUnmergedBranchCount() {
        return this.nodeStore.getBranches().size();
    }

    @Override
    public String[] getInactiveClusterNodes() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)Iterables.filter(this.clusterNodes, (Predicate)new Predicate<ClusterNodeInfoDocument>(){

            public boolean apply(ClusterNodeInfoDocument input) {
                return !input.isActive();
            }
        }), (Function)new Function<ClusterNodeInfoDocument, String>(){

            public String apply(ClusterNodeInfoDocument input) {
                return input.getClusterId() + "=" + input.getCreated();
            }
        }), String.class);
    }

    @Override
    public String[] getActiveClusterNodes() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)Iterables.filter(this.clusterNodes, (Predicate)new Predicate<ClusterNodeInfoDocument>(){

            public boolean apply(ClusterNodeInfoDocument input) {
                return input.isActive();
            }
        }), (Function)new Function<ClusterNodeInfoDocument, String>(){

            public String apply(ClusterNodeInfoDocument input) {
                return input.getClusterId() + "=" + input.getLeaseEndTime();
            }
        }), String.class);
    }

    @Override
    public String[] getLastKnownRevisions() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.nodeStore.getHeadRevision(), (Predicate)new Predicate<Revision>(){

            public boolean apply(Revision input) {
                return input.getClusterId() != DocumentNodeStoreMBeanImpl.this.getClusterId();
            }
        }), (Function)new Function<Revision, String>(){

            public String apply(Revision input) {
                return input.getClusterId() + "=" + input.toString();
            }
        }), String.class);
    }

    @Override
    public String formatRevision(String rev, boolean utc) {
        Revision r = Revision.fromString(rev);
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_FORMAT);
        if (utc) {
            sdf.setTimeZone(TZ_UTC);
        }
        return sdf.format(r.getTimestamp());
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        return this.nodeStore.getDocumentStore().determineServerTimeDifferenceMillis();
    }

    @Override
    public CompositeData getMergeSuccessHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_MERGE_SUCCESS_COUNT", "Merge Success Count");
    }

    @Override
    public CompositeData getMergeFailureHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_MERGE_FAILED_EXCLUSIVE", "Merge failure count");
    }

    @Override
    public CompositeData getExternalChangeCountHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_BGR_NUM_CHANGES_RATE", "Count of nodes modified by other cluster nodes since last background read");
    }

    @Override
    public CompositeData getBackgroundUpdateCountHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_BGW_NUM_WRITE_RATE", "Count of nodes updated as part of background update");
    }

    @Override
    public CompositeData getBranchCommitHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_BRANCH_COMMIT_COUNT", "Branch commit count");
    }

    @Override
    public CompositeData getMergeBranchCommitHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_MERGE_BRANCH_COMMIT_COUNT", "Number of merged branch commits");
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(name), (String)desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.repoStats.getTimeSeries(name, true);
    }

    @Override
    public int recover(String path, int clusterId) {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null");
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)path), (Object)"path must be absolute");
        Preconditions.checkArgument((clusterId >= 0 ? 1 : 0) != 0, (Object)"clusterId must not be a negative");
        DocumentStore docStore = this.nodeStore.getDocumentStore();
        boolean isActive = false;
        for (ClusterNodeInfoDocument it : ClusterNodeInfoDocument.all(docStore)) {
            if (it.getClusterId() != clusterId || !it.isActive()) continue;
            isActive = true;
        }
        if (isActive) {
            throw new IllegalStateException("Cannot run recover on clusterId " + clusterId + " as it's currently active");
        }
        String p = path;
        NodeDocument nodeDocument = docStore.find(Collection.NODES, Utils.getIdFromPath(p));
        if (nodeDocument == null) {
            throw new DocumentStoreException("Document node with given path = " + p + " does not exist");
        }
        boolean dryRun = this.nodeStore.isReadOnlyMode();
        int sum = 0;
        while (true) {
            this.log.info("Running recovery on child documents of path = " + p);
            List<NodeDocument> childDocs = this.getChildDocs(p);
            sum += this.nodeStore.getLastRevRecoveryAgent().recover(childDocs, clusterId, dryRun);
            if (PathUtils.denotesRoot((String)p)) break;
            p = PathUtils.getParentPath((String)p);
        }
        return sum;
    }

    private List<NodeDocument> getChildDocs(String path) {
        Path pathRef = Path.fromString(path);
        String to = Utils.getKeyUpperLimit(pathRef);
        String from = Utils.getKeyLowerLimit(pathRef);
        return this.nodeStore.getDocumentStore().query(Collection.NODES, from, to, 10000);
    }

    @Override
    public String cleanAllCaches() {
        this.nodeStore.getDiffCache().invalidateAll();
        this.nodeStore.getNodeCache().invalidateAll();
        this.nodeStore.getNodeChildrenCache().invalidateAll();
        return "Caches invalidated.";
    }

    @Override
    public String cleanIndividualCache(String name) {
        switch (name.toUpperCase()) {
            case "DIFF": {
                this.nodeStore.getDiffCache().invalidateAll();
                return "DiffCache invalidated.";
            }
            case "NODE": {
                this.nodeStore.getNodeCache().invalidateAll();
                return "NodeCache invalidated.";
            }
            case "NODECHILDREN": {
                this.nodeStore.getNodeChildrenCache().invalidateAll();
                return "NodeChildrenCache invalidated.";
            }
        }
        return "ERROR: Invalid cache name received.";
    }

    @Override
    public String createCheckpoint(String revision, long lifetime, boolean force) {
        Revision rev = Revision.fromString(revision);
        long oldestTimestamp = this.nodeStore.getClock().getTime() - this.revisionGCMaxAgeMillis;
        Revision oldestCheckpoint = this.nodeStore.getCheckpoints().getOldestRevisionToKeep();
        if (oldestCheckpoint != null) {
            oldestTimestamp = Math.min(oldestTimestamp, oldestCheckpoint.getTimestamp());
        }
        if (force || oldestTimestamp < rev.getTimestamp()) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("composite.checkpoint.created", Long.toString(rev.getTimestamp()));
            info.put("composite.checkpoint.expires", Long.toString(Utils.sum(rev.getTimestamp() + lifetime)));
            String cp = this.nodeStore.getCheckpoints().create(lifetime, info, rev).toString();
            this.log.info("Created checkpoint [{}] with lifetime {} for Revision {}", new Object[]{cp, lifetime, revision});
            return String.format("Created checkpoint [%s] with lifetime %d for Revision %s", cp, lifetime, revision);
        }
        throw new IllegalArgumentException(String.format("Cannot create a checkpoint for revision %s. Revision timestamp is %d and oldest timestamp to keep is %d", revision, rev.getTimestamp(), oldestTimestamp));
    }
}

