/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.util.SystemPropertySupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBConnectionHandler
implements Closeable {
    private DataSource ds;
    private long closedTime = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(RDBConnectionHandler.class);
    private static final boolean CHECKCONNECTIONONCLOSE = SystemPropertySupplier.create("org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler.CHECKCONNECTIONONCLOSE", Boolean.FALSE).loggingTo(LOG).formatSetMessage((name, value) -> String.format("Check connection on close enabled (system property %s set to '%s')", name, value)).get();
    private Boolean setReadOnlyThrows = null;
    private Boolean setReadWriteThrows = null;
    private final int LOGTHRESHOLD = 20;
    private ConcurrentMap<WeakReference<Connection>, ConnectionHolder> connectionMap = new ConcurrentHashMap<WeakReference<Connection>, ConnectionHolder>();

    public RDBConnectionHandler(@NotNull DataSource ds) {
        this.ds = ds;
    }

    @NotNull
    public Connection getROConnection() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        this.setReadOnly(c, true);
        return c;
    }

    @NotNull
    public Connection getRWConnection() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        this.setReadOnly(c, false);
        return c;
    }

    public void rollbackConnection(@Nullable Connection c) {
        if (c != null) {
            try {
                c.rollback();
            }
            catch (SQLException ex) {
                LOG.error("error on rollback (ignored)", (Throwable)ex);
            }
        }
    }

    public void closeConnection(Connection c) {
        if (c != null) {
            try {
                if (CHECKCONNECTIONONCLOSE) {
                    try {
                        this.setReadOnly(c, !c.isReadOnly());
                        this.setReadOnly(c, !c.isReadOnly());
                    }
                    catch (SQLException ex2) {
                        LOG.error("got dirty connection", (Throwable)ex2);
                        throw new DocumentStoreException("dirty connection on close", ex2);
                    }
                }
                c.close();
            }
            catch (SQLException ex) {
                LOG.error("exception on connection close (ignored)", (Throwable)ex);
            }
        }
    }

    @Nullable
    public String getSchema(Connection c) {
        try {
            return (String)c.getClass().getMethod("getSchema", new Class[0]).invoke((Object)c, new Object[0]);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public boolean isClosed() {
        return this.ds == null;
    }

    @Override
    public void close() throws IOException {
        this.ds = null;
        this.closedTime = System.currentTimeMillis();
    }

    @NotNull
    private DataSource getDataSource() throws IllegalStateException {
        DataSource result = this.ds;
        if (result == null) {
            throw new IllegalStateException("Connection handler is already closed (" + (System.currentTimeMillis() - this.closedTime) + "ms ago)");
        }
        return result;
    }

    @NotNull
    private Connection getConnection() throws IllegalStateException, SQLException {
        long elapsed;
        long ts = System.currentTimeMillis();
        this.dumpConnectionMap(ts);
        Connection c = this.getDataSource().getConnection();
        this.remember(c);
        if (LOG.isDebugEnabled() && (elapsed = System.currentTimeMillis() - ts) >= 100L) {
            LOG.debug("Obtaining a new connection from " + this.ds + " took " + elapsed + "ms", (Throwable)new Exception("call stack"));
        }
        return c;
    }

    private void setReadOnly(Connection c, boolean ro) throws SQLException {
        if (ro) {
            if (this.setReadOnlyThrows == null) {
                try {
                    c.setReadOnly(true);
                    this.setReadOnlyThrows = Boolean.FALSE;
                }
                catch (SQLException ex) {
                    LOG.error("Connection class " + c.getClass() + " erroneously throws SQLException on setReadOnly(true); not trying again");
                    this.setReadOnlyThrows = Boolean.TRUE;
                }
            } else if (!this.setReadOnlyThrows.booleanValue()) {
                c.setReadOnly(true);
            }
        } else if (this.setReadWriteThrows == null) {
            try {
                c.setReadOnly(false);
                this.setReadWriteThrows = Boolean.FALSE;
            }
            catch (SQLException ex) {
                LOG.error("Connection class " + c.getClass() + " erroneously throws SQLException on setReadOnly(false); not trying again");
                this.setReadWriteThrows = Boolean.TRUE;
            }
        } else if (!this.setReadWriteThrows.booleanValue()) {
            c.setReadOnly(false);
        }
    }

    private void dumpConnectionMap(long ts) {
        if (LOG.isTraceEnabled()) {
            this.connectionMap.forEach((k, v) -> {
                try {
                    Connection con = (Connection)k.get();
                    if (con == null || con.isClosed()) {
                        this.connectionMap.remove(k);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            });
            int size = this.connectionMap.size();
            if (size > 0) {
                int cnt = 0;
                StringBuilder sb = new StringBuilder();
                for (ConnectionHolder ch : this.connectionMap.values()) {
                    if (ts - ch.getTimestamp() < 20L) continue;
                    if (cnt != 0) {
                        sb.append(", ");
                    }
                    ++cnt;
                    sb.append(ch.dump(ts));
                }
                if (cnt > 0) {
                    LOG.trace(cnt + " connections with age >= " + 20 + "ms active while obtaining new connection: " + sb.toString());
                }
            }
        }
    }

    private void remember(Connection c) {
        if (LOG.isTraceEnabled()) {
            this.connectionMap.put(new WeakReference<Connection>(c), new ConnectionHolder());
        }
    }

    private static String getCaller(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        String prevClass = null;
        for (StackTraceElement e : elements) {
            String cn = e.getClassName();
            if (cn.startsWith(RDBConnectionHandler.class.getName()) || cn.startsWith(Thread.class.getName())) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            if (e.getClassName().equals(prevClass)) {
                String loc = e.isNativeMethod() ? "Native Method" : (e.getFileName() == null ? "Unknown Source" : e.getFileName() + ":" + e.getLineNumber());
                sb.append('.').append(e.getMethodName()).append('(').append(loc).append(')');
            } else {
                sb.append(e.toString());
            }
            prevClass = e.getClassName();
        }
        return sb.toString();
    }

    private static class ConnectionHolder {
        public String thread;
        public String caller;
        public long ts;

        public ConnectionHolder() {
            Thread t = Thread.currentThread();
            this.thread = t.getName();
            this.caller = RDBConnectionHandler.getCaller(t.getStackTrace());
            this.ts = System.currentTimeMillis();
        }

        public long getTimestamp() {
            return this.ts;
        }

        public String dump(long now) {
            return "(thread=" + this.thread + ", caller=" + this.caller + ", age=" + (now - this.ts) + ")";
        }
    }
}

