/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingDocumentNodeState
extends AbstractDocumentNodeState {
    public static final String PROP_REVISION = ":doc-rev";
    public static final String PROP_LAST_REV = ":doc-lastRev";
    private static final Predicate<PropertyState> NOT_META_PROPS = new Predicate<PropertyState>(){

        public boolean apply(PropertyState input) {
            return !input.getName().startsWith(":doc-");
        }
    };
    private final NodeStateDiffer differ;
    private final NodeState delegate;
    private final RevisionVector rootRevision;
    private final boolean fromExternalChange;
    private final Path path;
    private RevisionVector lastRevision;

    public static NodeState wrapIfPossible(NodeState delegate, NodeStateDiffer differ) {
        if (DelegatingDocumentNodeState.hasMetaProps(delegate)) {
            String revVector = DelegatingDocumentNodeState.getRequiredProp(delegate, PROP_REVISION);
            return new DelegatingDocumentNodeState(delegate, Path.ROOT, RevisionVector.fromString(revVector), false, differ);
        }
        return delegate;
    }

    public static boolean hasMetaProps(NodeState delegate) {
        return delegate.hasProperty(PROP_REVISION);
    }

    public static AbstractDocumentNodeState wrap(NodeState delegate, NodeStateDiffer differ) {
        String revVector = DelegatingDocumentNodeState.getRequiredProp(delegate, PROP_REVISION);
        return new DelegatingDocumentNodeState(delegate, Path.ROOT, RevisionVector.fromString(revVector), false, differ);
    }

    private DelegatingDocumentNodeState(NodeState delegate, Path path, RevisionVector rootRevision, boolean fromExternalChange, NodeStateDiffer differ) {
        this.differ = differ;
        this.delegate = delegate;
        this.rootRevision = rootRevision;
        this.fromExternalChange = fromExternalChange;
        this.path = path;
    }

    private DelegatingDocumentNodeState(DelegatingDocumentNodeState original, RevisionVector rootRevision, boolean fromExternalChange) {
        this.differ = original.differ;
        this.delegate = original.delegate;
        this.rootRevision = rootRevision;
        this.fromExternalChange = fromExternalChange;
        this.path = original.path;
        this.lastRevision = original.lastRevision;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public RevisionVector getLastRevision() {
        if (this.lastRevision == null) {
            this.lastRevision = RevisionVector.fromString(this.getRequiredProp(PROP_LAST_REV));
        }
        return this.lastRevision;
    }

    @Override
    public RevisionVector getRootRevision() {
        return this.rootRevision;
    }

    @Override
    public boolean isFromExternalChange() {
        return this.fromExternalChange;
    }

    @Override
    public AbstractDocumentNodeState withRootRevision(@NotNull RevisionVector root, boolean externalChange) {
        if (this.rootRevision.equals(root) && this.fromExternalChange == externalChange) {
            return this;
        }
        return new DelegatingDocumentNodeState(this, root, externalChange);
    }

    @Override
    public boolean hasNoChildren() {
        return this.delegate.getChildNodeCount(1L) == 0L;
    }

    @Override
    protected NodeStateDiffer getNodeStateDiffer() {
        return this.differ;
    }

    public boolean exists() {
        return true;
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return Iterables.filter((Iterable)this.delegate.getProperties(), NOT_META_PROPS);
    }

    public boolean hasChildNode(@NotNull String name) {
        return this.delegate.hasChildNode(name);
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        return this.decorate(name, this.delegate.getChildNode(name));
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return Iterables.transform((Iterable)this.delegate.getChildNodeEntries(), (Function)new Function<ChildNodeEntry, ChildNodeEntry>(){

            @Nullable
            public ChildNodeEntry apply(ChildNodeEntry input) {
                return new MemoryChildNodeEntry(input.getName(), DelegatingDocumentNodeState.this.decorate(input.getName(), input.getNodeState()));
            }
        });
    }

    @NotNull
    public NodeBuilder builder() {
        Preconditions.checkState((!this.getPath().isRoot() ? 1 : 0) != 0, (String)"Builder cannot be opened for root path for state of type [%s]", (Object[])new Object[]{this.delegate.getClass()});
        return new MemoryNodeBuilder((NodeState)this);
    }

    public PropertyState getProperty(@NotNull String name) {
        return this.delegate.getProperty(name);
    }

    public long getPropertyCount() {
        return Iterables.size(this.getProperties());
    }

    public boolean hasProperty(@NotNull String name) {
        return this.delegate.hasProperty(name);
    }

    public boolean getBoolean(@NotNull String name) {
        return this.delegate.getBoolean(name);
    }

    public long getLong(String name) {
        return this.delegate.getLong(name);
    }

    public String getString(String name) {
        return this.delegate.getString(name);
    }

    @NotNull
    public Iterable<String> getStrings(@NotNull String name) {
        return this.delegate.getStrings(name);
    }

    public String getName(@NotNull String name) {
        return this.delegate.getName(name);
    }

    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        return this.delegate.getNames(name);
    }

    public long getChildNodeCount(long max) {
        return this.delegate.getChildNodeCount(max);
    }

    public Iterable<String> getChildNodeNames() {
        return this.delegate.getChildNodeNames();
    }

    private NodeState decorate(String nodeName, NodeState childNode) {
        if (childNode.exists()) {
            return new DelegatingDocumentNodeState(childNode, new Path(this.path, nodeName), this.rootRevision, this.fromExternalChange, this.differ);
        }
        return childNode;
    }

    private String getRequiredProp(String name) {
        return DelegatingDocumentNodeState.getRequiredProp(this.delegate, name);
    }

    private static String getRequiredProp(NodeState state, String name) {
        return (String)Preconditions.checkNotNull((Object)state.getString(name), (String)"No property [%s] found in [%s]", (Object[])new Object[]{name, state});
    }
}

