/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.impl;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Observer.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class NonDefaultMountWriteReportingObserver
implements Observer {
    @Reference
    private MountInfoProvider mountInfoProvider;
    private Config cfg;
    private ChangeReporter reporter = new ChangeReporter();
    private NodeState oldState = null;

    protected void activate(Config cfg) {
        this.cfg = cfg;
    }

    public final synchronized void contentChanged(NodeState root, CommitInfo info) {
        Preconditions.checkNotNull((Object)root);
        if (this.oldState != null) {
            CountingDiff diff = new CountingDiff("/", new LinkedHashMap());
            root.compareAgainstBaseState(this.oldState, (NodeStateDiff)diff);
            diff.report();
        }
        this.oldState = root;
    }

    void setReporter(ChangeReporter reporter) {
        this.reporter = reporter;
    }

    static class ChangeReporter {
        private static final int LOG_OUTPUT_MAX_ITEMS = 50;
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        ChangeReporter() {
        }

        void reportChanges(Map<String, String> changes, RuntimeException location) {
            if (!this.logger.isWarnEnabled()) {
                return;
            }
            StringBuilder out = new StringBuilder();
            out.append("Unexpected changes (").append(changes.size()).append(") performed on a non-default mount. Printing at most ").append(50);
            changes.entrySet().stream().limit(50L).forEach(e -> out.append("\n- ").append((String)e.getKey()).append(" : ").append((String)e.getValue()));
            this.logger.warn(out.toString(), (Throwable)location);
        }
    }

    class CountingDiff
    extends DefaultNodeStateDiff {
        private final String path;
        private final Map<String, String> changes;

        private CountingDiff(String path, Map<String, String> changes) {
            this.path = path;
            this.changes = changes;
        }

        public void report() {
            if (this.changes.isEmpty()) {
                return;
            }
            RuntimeException location = new RuntimeException();
            for (StackTraceElement element : location.getStackTrace()) {
                for (String acceptedClassName : NonDefaultMountWriteReportingObserver.this.cfg.ignoredClassNameFragments()) {
                    if (!element.getClassName().contains(acceptedClassName)) continue;
                    return;
                }
            }
            NonDefaultMountWriteReportingObserver.this.reporter.reportChanges(this.changes, location);
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            return this.onChange(name, before, EmptyNodeState.MISSING_NODE, "Deleted");
        }

        private boolean onChange(String name, NodeState before, NodeState after, String changeType) {
            String childPath = PathUtils.concat((String)this.path, (String)name);
            boolean isCovered = NonDefaultMountWriteReportingObserver.this.mountInfoProvider.getNonDefaultMounts().stream().anyMatch(m -> m.isMounted(childPath));
            if (isCovered) {
                this.changes.put(childPath, changeType);
            }
            return after.compareAgainstBaseState(before, (NodeStateDiff)new CountingDiff(childPath, this.changes));
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            return this.onChange(name, before, after, "Changed");
        }

        public boolean childNodeAdded(String name, NodeState after) {
            return this.onChange(name, EmptyNodeState.MISSING_NODE, after, "Added");
        }
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(description="Class name fragments that, when found in the stack trace, cause the writes to not be reported. Examples: org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl, org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl,org.apache.sling.jcr.repoinit")
        public String[] ignoredClassNameFragments();
    }
}

