/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.Date;
import java.util.Map;
import java.util.stream.StreamSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.jackrabbit.oak.commons.jmx.AbstractCheckpointMBean;
import org.apache.jackrabbit.oak.composite.CompositeNodeStore;

public class CompositeCheckpointMBean
extends AbstractCheckpointMBean {
    private final CompositeNodeStore store;

    public CompositeCheckpointMBean(CompositeNodeStore store) {
        this.store = store;
    }

    public String createCheckpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }

    public boolean releaseCheckpoint(String id) {
        return this.store.release(id);
    }

    protected void collectCheckpoints(TabularDataSupport tab) throws OpenDataException {
        for (String id : this.store.checkpoints()) {
            Map<String, String> info = this.store.allCheckpointInfo(id);
            tab.put(id, this.toCompositeData(id, CompositeCheckpointMBean.getDate(info, "composite.checkpoint.created"), CompositeCheckpointMBean.getDate(info, "composite.checkpoint.expires"), this.store.checkpointInfo(id)));
        }
    }

    public long getOldestCheckpointCreationTimestamp() {
        return StreamSupport.stream(this.store.checkpoints().spliterator(), false).map(this.store::allCheckpointInfo).map(i -> (String)i.get("composite.checkpoint.created")).mapToLong(l -> l == null ? 0L : Long.valueOf(l)).sorted().findFirst().orElse(0L);
    }

    private static String getDate(Map<String, String> info, String name) {
        String p = info.get(name);
        if (p == null) {
            return "NA";
        }
        try {
            return new Date(Long.valueOf(p)).toString();
        }
        catch (NumberFormatException e) {
            return "NA";
        }
    }
}

