/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.ErrorHolder;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexEntry;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={MountedNodeStoreChecker.class})
public class UniqueIndexNodeStoreChecker
implements MountedNodeStoreChecker<Context> {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueIndexNodeStoreChecker.class);

    @Override
    public Context createContext(NodeStore globalStore, MountInfoProvider mip) {
        Context ctx = new Context(mip);
        NodeState indexDefs = globalStore.getRoot().getChildNode("oak:index");
        for (ChildNodeEntry indexDef : indexDefs.getChildNodeEntries()) {
            if (!indexDef.getNodeState().hasProperty("unique") || !indexDef.getNodeState().getBoolean("unique")) continue;
            ctx.add(indexDef, mip.getDefaultMount(), indexDefs);
            ctx.track(new MountedNodeStore(mip.getDefaultMount(), globalStore));
        }
        return ctx;
    }

    @Override
    public boolean check(MountedNodeStore mountedStore, Tree tree, ErrorHolder errorHolder, Context context) {
        context.track(mountedStore);
        NodeState indexDefs = mountedStore.getNodeStore().getRoot().getChildNode("oak:index");
        for (ChildNodeEntry indexDef : indexDefs.getChildNodeEntries()) {
            if (!indexDef.getNodeState().hasProperty("unique") || !indexDef.getNodeState().getBoolean("unique")) continue;
            String mountIndexDefName = Multiplexers.getNodeForMount((Mount)mountedStore.getMount(), (String)":index");
            NodeState mountIndexDef = indexDef.getNodeState().getChildNode(mountIndexDefName);
            if (!mountIndexDef.exists()) continue;
            context.add(indexDef, mountedStore.getMount(), indexDefs);
        }
        context.runChecks(context, errorHolder);
        return false;
    }

    private static class StrategyWrapper
    implements Comparable<StrategyWrapper> {
        private static final int PRIORITY_DEFAULT = 0;
        private static final int PRIORITY_MOUNT = 100;
        private final UniqueEntryStoreStrategy strategy;
        private final int priority;
        private final NodeState indexNode;
        private final Mount mount;
        private final MountedNodeStore nodeStore;
        private final String indexName;

        private StrategyWrapper(UniqueEntryStoreStrategy strategy, NodeState indexNode, String indexName, MountedNodeStore nodeStore) {
            this.strategy = strategy;
            this.mount = nodeStore.getMount();
            this.indexNode = indexNode;
            this.nodeStore = nodeStore;
            this.indexName = indexName;
            this.priority = this.mount.isDefault() ? 100 : 0;
        }

        @Override
        public int compareTo(StrategyWrapper o) {
            int prioCmp = Integer.compare(this.priority, o.priority);
            if (prioCmp != 0) {
                return prioCmp;
            }
            return this.mount.getName().compareTo(o.mount.getName());
        }

        public Iterable<IndexEntry> queryAll() {
            return this.strategy.queryEntries(Filter.EMPTY_FILTER, this.indexName, this.indexNode, null);
        }

        public Optional<IndexEntry> queryOne(String value) {
            Iterable results = this.strategy.queryEntries(Filter.EMPTY_FILTER, this.indexName, this.indexNode, Collections.singleton(value));
            if (!results.iterator().hasNext()) {
                return Optional.empty();
            }
            return Optional.of(results.iterator().next());
        }
    }

    static class IndexCombination {
        private final ChildNodeEntry rootIndexDef;
        private final Map<Mount, NodeState> indexEntries = Maps.newHashMap();
        private final List<Mount[]> checked = new ArrayList<Mount[]>();
        private final Set<String> reportedConflictingValues = new HashSet<String>();

        IndexCombination(ChildNodeEntry rootIndexDef) {
            this.rootIndexDef = rootIndexDef;
        }

        public void addEntry(Mount mount, NodeState indexDef) {
            if (!this.indexEntries.containsKey(mount)) {
                this.indexEntries.put(mount, indexDef);
            }
        }

        public void runCheck(Context context, ErrorHolder errorHolder) {
            for (Map.Entry<Mount, NodeState> indexEntry : this.indexEntries.entrySet()) {
                for (Map.Entry<Mount, NodeState> indexEntry2 : this.indexEntries.entrySet()) {
                    if (indexEntry.getKey().equals(indexEntry2.getKey()) || this.wasChecked(indexEntry.getKey(), indexEntry2.getKey())) continue;
                    this.check(indexEntry, indexEntry2, context, errorHolder);
                    this.recordChecked(indexEntry.getKey(), indexEntry2.getKey());
                }
            }
        }

        private boolean wasChecked(Mount first, Mount second) {
            for (Mount[] checkedEntry : this.checked) {
                if ((!checkedEntry[0].equals(first) || !checkedEntry[1].equals(second)) && (!checkedEntry[1].equals(first) || !checkedEntry[0].equals(second))) continue;
                return true;
            }
            return false;
        }

        private void recordChecked(Mount first, Mount second) {
            this.checked.add(new Mount[]{first, second});
        }

        private void check(Map.Entry<Mount, NodeState> indexEntry, Map.Entry<Mount, NodeState> indexEntry2, Context ctx, ErrorHolder errorHolder) {
            String indexName = this.rootIndexDef.getName();
            TreeSet<StrategyWrapper> wrappers = new TreeSet<StrategyWrapper>();
            wrappers.add(this.getWrapper(indexEntry, indexName, ctx));
            wrappers.add(this.getWrapper(indexEntry2, indexName, ctx));
            StrategyWrapper wrapper = (StrategyWrapper)wrappers.first();
            StrategyWrapper wrapper2 = (StrategyWrapper)wrappers.last();
            LOG.info("Checking index definitions for {} between mounts {} and {}", new Object[]{indexName, wrapper.mount.getName(), wrapper2.mount.getName()});
            for (IndexEntry hit : wrapper.queryAll()) {
                Optional<IndexEntry> result = wrapper2.queryOne(hit.getPropertyValue());
                if (!result.isPresent()) continue;
                IndexEntry hit2 = result.get();
                if (!this.reportedConflictingValues.add(hit.getPropertyValue())) continue;
                errorHolder.report(wrapper.nodeStore, hit.getPath(), wrapper2.nodeStore, hit2.getPath(), hit.getPropertyValue(), "duplicate unique index entry");
            }
        }

        private StrategyWrapper getWrapper(Map.Entry<Mount, NodeState> indexEntry, String indexName, Context ctx) {
            NodeState indexNode = indexEntry.getValue();
            Mount mount = indexEntry.getKey();
            MountedNodeStore mountedNodeStore = (MountedNodeStore)ctx.mountedNodeStoresByName.get(mount.getName());
            UniqueEntryStoreStrategy strategy = mount.isDefault() ? new UniqueEntryStoreStrategy() : new UniqueEntryStoreStrategy(Multiplexers.getNodeForMount((Mount)mount, (String)":index"));
            return new StrategyWrapper(strategy, indexNode.getChildNode(indexName), indexName, mountedNodeStore);
        }
    }

    static class Context {
        private final MountInfoProvider mip;
        private final Map<String, IndexCombination> combinations = new HashMap<String, IndexCombination>();
        private final Map<String, MountedNodeStore> mountedNodeStoresByName = Maps.newHashMap();

        Context(MountInfoProvider mip) {
            this.mip = mip;
        }

        public void track(MountedNodeStore mountedNodeStore) {
            this.mountedNodeStoresByName.put(mountedNodeStore.getMount().getName(), mountedNodeStore);
        }

        public void add(ChildNodeEntry rootIndexDef, Mount mount, NodeState indexDef) {
            IndexCombination combination = this.combinations.get(rootIndexDef.getName());
            if (combination == null) {
                combination = new IndexCombination(rootIndexDef);
                this.combinations.put(rootIndexDef.getName(), combination);
            }
            combination.addEntry(mount, indexDef);
        }

        public MountInfoProvider getMountInfoProvider() {
            return this.mip;
        }

        public void runChecks(Context context, ErrorHolder errorHolder) {
            for (IndexCombination combination : this.combinations.values()) {
                combination.runCheck(context, errorHolder);
            }
        }
    }
}

