/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="Apache Jackrabbit Oak MountInfoProvider")
public class MountInfoProviderService {
    @Property(label="Mounted paths", unbounded=PropertyUnbounded.ARRAY, description="Paths which are part of private mount")
    private static final String PROP_MOUNT_PATHS = "mountedPaths";
    static final String PROP_MOUNT_NAME_DEFAULT = "private";
    @Property(label="Mount name", description="Name of the mount", value={"private"})
    private static final String PROP_MOUNT_NAME = "mountName";
    private static final boolean PROP_MOUNT_READONLY_DEFAULT = false;
    @Property(label="Readonly", description="If enabled then mount would be considered as readonly", boolValue={false})
    private static final String PROP_MOUNT_READONLY = "readOnlyMount";
    private static final String[] PROP_PATHS_SUPPORTING_FRAGMENTS_DEFAULT = new String[]{"/"};
    @Property(label="Paths supporting fragments", unbounded=PropertyUnbounded.ARRAY, description="oak:mount-* under this paths will be included to mounts", value={"/"})
    private static final String PROP_PATHS_SUPPORTING_FRAGMENTS = "pathsSupportingFragments";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration reg;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) {
        String[] paths = PropertiesUtil.toStringArray(config.get(PROP_MOUNT_PATHS));
        String mountName = PropertiesUtil.toString(config.get(PROP_MOUNT_NAME), (String)PROP_MOUNT_NAME_DEFAULT);
        boolean readOnly = PropertiesUtil.toBoolean(config.get(PROP_MOUNT_READONLY), (boolean)false);
        String[] pathsSupportingFragments = PropertiesUtil.toStringArray(config.get(PROP_PATHS_SUPPORTING_FRAGMENTS), (String[])PROP_PATHS_SUPPORTING_FRAGMENTS_DEFAULT);
        MountInfoProvider mip = Mounts.defaultMountInfoProvider();
        if (paths != null) {
            mip = Mounts.newBuilder().mount(mountName.trim(), readOnly, MountInfoProviderService.trim(pathsSupportingFragments), MountInfoProviderService.trim(paths)).build();
            this.log.info("Enabling mount for {}", (Object)mip);
        } else {
            this.log.info("No mount config provided. Mounting would be disabled");
        }
        this.reg = bundleContext.registerService(MountInfoProvider.class.getName(), (Object)mip, null);
    }

    private static List<String> trim(String[] array) {
        ArrayList<String> result = new ArrayList<String>(array.length);
        for (String s : array) {
            result.add(s.trim());
        }
        return result;
    }

    @Deactivate
    private void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }
}

