/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class ModifiedPathDiff
implements NodeStateDiff {
    private final Set<String> paths;
    private final String currentPath;

    public static Set<String> getModifiedPaths(NodeState before, NodeState after) {
        ModifiedPathDiff diff = new ModifiedPathDiff();
        after.compareAgainstBaseState(before, (NodeStateDiff)diff);
        return diff.getPaths();
    }

    private ModifiedPathDiff() {
        this.paths = new HashSet<String>();
        this.currentPath = "/";
    }

    private ModifiedPathDiff(ModifiedPathDiff parent, String name) {
        this.paths = parent.paths;
        this.currentPath = PathUtils.concat((String)parent.currentPath, (String)name);
    }

    public boolean propertyAdded(PropertyState after) {
        this.paths.add(this.currentPath);
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.paths.add(this.currentPath);
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.paths.add(this.currentPath);
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        this.paths.add(PathUtils.concat((String)this.currentPath, (String)name));
        return true;
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        return after.compareAgainstBaseState(before, (NodeStateDiff)new ModifiedPathDiff(this, name));
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        this.paths.add(PathUtils.concat((String)this.currentPath, (String)name));
        return true;
    }

    private Set<String> getPaths() {
        return this.paths;
    }
}

