/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.composite.CompositeNodeState;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class CommitHookEnhancer
implements CommitHook {
    private final CompositionContext ctx;
    private final CommitHook hook;

    CommitHookEnhancer(CommitHook hook, CompositionContext ctx) {
        this.ctx = ctx;
        this.hook = hook;
    }

    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        HashMap beforeStates = Maps.newHashMap();
        HashMap afterStates = Maps.newHashMap();
        for (MountedNodeStore mns : this.ctx.getNonDefaultStores()) {
            NodeState root = mns.getNodeStore().getRoot();
            afterStates.put(mns, root);
            beforeStates.put(mns, root);
        }
        afterStates.put(this.ctx.getGlobalStore(), after);
        beforeStates.put(this.ctx.getGlobalStore(), before);
        CompositeNodeState compositeBefore = this.ctx.createRootNodeState(beforeStates);
        CompositeNodeState compositeAfter = this.ctx.createRootNodeState(afterStates);
        NodeState result = this.hook.processCommit((NodeState)compositeBefore, (NodeState)compositeAfter, info);
        if (result instanceof CompositeNodeState) {
            return ((CompositeNodeState)result).getNodeState(this.ctx.getGlobalStore());
        }
        throw new IllegalStateException("The commit hook result should be a composite node state");
    }
}

