/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.composite.CrossMountReferenceValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.osgi.framework.BundleContext;

@Component(label="Apache Jackrabbit Oak CrossMountReferenceValidatorProvider", policy=ConfigurationPolicy.REQUIRE)
@Property(name="type", value={"crossMountRefValidator"}, propertyPrivate=true)
@Service(value={ValidatorProvider.class, EditorProvider.class})
public class CrossMountReferenceValidatorProvider
extends ValidatorProvider {
    @Property(boolValue={true}, label="Fail when detecting commits cross-mount references", description="Commits will fail if set to true when detecting cross-mount references. If set to false the commit information is only logged.")
    private static final String PROP_FAIL_ON_DETECTION = "failOnDetection";
    private boolean failOnDetection;
    @Reference
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();

    public CrossMountReferenceValidatorProvider() {
    }

    public CrossMountReferenceValidatorProvider(MountInfoProvider mountInfoProvider, boolean failOnDetection) {
        this.failOnDetection = failOnDetection;
        this.mountInfoProvider = mountInfoProvider;
    }

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) {
        this.failOnDetection = PropertiesUtil.toBoolean(config.get(PROP_FAIL_ON_DETECTION), (boolean)false);
    }

    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        return new CrossMountReferenceValidator(after, this.mountInfoProvider, this.failOnDetection);
    }

    CrossMountReferenceValidatorProvider with(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
        return this;
    }

    CrossMountReferenceValidatorProvider withFailOnDetection(boolean failOnDetection) {
        this.failOnDetection = failOnDetection;
        return this;
    }

    protected void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        if (this.mountInfoProvider == mountInfoProvider) {
            this.mountInfoProvider = null;
        }
    }
}

