/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CommitHookEnhancer;
import org.apache.jackrabbit.oak.composite.CompositeNodeBuilder;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreMonitor;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.ModifiedPathDiff;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecks;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeNodeStore
implements NodeStore,
Observable {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeNodeStore.class);
    static final String CHECKPOINT_METADATA = "composite.checkpoint.";
    private static final String CHECKPOINT_METADATA_MOUNT = "composite.checkpoint.mount.";
    final CompositionContext ctx;
    private final ChangeDispatcher dispatcher;

    CompositeNodeStore(MountInfoProvider mip, NodeStore globalStore, List<MountedNodeStore> nonDefaultStore) {
        this(mip, globalStore, nonDefaultStore, CompositeNodeStoreMonitor.EMPTY_INSTANCE, CompositeNodeStoreMonitor.EMPTY_INSTANCE);
    }

    CompositeNodeStore(MountInfoProvider mip, NodeStore globalStore, List<MountedNodeStore> nonDefaultStore, CompositeNodeStoreMonitor nodeStateMonitor, CompositeNodeStoreMonitor nodeBuilderMonitor) {
        CompositeNodeStore.assertPartialMountsAreReadOnly(nonDefaultStore);
        this.ctx = new CompositionContext(mip, globalStore, nonDefaultStore, nodeStateMonitor, nodeBuilderMonitor);
        this.dispatcher = new ChangeDispatcher(this.getRoot());
        if (globalStore instanceof Observable) {
            Observable globalStoreObservable = (Observable)globalStore;
            globalStoreObservable.addObserver((root, info) -> this.dispatcher.contentChanged((NodeState)this.ctx.createRootNodeState(root), info));
        }
    }

    private static void assertPartialMountsAreReadOnly(List<MountedNodeStore> nonDefaultStores) {
        List readWriteMountNames = nonDefaultStores.stream().map(MountedNodeStore::getMount).filter(m -> !m.isReadOnly()).map(Mount::getName).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)readWriteMountNames.isEmpty(), (String)"Following partial mounts are write-enabled: ", (Object[])new Object[]{readWriteMountNames});
    }

    public NodeState getRoot() {
        return this.ctx.createRootNodeState(this.ctx.getGlobalStore().getNodeStore().getRoot());
    }

    public NodeState merge(NodeBuilder builder, CommitHook commitHook, CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof CompositeNodeBuilder));
        CompositeNodeBuilder nodeBuilder = (CompositeNodeBuilder)builder;
        if (!PathUtils.denotesRoot((String)nodeBuilder.getPath())) {
            throw new IllegalArgumentException();
        }
        this.assertNoChangesOnReadOnlyMounts(nodeBuilder);
        MountedNodeStore globalStore = this.ctx.getGlobalStore();
        CommitHookEnhancer hookEnhancer = new CommitHookEnhancer(commitHook, this.ctx);
        NodeState globalResult = globalStore.getNodeStore().merge(nodeBuilder.getNodeBuilder(globalStore), (CommitHook)hookEnhancer, info);
        return this.ctx.createRootNodeState(globalResult);
    }

    private void assertNoChangesOnReadOnlyMounts(CompositeNodeBuilder nodeBuilder) throws CommitFailedException {
        for (MountedNodeStore mountedNodeStore : this.ctx.getNonDefaultStores()) {
            NodeBuilder partialBuilder = nodeBuilder.getNodeBuilder(mountedNodeStore);
            this.assertNoChange(mountedNodeStore, partialBuilder);
        }
    }

    private void assertNoChange(MountedNodeStore mountedNodeStore, NodeBuilder partialBuilder) throws CommitFailedException {
        Set<String> changedPaths;
        NodeState baseState = partialBuilder.getBaseState();
        NodeState nodeState = partialBuilder.getNodeState();
        if (!nodeState.equals(baseState) && !(changedPaths = ModifiedPathDiff.getModifiedPaths(baseState, nodeState)).isEmpty()) {
            throw new CommitFailedException("CompositeStore", 31, "Unable to perform changes on read-only mount " + mountedNodeStore.getMount().getName() + ". Failing paths: " + changedPaths.toString());
        }
    }

    public NodeState rebase(NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof CompositeNodeBuilder));
        CompositeNodeBuilder nodeBuilder = (CompositeNodeBuilder)builder;
        MountedNodeStore globalStore = this.ctx.getGlobalStore();
        NodeState globalResult = globalStore.getNodeStore().rebase(nodeBuilder.getNodeBuilder(globalStore));
        return this.ctx.createRootNodeState(globalResult);
    }

    public NodeState reset(NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof CompositeNodeBuilder));
        CompositeNodeBuilder nodeBuilder = (CompositeNodeBuilder)builder;
        MountedNodeStore globalStore = this.ctx.getGlobalStore();
        NodeState globalResult = globalStore.getNodeStore().reset(nodeBuilder.getNodeBuilder(globalStore));
        return this.ctx.createRootNodeState(globalResult);
    }

    public Blob createBlob(InputStream inputStream) throws IOException {
        return this.ctx.createBlob(inputStream);
    }

    public Blob getBlob(String reference) {
        for (MountedNodeStore nodeStore : this.ctx.getAllMountedNodeStores()) {
            Blob found = nodeStore.getNodeStore().getBlob(reference);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Iterable<String> checkpoints() {
        NodeStore globalNodeStore = this.ctx.getGlobalStore().getNodeStore();
        return Iterables.filter((Iterable)globalNodeStore.checkpoints(), (Predicate)new Predicate<String>(){

            public boolean apply(String checkpoint) {
                return CompositeNodeStore.this.isCompositeCheckpoint(checkpoint);
            }
        });
    }

    private boolean isCompositeCheckpoint(String checkpoint) {
        Map props = this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
        if (props == null) {
            return false;
        }
        return props.containsKey("composite.checkpoint.created");
    }

    public String checkpoint(long lifetime, Map<String, String> properties) {
        HashMap globalProperties = Maps.newHashMap(properties);
        globalProperties.put("composite.checkpoint.created", Long.toString(System.currentTimeMillis()));
        globalProperties.put("composite.checkpoint.expires", Long.toString(System.currentTimeMillis() + lifetime));
        String newCheckpoint = this.ctx.getGlobalStore().getNodeStore().checkpoint(lifetime, (Map)globalProperties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created checkpoint {}. Debug info:\n{}", (Object)newCheckpoint, (Object)this.checkpointDebugInfo());
        }
        return newCheckpoint;
    }

    public String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    public Map<String, String> checkpointInfo(String checkpoint) {
        if (!CompositeNodeStore.checkpointExists(this.ctx.getGlobalStore().getNodeStore(), checkpoint)) {
            LOG.warn("Checkpoint {} doesn't exist. Debug info:\n{}", new Object[]{checkpoint, this.checkpointDebugInfo(), new Exception()});
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf((Map)Maps.filterKeys((Map)this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.startsWith(CompositeNodeStore.CHECKPOINT_METADATA);
            }
        }));
    }

    Map<String, String> allCheckpointInfo(String checkpoint) {
        return this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
    }

    public NodeState retrieve(String checkpoint) {
        if (!CompositeNodeStore.checkpointExists(this.ctx.getGlobalStore().getNodeStore(), checkpoint)) {
            LOG.warn("Checkpoint {} doesn't exist on the global store. Debug info:\n{}", (Object)checkpoint, (Object)this.checkpointDebugInfo());
            return null;
        }
        Map props = this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
        HashMap nodeStates = Maps.newHashMap();
        nodeStates.put(this.ctx.getGlobalStore(), this.ctx.getGlobalStore().getNodeStore().retrieve(checkpoint));
        for (MountedNodeStore nodeStore : this.ctx.getNonDefaultStores()) {
            String partialCheckpoint = this.getPartialCheckpointName(nodeStore, checkpoint, props, true);
            NodeState nodeState = partialCheckpoint == null ? nodeStore.getNodeStore().getRoot() : nodeStore.getNodeStore().retrieve(partialCheckpoint);
            nodeStates.put(nodeStore, nodeState);
        }
        if (Iterables.any(nodeStates.values(), (Predicate)Predicates.isNull())) {
            LOG.warn("Checkpoint {} doesn't exist. Debug info:\n{}", new Object[]{checkpoint, this.checkpointDebugInfo(), new Exception()});
            return null;
        }
        return this.ctx.createRootNodeState(nodeStates);
    }

    public boolean release(String checkpoint) {
        boolean result;
        if (CompositeNodeStore.checkpointExists(this.ctx.getGlobalStore().getNodeStore(), checkpoint)) {
            Map props = this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
            result = this.ctx.getGlobalStore().getNodeStore().release(checkpoint);
        } else {
            Map props = Collections.emptyMap();
            result = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released checkpoint {}. Result: {}. Debug info:\n{}", new Object[]{checkpoint, result, this.checkpointDebugInfo()});
        }
        return result;
    }

    private String getPartialCheckpointName(MountedNodeStore nodeStore, String globalCheckpoint, Map<String, String> globalCheckpointProperties, boolean resolveByName) {
        ImmutableSet validCheckpointNames = ImmutableSet.copyOf((Iterable)nodeStore.getNodeStore().checkpoints());
        String result = globalCheckpointProperties.get(CHECKPOINT_METADATA_MOUNT + nodeStore.getMount().getName());
        if (result != null && validCheckpointNames.contains(result)) {
            return result;
        }
        if (globalCheckpoint != null && validCheckpointNames.contains(globalCheckpoint)) {
            return globalCheckpoint;
        }
        if (resolveByName) {
            String nameProp = globalCheckpointProperties.get("name");
            if (nameProp == null) {
                return null;
            }
            for (String c : validCheckpointNames) {
                Map partialCheckpointProperties = nodeStore.getNodeStore().checkpointInfo(c);
                if (!nameProp.equals(partialCheckpointProperties.get("name"))) continue;
                return c;
            }
        }
        return null;
    }

    private static boolean checkpointExists(NodeStore nodeStore, String checkpoint) {
        return Iterables.any((Iterable)nodeStore.checkpoints(), (Predicate)Predicates.equalTo((Object)checkpoint));
    }

    private String checkpointDebugInfo() {
        StringBuilder builder = new StringBuilder();
        for (MountedNodeStore mns : this.ctx.getAllMountedNodeStores()) {
            Mount mount = mns.getMount();
            NodeStore nodeStore = mns.getNodeStore();
            builder.append("Mount: ").append(mount.isDefault() ? "[default]" : mount.getName()).append('\n');
            builder.append("Checkpoints:").append('\n');
            for (String checkpoint : nodeStore.checkpoints()) {
                builder.append(" - ").append(checkpoint).append(": ").append(nodeStore.checkpointInfo(checkpoint)).append('\n');
            }
            builder.append("/:async node: ");
            NodeState asyncNode = nodeStore.getRoot().getChildNode(":async");
            if (asyncNode.exists()) {
                builder.append("{");
                Iterator i = asyncNode.getProperties().iterator();
                while (i.hasNext()) {
                    PropertyState p = (PropertyState)i.next();
                    if (p.isArray()) {
                        builder.append(p.getName()).append(": [...]");
                    } else {
                        builder.append(p.toString());
                    }
                    if (!i.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append("}");
            } else {
                builder.append("N/A");
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    public Closeable addObserver(Observer observer) {
        return this.dispatcher.addObserver(observer);
    }

    private static class ClusterableCNS
    extends CompositeNodeStore
    implements Clusterable {
        private final Clusterable clusterable;

        ClusterableCNS(MountInfoProvider mip, NodeStore globalStore, List<MountedNodeStore> nonDefaultStore, CompositeNodeStoreMonitor nodeStateMonitor, CompositeNodeStoreMonitor nodeBuilderMonitor) {
            super(mip, globalStore, nonDefaultStore, nodeStateMonitor, nodeBuilderMonitor);
            Preconditions.checkArgument((boolean)(globalStore instanceof Clusterable), (Object)"globalStore must implement Clusterable");
            this.clusterable = (Clusterable)globalStore;
        }

        @NotNull
        public String getInstanceId() {
            return this.clusterable.getInstanceId();
        }

        @Nullable
        public String getVisibilityToken() {
            return this.clusterable.getVisibilityToken();
        }

        public boolean isVisible(@NotNull String visibilityToken, long maxWaitMillis) throws InterruptedException {
            return this.clusterable.isVisible(visibilityToken, maxWaitMillis);
        }
    }

    public static class Builder {
        private final MountInfoProvider mip;
        private final NodeStore globalStore;
        private final List<MountedNodeStore> nonDefaultStores = Lists.newArrayList();
        private CompositeNodeStoreMonitor nodeStateMonitor = CompositeNodeStoreMonitor.EMPTY_INSTANCE;
        private CompositeNodeStoreMonitor nodeBuilderMonitor = CompositeNodeStoreMonitor.EMPTY_INSTANCE;
        private NodeStoreChecks checks;

        public Builder(MountInfoProvider mip, NodeStore globalStore) {
            this.mip = (MountInfoProvider)Preconditions.checkNotNull((Object)mip, (Object)"mountInfoProvider");
            this.globalStore = (NodeStore)Preconditions.checkNotNull((Object)globalStore, (Object)"globalStore");
        }

        public Builder with(NodeStoreChecks checks) {
            this.checks = checks;
            return this;
        }

        public Builder with(CompositeNodeStoreMonitor nodeStateMonitor, CompositeNodeStoreMonitor nodeBuilderMonitor) {
            this.nodeStateMonitor = nodeStateMonitor;
            this.nodeBuilderMonitor = nodeBuilderMonitor;
            return this;
        }

        public Builder addMount(String mountName, NodeStore store) {
            Preconditions.checkNotNull((Object)store, (Object)"store");
            Preconditions.checkNotNull((Object)mountName, (Object)"mountName");
            Mount mount = (Mount)Preconditions.checkNotNull((Object)this.mip.getMountByName(mountName), (String)"No mount with name %s found in %s", (Object[])new Object[]{mountName, this.mip});
            this.nonDefaultStores.add(new MountedNodeStore(mount, store));
            return this;
        }

        public Builder addIgnoredReadOnlyWritePath(String path) {
            throw new UnsupportedOperationException();
        }

        public Builder setPartialReadOnly(boolean partialReadOnly) {
            return this;
        }

        public void assertPartialMountsAreReadOnly() {
            List readWriteMountNames = this.nonDefaultStores.stream().map(MountedNodeStore::getMount).filter(m -> !m.isReadOnly()).map(Mount::getName).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)readWriteMountNames.isEmpty(), (String)"Following partial mounts are write-enabled: ", (Object[])new Object[]{readWriteMountNames});
        }

        public CompositeNodeStore build() {
            this.checkMountsAreConsistentWithMounts();
            if (this.checks != null) {
                this.nonDefaultStores.forEach(s -> this.checks.check(this.globalStore, (MountedNodeStore)s));
            }
            if (this.globalStore instanceof Clusterable) {
                return new ClusterableCNS(this.mip, this.globalStore, this.nonDefaultStores, this.nodeStateMonitor, this.nodeBuilderMonitor);
            }
            return new CompositeNodeStore(this.mip, this.globalStore, this.nonDefaultStores, this.nodeStateMonitor, this.nodeBuilderMonitor);
        }

        private void checkMountsAreConsistentWithMounts() {
            int mipMountCount;
            int buildMountCount = this.nonDefaultStores.size();
            Preconditions.checkArgument((buildMountCount == (mipMountCount = this.mip.getNonDefaultMounts().size()) ? 1 : 0) != 0, (String)"Inconsistent mount configuration. Builder received %s mounts, but MountInfoProvider knows about %s.", (Object[])new Object[]{buildMountCount, mipMountCount});
        }
    }
}

