/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.solr.schema.IndexSchema;

final class DeleteByQueryWrapper
extends Query {
    final Query in;
    final IndexSchema schema;

    DeleteByQueryWrapper(Query in, IndexSchema schema) {
        this.in = in;
        this.schema = schema;
    }

    LeafReader wrap(LeafReader reader) {
        return new UninvertingReader(reader, this.schema.getUninversionMap(reader));
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query rewritten = this.in.rewrite(reader);
        if (rewritten != this.in) {
            return new DeleteByQueryWrapper(rewritten, this.schema);
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        LeafReader wrapped = this.wrap((LeafReader)searcher.getIndexReader());
        final IndexSearcher privateContext = new IndexSearcher(wrapped);
        final Weight inner = this.in.createWeight(privateContext, needsScores);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return inner.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float topLevelBoost) {
                inner.normalize(norm, topLevelBoost);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return inner.scorer(privateContext.getIndexReader().leaves().get(0));
            }
        };
    }

    @Override
    public String toString(String field) {
        return "Uninverting(" + this.in.toString(field) + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.in == null ? 0 : this.in.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteByQueryWrapper other = (DeleteByQueryWrapper)obj;
        if (this.in == null ? other.in != null : !this.in.equals(other.in)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

