/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.util.SolrPluginUtils;

public class CloudMLTQParser
extends QParser {
    private static final Pattern splitList = Pattern.compile(",| ");

    public CloudMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String id = this.localParams.get("v");
        SolrDocument doc = this.getDocument(id);
        if (doc == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + id + "]");
        }
        String[] qf = this.localParams.getParams("qf");
        Map<Object, Object> boostFields = new HashMap();
        MoreLikeThis mlt = new MoreLikeThis(this.req.getSearcher().getIndexReader());
        if (this.localParams.getInt("mintf") != null) {
            mlt.setMinTermFreq(this.localParams.getInt("mintf"));
        }
        mlt.setMinDocFreq(this.localParams.getInt("mindf", 0));
        if (this.localParams.get("minwl") != null) {
            mlt.setMinWordLen(this.localParams.getInt("minwl"));
        }
        if (this.localParams.get("maxwl") != null) {
            mlt.setMaxWordLen(this.localParams.getInt("maxwl"));
        }
        if (this.localParams.get("maxqt") != null) {
            mlt.setMaxQueryTerms(this.localParams.getInt("maxqt"));
        }
        if (this.localParams.get("maxntp") != null) {
            mlt.setMaxNumTokensParsed(this.localParams.getInt("maxntp"));
        }
        if (this.localParams.get("maxdf") != null) {
            mlt.setMaxDocFreq(this.localParams.getInt("maxdf"));
        }
        if (this.localParams.get("boost") != null) {
            mlt.setBoost(this.localParams.getBool("boost"));
            boostFields = SolrPluginUtils.parseFieldBoosts(qf);
        }
        mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
        HashMap<String, Collection<Object>> filteredDocument = new HashMap<String, Collection<Object>>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (qf != null) {
            for (String fieldName : qf) {
                String[] strings;
                if (StringUtils.isEmpty(fieldName)) continue;
                for (String string : strings = splitList.split(fieldName)) {
                    if (StringUtils.isEmpty(string)) continue;
                    fieldNames.add(string);
                }
            }
        } else {
            Map<String, SchemaField> fields = this.req.getSchema().getFields();
            for (String field : doc.getFieldNames()) {
                if (!fields.get(field).stored() || !fields.get(field).getType().isExplicitAnalyzer()) continue;
                fieldNames.add(field);
            }
        }
        if (fieldNames.size() < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: qf");
        }
        mlt.setFieldNames(fieldNames.toArray(new String[fieldNames.size()]));
        for (String field : fieldNames) {
            filteredDocument.put(field, doc.getFieldValues(field));
        }
        try {
            Query rawMLTQuery = mlt.like(filteredDocument);
            BooleanQuery boostedMLTQuery = (BooleanQuery)rawMLTQuery;
            if (boostFields.size() > 0) {
                BooleanQuery.Builder newQ = new BooleanQuery.Builder();
                newQ.setDisableCoord(boostedMLTQuery.isCoordDisabled());
                newQ.setMinimumNumberShouldMatch(boostedMLTQuery.getMinimumNumberShouldMatch());
                for (BooleanClause clause : boostedMLTQuery) {
                    Float fieldBoost;
                    Query q = clause.getQuery();
                    float originalBoost = 1.0f;
                    if (q instanceof BoostQuery) {
                        BoostQuery bq = (BoostQuery)q;
                        q = bq.getQuery();
                        originalBoost = bq.getBoost();
                    }
                    q = (fieldBoost = (Float)boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                    newQ.add(q, clause.getOccur());
                }
                boostedMLTQuery = newQ.build();
            }
            BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
            realMLTQuery.setDisableCoord(true);
            realMLTQuery.add(boostedMLTQuery, BooleanClause.Occur.MUST);
            realMLTQuery.add(this.createIdQuery(this.req.getSchema().getUniqueKeyField().getName(), id), BooleanClause.Occur.MUST_NOT);
            return realMLTQuery.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad Request");
        }
    }

    private SolrDocument getDocument(String id) {
        SolrCore core = this.req.getCore();
        SolrQueryResponse rsp = new SolrQueryResponse();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("id", id);
        SolrQueryRequestBase request = new SolrQueryRequestBase(core, params){};
        core.getRequestHandler("/get").handleRequest(request, rsp);
        NamedList response = rsp.getValues();
        return (SolrDocument)response.get("doc");
    }

    private Query createIdQuery(String defaultField, String uniqueValue) {
        return new TermQuery(this.req.getSchema().getField(defaultField).getType().getNumericType() != null ? this.createNumericTerm(defaultField, uniqueValue) : new Term(defaultField, uniqueValue));
    }

    private Term createNumericTerm(String field, String uniqueValue) {
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(6);
        NumericUtils.intToPrefixCoded(Integer.parseInt(uniqueValue), 0, bytesRefBuilder);
        return new Term(field, bytesRefBuilder.toBytesRef());
    }
}

