/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.SolrIndexSearcher;

class BlockJoinFieldFacetAccumulator {
    private String fieldName;
    private FieldType fieldType;
    private int currentSegment = -1;
    private SortedSetDocValues topSSDV;
    private int[] globalCounts;
    private SortedSetDocValues segmentSSDV;
    private long[] segmentAccums = new long[0];
    private MultiDocValues.OrdinalMap ordinalMap;
    private SchemaField schemaField;
    private SortedDocValues segmentSDV;

    BlockJoinFieldFacetAccumulator(String fieldName, SolrIndexSearcher searcher) throws IOException {
        this.fieldName = fieldName;
        this.schemaField = searcher.getSchema().getField(fieldName);
        this.fieldType = this.schemaField.getType();
        this.ordinalMap = null;
        if (this.schemaField.multiValued()) {
            this.topSSDV = searcher.getLeafReader().getSortedSetDocValues(fieldName);
            if (this.topSSDV instanceof MultiDocValues.MultiSortedSetDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)this.topSSDV).mapping;
            }
        } else {
            SortedDocValues single = searcher.getLeafReader().getSortedDocValues(fieldName);
            SortedSetDocValues sortedSetDocValues = this.topSSDV = single == null ? null : DocValues.singleton(single);
            if (single instanceof MultiDocValues.MultiSortedDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
            }
        }
    }

    private boolean initSegmentData(String fieldName, LeafReaderContext leaf) throws IOException {
        this.segmentSSDV = DocValues.getSortedSet(leaf.reader(), fieldName);
        this.segmentAccums = ArrayUtil.grow(this.segmentAccums, (int)this.segmentSSDV.getValueCount() + 1);
        Arrays.fill(this.segmentAccums, 0, (int)this.segmentSSDV.getValueCount() + 1, 0xFFFFFFFFL);
        this.segmentSDV = DocValues.unwrapSingleton(this.segmentSSDV);
        return this.segmentSSDV.getValueCount() != 0L;
    }

    void updateCountsWithMatchedBlock(AggregatableDocIter iter) throws IOException {
        if (this.segmentSDV != null) {
            iter.reset();
            while (iter.hasNext()) {
                int docNum = iter.nextDoc();
                int term = this.segmentSDV.getOrd(docNum);
                this.accumulateTermOrd(term, iter.getAggKey());
            }
        } else {
            iter.reset();
            while (iter.hasNext()) {
                int docNum = iter.nextDoc();
                this.segmentSSDV.setDocument(docNum);
                int term = (int)this.segmentSSDV.nextOrd();
                do {
                    this.accumulateTermOrd(term, iter.getAggKey());
                } while (term >= 0 && (term = (int)this.segmentSSDV.nextOrd()) >= 0);
            }
        }
    }

    String getFieldName() {
        return this.fieldName;
    }

    NamedList<Integer> getFacetValue() {
        NamedList<Integer> facetValue = new NamedList<Integer>();
        CharsRefBuilder charsRef = new CharsRefBuilder();
        for (int i = 1; i < (this.globalCounts != null ? this.globalCounts.length : this.segmentAccums.length); ++i) {
            int count;
            int n = count = this.globalCounts != null ? this.globalCounts[i] : (int)(this.segmentAccums[i] >> 32);
            if (count <= 0) continue;
            BytesRef term = this.topSSDV.lookupOrd(-1 + i);
            this.fieldType.indexedToReadable(term, charsRef);
            facetValue.add(charsRef.toString(), count);
        }
        return facetValue;
    }

    private void accumulateTermOrd(int term, int parentDoc) {
        long accum = this.segmentAccums[1 + term];
        if ((int)(accum & 0xFFFFFFFFL) != parentDoc) {
            this.segmentAccums[1 + term] = accum + 0x100000000L & 0xFFFFFFFF00000000L | (long)parentDoc;
        }
    }

    void setNextReader(LeafReaderContext context) throws IOException {
        this.initSegmentData(this.fieldName, context);
        this.currentSegment = context.ord;
    }

    void migrateGlobal() {
        if (this.currentSegment < 0 || this.segmentAccums.length == 0 || this.ordinalMap == null) {
            return;
        }
        if (this.globalCounts == null) {
            this.globalCounts = new int[(int)this.ordinalMap.getValueCount() + 1];
        } else assert (this.currentSegment >= 0);
        this.migrateGlobal(this.globalCounts, this.segmentAccums, this.currentSegment, this.ordinalMap);
    }

    void migrateGlobal(int[] counts, long[] segCounts, int subIndex, MultiDocValues.OrdinalMap map) {
        LongValues ordMap = map.getGlobalOrds(subIndex);
        counts[0] = counts[0] + (int)(segCounts[0] >> 32);
        int ord = 1;
        while ((long)ord <= this.segmentSSDV.getValueCount()) {
            int count = (int)(segCounts[ord] >> 32);
            if (count != 0) {
                int n = 1 + (int)ordMap.get(ord - 1);
                counts[n] = counts[n] + count;
            }
            ++ord;
        }
    }

    static class SortedIntsAggDocIterator
    implements AggregatableDocIter {
        private int[] childDocs;
        private int childCount;
        private int parentDoc;
        private int pos = -1;

        public SortedIntsAggDocIterator(int[] childDocs, int childCount, int parentDoc) {
            this.childDocs = childDocs;
            this.childCount = childCount;
            this.parentDoc = parentDoc;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.childCount;
        }

        @Override
        public Integer next() {
            return this.nextDoc();
        }

        @Override
        public int nextDoc() {
            return this.childDocs[this.pos++];
        }

        @Override
        public float score() {
            return 0.0f;
        }

        @Override
        public void reset() {
            this.pos = 0;
        }

        @Override
        public int getAggKey() {
            return this.parentDoc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("for" + this);
        }
    }

    static interface AggregatableDocIter
    extends DocIterator {
        public void reset();

        public int getAggKey();
    }
}

