/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.join.BlockJoinFacetComponent;
import org.apache.solr.search.join.BlockJoinFieldFacetAccumulator;

class BlockJoinFacetCollector
extends DelegatingCollector {
    private BlockJoinFieldFacetAccumulator[] blockJoinFieldFacetAccumulators;
    private boolean firstSegment = true;
    private ToParentBlockJoinQuery.ChildrenMatchesScorer blockJoinScorer;
    private int[] childDocs = new int[0];

    BlockJoinFacetCollector(SolrQueryRequest req) throws IOException {
        String[] facetFieldNames = BlockJoinFacetComponent.getChildFacetFields(req);
        assert (facetFieldNames != null);
        this.blockJoinFieldFacetAccumulators = new BlockJoinFieldFacetAccumulator[facetFieldNames.length];
        for (int i = 0; i < facetFieldNames.length; ++i) {
            this.blockJoinFieldFacetAccumulators[i] = new BlockJoinFieldFacetAccumulator(facetFieldNames[i], req.getSearcher());
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        super.setScorer(scorer);
        this.blockJoinScorer = this.getToParentScorer(scorer, new LinkedList<Scorer>());
        if (this.blockJoinScorer != null) {
            this.blockJoinScorer.trackPendingChildHits();
        }
    }

    private ToParentBlockJoinQuery.ChildrenMatchesScorer getToParentScorer(Scorer scorer, Queue<Scorer> queue) {
        if (scorer == null || scorer instanceof ToParentBlockJoinQuery.ChildrenMatchesScorer) {
            return (ToParentBlockJoinQuery.ChildrenMatchesScorer)scorer;
        }
        for (Scorer.ChildScorer child : scorer.getChildren()) {
            queue.add(child.child);
        }
        return this.getToParentScorer(queue.poll(), queue);
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        for (BlockJoinFieldFacetAccumulator blockJoinFieldFacetAccumulator : this.blockJoinFieldFacetAccumulators) {
            if (!this.firstSegment) {
                blockJoinFieldFacetAccumulator.migrateGlobal();
            }
            blockJoinFieldFacetAccumulator.setNextReader(context);
        }
        this.firstSegment = false;
        super.doSetNextReader(context);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.incrementFacets(doc);
        super.collect(doc);
    }

    @Override
    public void finish() throws IOException {
        for (BlockJoinFieldFacetAccumulator blockJoinFieldFacetAccumulator : this.blockJoinFieldFacetAccumulators) {
            blockJoinFieldFacetAccumulator.migrateGlobal();
        }
        super.finish();
    }

    protected void incrementFacets(int parent) throws IOException {
        int[] docNums = this.blockJoinScorer.swapChildDocs(this.childDocs);
        int childCountNoParent = this.blockJoinScorer.getChildCount();
        BlockJoinFieldFacetAccumulator.SortedIntsAggDocIterator iter = new BlockJoinFieldFacetAccumulator.SortedIntsAggDocIterator(docNums, childCountNoParent, parent);
        this.countFacets(iter);
    }

    protected void countFacets(BlockJoinFieldFacetAccumulator.AggregatableDocIter iter) throws IOException {
        for (BlockJoinFieldFacetAccumulator blockJoinFieldFacetAccumulator : this.blockJoinFieldFacetAccumulators) {
            blockJoinFieldFacetAccumulator.updateCountsWithMatchedBlock(iter);
        }
    }

    NamedList getFacets() {
        NamedList<NamedList<Integer>> facets = new NamedList<NamedList<Integer>>(this.blockJoinFieldFacetAccumulators.length);
        for (BlockJoinFieldFacetAccumulator state : this.blockJoinFieldFacetAccumulators) {
            facets.add(state.getFieldName(), state.getFacetValue());
        }
        return facets;
    }
}

