/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import com.spatial4j.core.io.GeohashUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;

public class GeohashFunction
extends ValueSource {
    protected ValueSource lat;
    protected ValueSource lon;

    public GeohashFunction(ValueSource lat, ValueSource lon) {
        this.lat = lat;
        this.lon = lon;
    }

    protected String name() {
        return "geohash";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues latDV = this.lat.getValues(context, readerContext);
        final FunctionValues lonDV = this.lon.getValues(context, readerContext);
        return new FunctionValues(){

            @Override
            public String strVal(int doc) {
                return GeohashUtils.encodeLatLon(latDV.doubleVal(doc), lonDV.doubleVal(doc));
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(GeohashFunction.this.name()).append('(');
                sb.append(latDV.toString(doc)).append(',').append(lonDV.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeohashFunction)) {
            return false;
        }
        GeohashFunction that = (GeohashFunction)o;
        if (!this.lat.equals(that.lat)) {
            return false;
        }
        return this.lon.equals(that.lon);
    }

    @Override
    public int hashCode() {
        int result = this.lat.hashCode();
        result = 29 * result - this.lon.hashCode();
        return result;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        sb.append(this.lat).append(',').append(this.lon);
        sb.append(')');
        return sb.toString();
    }
}

