/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.solr.search.SolrFilter;

public class ValueSourceRangeFilter
extends SolrFilter {
    private final ValueSource valueSource;
    private final String lowerVal;
    private final String upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public ValueSourceRangeFilter(ValueSource valueSource, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        this.valueSource = valueSource;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public String getLowerVal() {
        return this.lowerVal;
    }

    public String getUpperVal() {
        return this.upperVal;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    @Override
    public DocIdSet getDocIdSet(final Map context, final LeafReaderContext readerContext, Bits acceptDocs) throws IOException {
        return BitsFilteredDocIdSet.wrap(new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                ValueSourceScorer scorer = ValueSourceRangeFilter.this.valueSource.getValues(context, readerContext).getRangeScorer(readerContext.reader(), ValueSourceRangeFilter.this.lowerVal, ValueSourceRangeFilter.this.upperVal, ValueSourceRangeFilter.this.includeLower, ValueSourceRangeFilter.this.includeUpper);
                return scorer == null ? null : ((Scorer)scorer).iterator();
            }

            @Override
            public Bits bits() {
                return null;
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        }, acceptDocs);
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.valueSource.createWeight(context, searcher);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("frange(");
        sb.append(this.valueSource);
        sb.append("):");
        sb.append(this.includeLower ? (char)'[' : '{');
        sb.append(this.lowerVal == null ? "*" : this.lowerVal);
        sb.append(" TO ");
        sb.append(this.upperVal == null ? "*" : this.upperVal);
        sb.append(this.includeUpper ? (char)']' : '}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueSourceRangeFilter)) {
            return false;
        }
        ValueSourceRangeFilter other = (ValueSourceRangeFilter)o;
        if (!this.valueSource.equals(other.valueSource) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        return !(this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null);
    }

    @Override
    public int hashCode() {
        int h = this.valueSource.hashCode();
        h += this.lowerVal != null ? this.lowerVal.hashCode() : 1461933019;
        h = h << 16 | h >>> 16;
        h += this.upperVal != null ? this.upperVal.hashCode() : -512759321;
        return h += (this.includeLower ? -626755208 : 0) + (this.includeUpper ? -1637659817 : 0);
    }
}

