/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetComponentState;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.FacetTopParser;
import org.apache.solr.search.facet.LegacyFacet;
import org.apache.solr.util.RTimer;

public class FacetModule
extends SearchComponent {
    public static final String COMPONENT_NAME = "facet_module";
    public static final int PURPOSE_GET_JSON_FACETS = 0x100000;
    public static final int PURPOSE_REFINE_JSON_FACETS = 0x200000;
    private static final String FACET_STATE = "_facet_";

    public FacetComponentState getFacetComponentState(ResponseBuilder rb) {
        return (FacetComponentState)rb.req.getContext().get(FacetComponentState.class);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        boolean isShard = rb.req.getParams().getBool("isShard", false);
        FacetContext fcontext = new FacetContext();
        fcontext.base = rb.getResults().docSet;
        fcontext.req = rb.req;
        fcontext.searcher = rb.req.getSearcher();
        fcontext.qcontext = QueryContext.newContext(fcontext.searcher);
        if (isShard) {
            fcontext.flags |= 1;
        }
        FacetProcessor fproc = facetState.facetRequest.createFacetProcessor(fcontext);
        if (rb.isDebug()) {
            FacetDebugInfo fdebug = new FacetDebugInfo();
            fcontext.setDebugInfo(fdebug);
            fdebug.setReqDescription(facetState.facetRequest.getFacetDescription());
            fdebug.setProcessor(fproc.getClass().getSimpleName());
            RTimer timer = new RTimer();
            fproc.process();
            long timeElapsed = (long)timer.getTime();
            fdebug.setElapse(timeElapsed);
            fdebug.putInfoItem("domainSize", fcontext.base.size());
            rb.req.getContext().put("FacetDebugInfo", fdebug);
        } else {
            fproc.process();
        }
        rb.rsp.add("facets", fproc.getResponse());
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        String jfacet;
        Map<String, Object> json = rb.req.getJSON();
        Map<String, Object> jsonFacet = null;
        if (json == null) {
            int version = rb.req.getParams().getInt("facet.version", 1);
            if (version <= 1) {
                return;
            }
            boolean facetsEnabled = rb.req.getParams().getBool("facet", false);
            if (!facetsEnabled) {
                return;
            }
            jsonFacet = new LegacyFacet(rb.req.getParams()).getLegacy();
        } else {
            jsonFacet = (Map<String, Object>)json.get("facet");
        }
        if (jsonFacet == null) {
            return;
        }
        SolrParams params = rb.req.getParams();
        boolean isShard = params.getBool("isShard", false);
        if (isShard && (jfacet = params.get(FACET_STATE)) == null) {
            return;
        }
        rb.setNeedDocSet(true);
        FacetTopParser parser = new FacetTopParser(rb.req);
        FacetRequest facetRequest = null;
        try {
            facetRequest = ((FacetParser)parser).parse(jsonFacet);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
        FacetComponentState fcState = new FacetComponentState();
        fcState.rb = rb;
        fcState.isShard = isShard;
        fcState.facetCommands = jsonFacet;
        fcState.facetRequest = facetRequest;
        rb.req.getContext().put(FacetComponentState.class, fcState);
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return ResponseBuilder.STAGE_DONE;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x100000;
            sreq.params.set(FACET_STATE, "{}");
        } else {
            sreq.params.remove("json.facet");
            sreq.params.remove(FACET_STATE);
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        for (ShardResponse shardRsp : sreq.responses) {
            Object facet;
            SolrResponse rsp = shardRsp.getSolrResponse();
            NamedList<Object> top = rsp.getResponse();
            if (top == null || (facet = top.get("facets")) == null) continue;
            if (facetState.merger == null) {
                facetState.merger = facetState.facetRequest.createFacetMerger(facet);
            }
            facetState.merger.merge(facet, new FacetMerger.Context());
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        FacetComponentState facetState = this.getFacetComponentState(rb);
        if (facetState == null) {
            return;
        }
        if (facetState.merger != null) {
            rb.rsp.add("facets", facetState.merger.getMergedResult());
        }
    }

    @Override
    public String getDescription() {
        return "Facet Module";
    }

    @Override
    public String getSource() {
        return null;
    }
}

