/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSortField;

public class Sorting {
    public static SortField getStringSortField(String fieldName, boolean reverse, boolean nullLast, boolean nullFirst) {
        SortField sortField = new SortField(fieldName, SortField.Type.STRING, reverse);
        Sorting.applyMissingFirstLast(sortField, reverse, nullLast, nullFirst);
        return sortField;
    }

    public static SortField getTextSortField(String fieldName, boolean reverse, boolean nullLast, boolean nullFirst) {
        SortedSetSortField sortField = new SortedSetSortField(fieldName, reverse);
        Sorting.applyMissingFirstLast(sortField, reverse, nullLast, nullFirst);
        return sortField;
    }

    private static void applyMissingFirstLast(SortField in, boolean reverse, boolean nullLast, boolean nullFirst) {
        if (nullFirst && nullLast) {
            throw new IllegalArgumentException("Cannot specify missing values as both first and last");
        }
        if (nullFirst && reverse) {
            in.setMissingValue(SortField.STRING_LAST);
        } else if (nullLast && !reverse) {
            in.setMissingValue(SortField.STRING_LAST);
        }
    }
}

