/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;

public class SortSpecParsing {
    public static final String DOCID = "_docid_";
    public static final String SCORE = "score";

    public static SortSpec parseSortSpec(String sortSpec, SolrQueryRequest req) {
        return SortSpecParsing.parseSortSpecImpl(sortSpec, req.getSchema(), req);
    }

    public static SortSpec parseSortSpec(String sortSpec, IndexSchema schema) {
        return SortSpecParsing.parseSortSpecImpl(sortSpec, schema, null);
    }

    private static SortSpec parseSortSpecImpl(String sortSpec, IndexSchema schema, SolrQueryRequest optionalReq) {
        if (sortSpec == null || sortSpec.length() == 0) {
            return SortSpecParsing.newEmptySortSpec();
        }
        ArrayList<SortField> sorts = new ArrayList<SortField>(4);
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>(4);
        try {
            StrParser sp = new StrParser(sortSpec);
            while (sp.pos < sp.end) {
                Boolean top;
                sp.eatws();
                int start = sp.pos;
                String field = sp.getId(null);
                Exception qParserException = null;
                if (!(field != null && Character.isWhitespace(sp.peekChar()) || optionalReq == null)) {
                    field = null;
                    String funcStr = sp.val.substring(start);
                    QParser parser = QParser.getParser(funcStr, "func", optionalReq);
                    Query q = null;
                    try {
                        if (parser instanceof FunctionQParser) {
                            int leftOver;
                            FunctionQParser fparser = (FunctionQParser)parser;
                            fparser.setParseMultipleSources(false);
                            fparser.setParseToEnd(false);
                            q = fparser.getQuery();
                            if (fparser.localParams != null) {
                                if (fparser.valFollowedParams) {
                                    leftOver = fparser.sp.end - fparser.sp.pos;
                                    sp.pos = sp.end - leftOver;
                                } else {
                                    sp.pos = start + fparser.localParamsEnd;
                                }
                            } else {
                                leftOver = fparser.sp.end - fparser.sp.pos;
                                sp.pos = sp.end - leftOver;
                            }
                        } else {
                            q = parser.getQuery();
                            assert (parser.getLocalParams() != null);
                            sp.pos = start + parser.localParamsEnd;
                        }
                        Boolean top2 = sp.getSortDirection();
                        if (null != top2) {
                            if (q instanceof FunctionQuery) {
                                sorts.add(((FunctionQuery)q).getValueSource().getSortField(top2));
                            } else {
                                sorts.add(new QueryValueSource(q, 0.0f).getSortField(top2));
                            }
                            fields.add(null);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        qParserException = e;
                    }
                }
                if (field == null) {
                    sp.pos = start;
                    field = sp.getSimpleString();
                }
                if (null == (top = sp.getSortDirection())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't determine a Sort Order (asc or desc) in sort spec " + sp);
                }
                if (SCORE.equals(field)) {
                    if (top.booleanValue()) {
                        sorts.add(SortField.FIELD_SCORE);
                    } else {
                        sorts.add(new SortField(null, SortField.Type.SCORE, true));
                    }
                    fields.add(null);
                    continue;
                }
                if (DOCID.equals(field)) {
                    sorts.add(new SortField(null, SortField.Type.DOC, (boolean)top));
                    fields.add(null);
                    continue;
                }
                SchemaField sf = schema.getFieldOrNull(field);
                if (null == sf) {
                    if (null != qParserException) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sort param could not be parsed as a query, and is not a field that exists in the index: " + field, (Throwable)qParserException);
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sort param field can't be found: " + field);
                }
                sorts.add(sf.getSortField(top));
                fields.add(sf);
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error in sort: " + sortSpec, (Throwable)e);
        }
        if (sorts.size() == 1 && sorts.get(0) == SortField.FIELD_SCORE) {
            return SortSpecParsing.newEmptySortSpec();
        }
        Sort s = new Sort(sorts.toArray(new SortField[sorts.size()]));
        return new SortSpec(s, fields);
    }

    private static SortSpec newEmptySortSpec() {
        return new SortSpec(null, Collections.emptyList());
    }
}

