/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.QueryTimeout;

public class SolrQueryTimeoutImpl
implements QueryTimeout {
    public static ThreadLocal<Long> timeoutAt = new ThreadLocal();
    private static SolrQueryTimeoutImpl instance = new SolrQueryTimeoutImpl();

    private SolrQueryTimeoutImpl() {
    }

    public static SolrQueryTimeoutImpl getInstance() {
        return instance;
    }

    public static Long get() {
        return timeoutAt.get();
    }

    @Override
    public boolean shouldExit() {
        Long timeoutAt = SolrQueryTimeoutImpl.get();
        if (timeoutAt == null) {
            return false;
        }
        return timeoutAt - System.nanoTime() < 0L;
    }

    public static void set(Long timeAllowed) {
        long time = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeAllowed, TimeUnit.MILLISECONDS);
        timeoutAt.set(time);
    }

    public static void reset() {
        timeoutAt.remove();
    }

    public String toString() {
        return "timeoutAt: " + SolrQueryTimeoutImpl.get() + " (System.nanoTime(): " + System.nanoTime() + ")";
    }
}

