/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.SolrFilter;

public class SolrConstantScoreQuery
extends Query
implements ExtendedQuery {
    private final Filter filter;
    boolean cache = true;
    int cost;

    public SolrConstantScoreQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public boolean getCache() {
        return this.cache;
    }

    @Override
    public void setCacheSep(boolean cacheSep) {
    }

    @Override
    public boolean getCacheSep() {
        return false;
    }

    @Override
    public void setCost(int cost) {
        this.cost = cost;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return ExtendedQueryBase.getOptionsString(this) + "ConstantScore(" + this.filter.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        SolrConstantScoreQuery other = (SolrConstantScoreQuery)o;
        return this.filter.equals(other.filter);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.filter.hashCode();
    }

    protected class ConstantWeight
    extends ConstantScoreWeight {
        private Map context;

        public ConstantWeight(IndexSearcher searcher) throws IOException {
            super(SolrConstantScoreQuery.this);
            this.context = ValueSource.newContext(searcher);
            if (SolrConstantScoreQuery.this.filter instanceof SolrFilter) {
                ((SolrFilter)SolrConstantScoreQuery.this.filter).createWeight(this.context, searcher);
            }
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet docIdSet;
            DocIdSet docIdSet2 = docIdSet = SolrConstantScoreQuery.this.filter instanceof SolrFilter ? ((SolrFilter)SolrConstantScoreQuery.this.filter).getDocIdSet(this.context, context, null) : SolrConstantScoreQuery.this.filter.getDocIdSet(context, null);
            if (docIdSet == null) {
                return null;
            }
            DocIdSetIterator iterator = docIdSet.iterator();
            if (iterator == null) {
                return null;
            }
            return new ConstantScoreScorer((Weight)this, this.score(), iterator);
        }
    }
}

