/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.search.WrappedQuery;

public class QueryUtils {
    public static boolean isNegative(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List<BooleanClause> clauses = bq.clauses();
        if (clauses.size() == 0) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static Query getAbs(Query q) {
        if (q instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)q;
            Query subQ = bq.getQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ == subQ) {
                return q;
            }
            return new BoostQuery(absSubQ, bq.getBoost());
        }
        if (q instanceof WrappedQuery) {
            Query subQ = ((WrappedQuery)q).getWrappedQuery();
            Query absSubQ = QueryUtils.getAbs(subQ);
            if (absSubQ == subQ) {
                return q;
            }
            return new WrappedQuery(absSubQ);
        }
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery bq = (BooleanQuery)q;
        List<BooleanClause> clauses = bq.clauses();
        if (clauses.size() == 0) {
            return q;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return q;
        }
        if (clauses.size() == 1) {
            Query negClause = ((BooleanClause)clauses.iterator().next()).getQuery();
            return negClause;
        }
        BooleanQuery.Builder newBqB = new BooleanQuery.Builder();
        newBqB.setDisableCoord(bq.isCoordDisabled());
        for (BooleanClause clause : clauses) {
            newBqB.add(clause.getQuery(), BooleanClause.Occur.SHOULD);
        }
        return newBqB.build();
    }

    public static Query makeQueryable(Query q) {
        if (q instanceof WrappedQuery) {
            return QueryUtils.makeQueryable(((WrappedQuery)q).getWrappedQuery());
        }
        return QueryUtils.isNegative(q) ? QueryUtils.fixNegativeQuery(q) : q;
    }

    public static Query fixNegativeQuery(Query q) {
        Query bq;
        float boost = 1.0f;
        if (q instanceof BoostQuery) {
            bq = (BoostQuery)q;
            boost = ((BoostQuery)bq).getBoost();
            q = ((BoostQuery)bq).getQuery();
        }
        bq = (BooleanQuery)q;
        BooleanQuery.Builder newBqB = new BooleanQuery.Builder();
        newBqB.setDisableCoord(((BooleanQuery)bq).isCoordDisabled());
        newBqB.setMinimumNumberShouldMatch(((BooleanQuery)bq).getMinimumNumberShouldMatch());
        Iterator<BooleanClause> i$ = ((BooleanQuery)bq).iterator();
        while (i$.hasNext()) {
            BooleanClause clause = i$.next();
            newBqB.add(clause);
        }
        newBqB.add(new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        BooleanQuery newBq = newBqB.build();
        return new BoostQuery(newBq, boost);
    }
}

