/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;

abstract class DocSetBase
implements DocSet {
    DocSetBase() {
    }

    public static FixedBitSet toBitSet(DocSet set) {
        if (set instanceof DocSetBase) {
            return ((DocSetBase)set).getBits();
        }
        FixedBitSet bits = new FixedBitSet(64);
        DocIterator iter = set.iterator();
        while (iter.hasNext()) {
            int nextDoc = iter.nextDoc();
            bits = FixedBitSet.ensureCapacity(bits, nextDoc);
            bits.set(nextDoc);
        }
        return bits;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocSet)) {
            return false;
        }
        DocSet other = (DocSet)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this instanceof DocList && other instanceof DocList) {
            DocIterator i1 = this.iterator();
            DocIterator i2 = other.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (i1.nextDoc() == i2.nextDoc()) continue;
                return false;
            }
            return true;
        }
        return this.getBits().equals(DocSetBase.toBitSet(other));
    }

    @Override
    public void add(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    @Override
    public void addUnique(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    protected FixedBitSet getBits() {
        FixedBitSet bits = new FixedBitSet(64);
        DocIterator iter = this.iterator();
        while (iter.hasNext()) {
            int nextDoc = iter.nextDoc();
            bits = FixedBitSet.ensureCapacity(bits, nextDoc);
            bits.set(nextDoc);
        }
        return bits;
    }

    @Override
    public DocSet intersection(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersection(this);
        }
        FixedBitSet newbits = this.getBits().clone();
        newbits.and(DocSetBase.toBitSet(other));
        return new BitDocSet(newbits);
    }

    @Override
    public boolean intersects(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersects(this);
        }
        return this.intersectionSize(other) > 0;
    }

    @Override
    public DocSet union(DocSet other) {
        FixedBitSet otherBits = DocSetBase.toBitSet(other);
        FixedBitSet newbits = FixedBitSet.ensureCapacity(this.getBits().clone(), otherBits.length());
        newbits.or(otherBits);
        return new BitDocSet(newbits);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersectionSize(this);
        }
        return this.intersection(other).size();
    }

    @Override
    public int unionSize(DocSet other) {
        return this.size() + other.size() - this.intersectionSize(other);
    }

    @Override
    public DocSet andNot(DocSet other) {
        FixedBitSet newbits = this.getBits().clone();
        newbits.andNot(DocSetBase.toBitSet(other));
        return new BitDocSet(newbits);
    }

    @Override
    public int andNotSize(DocSet other) {
        return this.size() - this.intersectionSize(other);
    }

    @Override
    public Filter getTopFilter() {
        final FixedBitSet bs = this.getBits();
        return new Filter(){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) {
                Bits acceptDocs2;
                LeafReader reader = context.reader();
                Bits bits = acceptDocs == null ? null : (acceptDocs2 = reader.getLiveDocs() == acceptDocs ? null : acceptDocs);
                if (context.isTopLevel) {
                    return BitsFilteredDocIdSet.wrap(new BitDocIdSet(bs), acceptDocs);
                }
                final int base = context.docBase;
                int maxDoc = reader.maxDoc();
                final int max = base + maxDoc;
                return BitsFilteredDocIdSet.wrap(new DocIdSet(){

                    @Override
                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){
                            int pos;
                            int adjustedDoc;
                            {
                                this.pos = base - 1;
                                this.adjustedDoc = -1;
                            }

                            @Override
                            public int docID() {
                                return this.adjustedDoc;
                            }

                            @Override
                            public int nextDoc() {
                                this.pos = bs.nextSetBit(this.pos + 1);
                                this.adjustedDoc = this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            @Override
                            public int advance(int target) {
                                if (target == Integer.MAX_VALUE) {
                                    this.adjustedDoc = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.pos = bs.nextSetBit(target + base);
                                this.adjustedDoc = this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                                return this.adjustedDoc;
                            }

                            @Override
                            public long cost() {
                                return bs.length();
                            }
                        };
                    }

                    @Override
                    public boolean isCacheable() {
                        return true;
                    }

                    @Override
                    public long ramBytesUsed() {
                        return bs.ramBytesUsed();
                    }

                    @Override
                    public Bits bits() {
                        return null;
                    }
                }, acceptDocs2);
            }

            @Override
            public String toString(String field) {
                return "DocSetTopFilter";
            }
        };
    }

    @Override
    public void addAllTo(DocSet target) {
        DocIterator iter = this.iterator();
        while (iter.hasNext()) {
            target.add(iter.nextDoc());
        }
    }

    @Override
    public void close() throws IOException {
    }
}

