/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SchemaXmlWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FieldTypePluginLoader;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.similarities.ClassicSimilarityFactory;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class IndexSchema {
    public static final String COPY_FIELD = "copyField";
    public static final String COPY_FIELDS = "copyFields";
    public static final String DEFAULT_OPERATOR = "defaultOperator";
    public static final String DEFAULT_SCHEMA_FILE = "schema.xml";
    public static final String DEFAULT_SEARCH_FIELD = "defaultSearchField";
    public static final String DESTINATION = "dest";
    public static final String DYNAMIC_FIELD = "dynamicField";
    public static final String DYNAMIC_FIELDS = "dynamicFields";
    public static final String FIELD = "field";
    public static final String FIELDS = "fields";
    public static final String FIELD_TYPE = "fieldType";
    public static final String FIELD_TYPES = "fieldTypes";
    public static final String INTERNAL_POLY_FIELD_PREFIX = "*___";
    public static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    public static final String MAX_CHARS = "maxChars";
    public static final String NAME = "name";
    public static final String REQUIRED = "required";
    public static final String SCHEMA = "schema";
    public static final String SIMILARITY = "similarity";
    public static final String SLASH = "/";
    public static final String SOLR_QUERY_PARSER = "solrQueryParser";
    public static final String SOURCE = "source";
    public static final String TYPE = "type";
    public static final String TYPES = "types";
    public static final String UNIQUE_KEY = "uniqueKey";
    public static final String VERSION = "version";
    private static final String AT = "@";
    private static final String DESTINATION_DYNAMIC_BASE = "destDynamicBase";
    private static final String SOLR_CORE_NAME = "solr.core.name";
    private static final String SOURCE_DYNAMIC_BASE = "sourceDynamicBase";
    private static final String SOURCE_EXPLICIT_FIELDS = "sourceExplicitFields";
    private static final String TEXT_FUNCTION = "text()";
    private static final String XPATH_OR = " | ";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrConfig solrConfig;
    protected String resourceName;
    protected String name;
    protected float version;
    protected final SolrResourceLoader loader;
    protected Map<String, SchemaField> fields = new HashMap<String, SchemaField>();
    protected Map<String, FieldType> fieldTypes = new HashMap<String, FieldType>();
    protected List<SchemaField> fieldsWithDefaultValue = new ArrayList<SchemaField>();
    protected Collection<SchemaField> requiredFields = new HashSet<SchemaField>();
    protected volatile DynamicField[] dynamicFields;
    private Analyzer indexAnalyzer;
    private Analyzer queryAnalyzer;
    protected List<SchemaAware> schemaAware = new ArrayList<SchemaAware>();
    protected String defaultSearchFieldName = null;
    protected String queryParserDefaultOperator = "OR";
    protected boolean isExplicitQueryParserDefaultOperator = false;
    protected Map<String, List<CopyField>> copyFieldsMap = new HashMap<String, List<CopyField>>();
    protected DynamicCopy[] dynamicCopyFields;
    protected Map<SchemaField, Integer> copyFieldTargetCounts = new HashMap<SchemaField, Integer>();
    protected Similarity similarity;
    protected SimilarityFactory similarityFactory;
    protected boolean isExplicitSimilarity = false;
    protected SchemaField uniqueKeyField;
    protected String uniqueKeyFieldName;
    protected FieldType uniqueKeyFieldType;

    public DynamicField[] getDynamicFields() {
        return this.dynamicFields;
    }

    public Map<String, List<CopyField>> getCopyFieldsMap() {
        return Collections.unmodifiableMap(this.copyFieldsMap);
    }

    public DynamicCopy[] getDynamicCopyFields() {
        return this.dynamicCopyFields;
    }

    public IndexSchema(SolrConfig solrConfig, String name, InputSource is) {
        assert (null != solrConfig) : "SolrConfig should never be null";
        assert (null != name) : "schema resource name should never be null";
        assert (null != is) : "schema InputSource should never be null";
        this.solrConfig = solrConfig;
        this.resourceName = name;
        this.loader = solrConfig.getResourceLoader();
        try {
            this.readSchema(is);
            this.loader.inform(this.loader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getSchemaName() {
        return this.name;
    }

    public Version getDefaultLuceneMatchVersion() {
        return this.solrConfig.luceneMatchVersion;
    }

    public float getVersion() {
        return this.version;
    }

    public Map<String, SchemaField> getFields() {
        return this.fields;
    }

    public Map<String, FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SchemaField> getFieldsWithDefaultValue() {
        return this.fieldsWithDefaultValue;
    }

    public Collection<SchemaField> getRequiredFields() {
        return this.requiredFields;
    }

    public Similarity getSimilarity() {
        if (null == this.similarity) {
            this.similarity = this.similarityFactory.getSimilarity();
        }
        return this.similarity;
    }

    public SimilarityFactory getSimilarityFactory() {
        return this.similarityFactory;
    }

    public Analyzer getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public String getDefaultSearchFieldName() {
        return this.defaultSearchFieldName;
    }

    public String getQueryParserDefaultOperator() {
        return this.queryParserDefaultOperator;
    }

    public SchemaField getUniqueKeyField() {
        return this.uniqueKeyField;
    }

    public IndexableField getUniqueKeyField(org.apache.lucene.document.Document doc) {
        return doc.getField(this.uniqueKeyFieldName);
    }

    public String printableUniqueKey(org.apache.lucene.document.Document doc) {
        IndexableField f = doc.getField(this.uniqueKeyFieldName);
        return f == null ? null : this.uniqueKeyFieldType.toExternal(f);
    }

    private SchemaField getIndexedField(String fname) {
        SchemaField f = this.getFields().get(fname);
        if (f == null) {
            throw new RuntimeException("unknown field '" + fname + "'");
        }
        if (!f.indexed()) {
            throw new RuntimeException("'" + fname + "' is not an indexed field:" + f);
        }
        return f;
    }

    public void refreshAnalyzers() {
        this.indexAnalyzer = new SolrIndexAnalyzer();
        this.queryAnalyzer = new SolrQueryAnalyzer();
    }

    public Map<String, UninvertingReader.Type> getUninversionMap(IndexReader reader) {
        HashMap<String, UninvertingReader.Type> map = new HashMap<String, UninvertingReader.Type>();
        for (FieldInfo f : MultiFields.getMergedFieldInfos(reader)) {
            UninvertingReader.Type type;
            SchemaField sf;
            if (f.getDocValuesType() != DocValuesType.NONE || f.getIndexOptions() == IndexOptions.NONE || (sf = this.getFieldOrNull(f.name)) == null || (type = sf.getType().getUninversionType(sf)) == null) continue;
            map.put(f.name, type);
        }
        return map;
    }

    void persist(Writer writer) throws IOException {
        SolrQueryResponse response = new SolrQueryResponse();
        response.add(SCHEMA, this.getNamedPropertyValues());
        NamedList args = new NamedList(Arrays.asList("indent", "on"));
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(null, args);
        SchemaXmlWriter schemaXmlWriter = new SchemaXmlWriter(writer, req, response);
        schemaXmlWriter.setEmitManagedSchemaDoNotEditWarning(true);
        schemaXmlWriter.writeResponse();
        schemaXmlWriter.close();
    }

    public boolean isMutable() {
        return false;
    }

    protected void readSchema(InputSource is) {
        try {
            Config schemaConf = new Config(this.loader, SCHEMA, is, "/schema/");
            Document document = schemaConf.getDocument();
            XPath xpath = schemaConf.getXPath();
            String expression = this.stepsToPath(SCHEMA, "@name");
            Node nd = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            if (this.loader.getCoreProperties() != null) {
                sb.append(this.loader.getCoreProperties().getProperty(SOLR_CORE_NAME));
            } else {
                sb.append("null");
            }
            sb.append("] ");
            if (nd == null) {
                sb.append("schema has no name!");
                log.warn(sb.toString());
            } else {
                this.name = nd.getNodeValue();
                sb.append("Schema ");
                sb.append(NAME);
                sb.append("=");
                sb.append(this.name);
                log.info(sb.toString());
            }
            expression = this.stepsToPath(SCHEMA, "@version");
            this.version = schemaConf.getFloat(expression, 1.0f);
            FieldTypePluginLoader typeLoader = new FieldTypePluginLoader(this, this.fieldTypes, this.schemaAware);
            expression = this.getFieldTypeXPathExpressions();
            NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            typeLoader.load(this.loader, nodes);
            Map<String, Boolean> explicitRequiredProp = this.loadFields(document, xpath);
            expression = this.stepsToPath(SCHEMA, SIMILARITY);
            Node node = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
            this.similarityFactory = IndexSchema.readSimilarity(this.loader, node);
            if (this.similarityFactory == null) {
                this.similarityFactory = new ClassicSimilarityFactory();
                NamedList<Boolean> similarityParams = new NamedList<Boolean>();
                Version luceneVersion = this.getDefaultLuceneMatchVersion();
                if (!luceneVersion.onOrAfter(Version.LUCENE_4_7_0)) {
                    similarityParams.add("discountOverlaps", false);
                }
                this.similarityFactory.init(SolrParams.toSolrParams(similarityParams));
            } else {
                this.isExplicitSimilarity = true;
            }
            if (!(this.similarityFactory instanceof SolrCoreAware)) {
                for (FieldType ft : this.fieldTypes.values()) {
                    if (null == ft.getSimilarity()) continue;
                    String msg = "FieldType '" + ft.getTypeName() + "' is configured with a similarity, but the global similarity does not support it: " + this.similarityFactory.getClass();
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
            }
            if ((node = (Node)xpath.evaluate(expression = this.stepsToPath(SCHEMA, DEFAULT_SEARCH_FIELD, TEXT_FUNCTION), document, XPathConstants.NODE)) == null) {
                log.debug("no default search field specified in schema.");
            } else {
                SchemaField defaultSearchField;
                this.defaultSearchFieldName = node.getNodeValue().trim();
                if (!(this.defaultSearchFieldName == null || (defaultSearchField = this.getFields().get(this.defaultSearchFieldName)) != null && defaultSearchField.indexed())) {
                    String msg = "default search field '" + this.defaultSearchFieldName + "' not defined or not indexed";
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                log.info("default search field in schema is " + this.defaultSearchFieldName);
            }
            expression = this.stepsToPath(SCHEMA, SOLR_QUERY_PARSER, "@defaultOperator");
            node = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
            if (node == null) {
                log.debug("using default query parser operator (OR)");
            } else {
                this.isExplicitQueryParserDefaultOperator = true;
                this.queryParserDefaultOperator = node.getNodeValue().trim();
                log.info("query parser default operator is " + this.queryParserDefaultOperator);
            }
            expression = this.stepsToPath(SCHEMA, UNIQUE_KEY, TEXT_FUNCTION);
            node = (Node)xpath.evaluate(expression, document, XPathConstants.NODE);
            if (node == null) {
                log.warn("no uniqueKey specified in schema.");
            } else {
                String msg;
                this.uniqueKeyField = this.getIndexedField(node.getNodeValue().trim());
                if (null != this.uniqueKeyField.getDefaultValue()) {
                    msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be configured with a default value (" + this.uniqueKeyField.getDefaultValue() + ")";
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (!this.uniqueKeyField.stored()) {
                    log.warn("uniqueKey is not stored - distributed search and MoreLikeThis will not work");
                }
                if (this.uniqueKeyField.multiValued()) {
                    msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be configured to be multivalued";
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                this.uniqueKeyFieldName = this.uniqueKeyField.getName();
                this.uniqueKeyFieldType = this.uniqueKeyField.getType();
                log.info("unique key field: " + this.uniqueKeyFieldName);
                if (Boolean.FALSE != explicitRequiredProp.get(this.uniqueKeyFieldName)) {
                    this.uniqueKeyField.required = true;
                    this.requiredFields.add(this.uniqueKeyField);
                }
            }
            this.dynamicCopyFields = new DynamicCopy[0];
            this.loadCopyFields(document, xpath);
            this.postReadInform();
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.getErrorCode(e.code()), "Can't load schema " + this.loader.resourceLocation(this.resourceName) + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't load schema " + this.loader.resourceLocation(this.resourceName) + ": " + e.getMessage(), (Throwable)e);
        }
        this.refreshAnalyzers();
    }

    protected void postReadInform() {
        for (SchemaAware aware : this.schemaAware) {
            aware.inform(this);
        }
    }

    protected synchronized Map<String, Boolean> loadFields(Document document, XPath xpath) throws XPathExpressionException {
        HashMap<String, Boolean> explicitRequiredProp = new HashMap<String, Boolean>();
        ArrayList<DynamicField> dFields = new ArrayList<DynamicField>();
        String expression = this.stepsToPath(SCHEMA, FIELD) + XPATH_OR + this.stepsToPath(SCHEMA, DYNAMIC_FIELD) + XPATH_OR + this.stepsToPath(SCHEMA, FIELDS, FIELD) + XPATH_OR + this.stepsToPath(SCHEMA, FIELDS, DYNAMIC_FIELD);
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attrs = node.getAttributes();
            String name = DOMUtil.getAttr(attrs, NAME, "field definition");
            log.trace("reading field def " + name);
            String type = DOMUtil.getAttr(attrs, TYPE, "field " + name);
            FieldType ft = this.fieldTypes.get(type);
            if (ft == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fieldType '" + type + "' specified on field " + name);
            }
            Map<String, String> args = DOMUtil.toMapExcept(attrs, NAME, TYPE);
            if (null != args.get(REQUIRED)) {
                explicitRequiredProp.put(name, Boolean.valueOf(args.get(REQUIRED)));
            }
            SchemaField f = SchemaField.create(name, ft, args);
            if (node.getNodeName().equals(FIELD)) {
                SchemaField old = this.fields.put(f.getName(), f);
                if (old != null) {
                    String msg = "[schema.xml] Duplicate field definition for '" + f.getName() + "' [[[" + old.toString() + "]]] and [[[" + f.toString() + "]]]";
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                log.debug("field defined: " + f);
                if (f.getDefaultValue() != null) {
                    log.debug(name + " contains default value: " + f.getDefaultValue());
                    this.fieldsWithDefaultValue.add(f);
                }
                if (!f.isRequired()) continue;
                log.debug(name + " is required in this schema");
                this.requiredFields.add(f);
                continue;
            }
            if (node.getNodeName().equals(DYNAMIC_FIELD)) {
                if (!this.isValidDynamicField(dFields, f)) continue;
                this.addDynamicFieldNoDupCheck(dFields, f);
                continue;
            }
            throw new RuntimeException("Unknown field type");
        }
        this.requiredFields.addAll(this.fieldsWithDefaultValue);
        this.dynamicFields = IndexSchema.dynamicFieldListToSortedArray(dFields);
        return explicitRequiredProp;
    }

    protected static DynamicField[] dynamicFieldListToSortedArray(List<DynamicField> dynamicFieldList) {
        Object[] dFields = dynamicFieldList.toArray(new DynamicField[dynamicFieldList.size()]);
        Arrays.sort(dFields);
        log.trace("Dynamic Field Ordering:" + Arrays.toString(dFields));
        return dFields;
    }

    protected synchronized void loadCopyFields(Document document, XPath xpath) throws XPathExpressionException {
        String expression = "//copyField";
        NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NamedNodeMap attrs = node.getAttributes();
            String source = DOMUtil.getAttr(attrs, SOURCE, "copyField definition");
            String dest = DOMUtil.getAttr(attrs, DESTINATION, "copyField definition");
            String maxChars = DOMUtil.getAttr(attrs, MAX_CHARS);
            int maxCharsInt = 0;
            if (maxChars != null) {
                try {
                    maxCharsInt = Integer.parseInt(maxChars);
                }
                catch (NumberFormatException e) {
                    log.warn("Couldn't parse maxChars attribute for copyField from " + source + " to " + dest + " as integer. The whole field will be copied.");
                }
            }
            if (dest.equals(this.uniqueKeyFieldName)) {
                String msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be the " + DESTINATION + " of a " + COPY_FIELD + "(" + SOURCE + "=" + source + ")";
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            this.registerCopyField(source, dest, maxCharsInt);
        }
        for (Map.Entry<SchemaField, Integer> entry : this.copyFieldTargetCounts.entrySet()) {
            if (entry.getValue() <= 1 || entry.getKey().multiValued()) continue;
            log.warn("Field " + entry.getKey().name + " is not multivalued " + "and destination for multiple " + COPY_FIELDS + " (" + entry.getValue() + ")");
        }
    }

    private String stepsToPath(String ... steps) {
        StringBuilder builder = new StringBuilder();
        for (String step : steps) {
            builder.append(SLASH).append(step);
        }
        return builder.toString();
    }

    protected static boolean isValidFieldGlob(String name) {
        if (name.startsWith("*") || name.endsWith("*")) {
            int count = 0;
            for (int pos = 0; pos < name.length() && -1 != (pos = name.indexOf(42, pos)); ++pos) {
                ++count;
            }
            if (1 == count) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidDynamicField(List<DynamicField> dFields, SchemaField f) {
        String glob = f.getName();
        if (f.getDefaultValue() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "dynamicField can not have a default value: " + glob);
        }
        if (f.isRequired()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "dynamicField can not be required: " + glob);
        }
        if (!IndexSchema.isValidFieldGlob(glob)) {
            String msg = "Dynamic field name '" + glob + "' should have either a leading or a trailing asterisk, and no others.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (this.isDuplicateDynField(dFields, f)) {
            String msg = "[schema.xml] Duplicate DynamicField definition for '" + glob + "'";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return true;
    }

    public void registerDynamicFields(SchemaField ... fields) {
        ArrayList<DynamicField> dynFields = new ArrayList<DynamicField>(Arrays.asList(this.dynamicFields));
        for (SchemaField field : fields) {
            if (this.isDuplicateDynField(dynFields, field)) {
                log.debug("dynamic field already exists: dynamic field: [" + field.getName() + "]");
                continue;
            }
            log.debug("dynamic field creation for schema field: " + field.getName());
            this.addDynamicFieldNoDupCheck(dynFields, field);
        }
        this.dynamicFields = IndexSchema.dynamicFieldListToSortedArray(dynFields);
    }

    private void addDynamicFieldNoDupCheck(List<DynamicField> dFields, SchemaField f) {
        dFields.add(new DynamicField(f));
        log.debug("dynamic field defined: " + f);
    }

    protected boolean isDuplicateDynField(List<DynamicField> dFields, SchemaField f) {
        for (DynamicField df : dFields) {
            if (!df.getRegex().equals(f.name)) continue;
            return true;
        }
        return false;
    }

    public void registerCopyField(String source, String dest) {
        this.registerCopyField(source, dest, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void registerCopyField(String source, String dest, int maxChars) {
        String msg;
        log.debug("copyField source='" + source + "' " + DESTINATION + "='" + dest + "' " + MAX_CHARS + "=" + maxChars);
        DynamicField destDynamicField = null;
        SchemaField destSchemaField = this.fields.get(dest);
        SchemaField sourceSchemaField = this.fields.get(source);
        DynamicField sourceDynamicBase = null;
        DynamicField destDynamicBase = null;
        boolean sourceIsDynamicFieldReference = false;
        boolean sourceIsExplicitFieldGlob = false;
        String invalidGlobMessage = "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
        boolean sourceIsGlob = IndexSchema.isValidFieldGlob(source);
        if (source.contains("*") && !sourceIsGlob) {
            String msg2 = "copyField source :'" + source + "' " + "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg2);
        }
        if (dest.contains("*") && !IndexSchema.isValidFieldGlob(dest)) {
            String msg3 = "copyField dest :'" + dest + "' " + "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg3);
        }
        if (null == sourceSchemaField && sourceIsGlob) {
            Pattern pattern = Pattern.compile(source.replace("*", ".*"));
            for (String field : this.fields.keySet()) {
                if (!pattern.matcher(field).matches()) continue;
                sourceIsExplicitFieldGlob = true;
                break;
            }
        }
        if (null == destSchemaField || null == sourceSchemaField && !sourceIsExplicitFieldGlob) {
            for (DynamicField dynamicField : this.dynamicFields) {
                if (null == sourceSchemaField && !sourceIsDynamicFieldReference && !sourceIsExplicitFieldGlob && dynamicField.matches(source)) {
                    sourceIsDynamicFieldReference = true;
                    if (!source.equals(dynamicField.getRegex())) {
                        sourceDynamicBase = dynamicField;
                    }
                }
                if (null == destSchemaField) {
                    if (dest.equals(dynamicField.getRegex())) {
                        destDynamicField = dynamicField;
                        destSchemaField = dynamicField.prototype;
                    } else if (dynamicField.matches(dest)) {
                        destSchemaField = dynamicField.makeSchemaField(dest);
                        destDynamicField = new DynamicField(destSchemaField);
                        destDynamicBase = dynamicField;
                    }
                }
                if (null != destSchemaField && (null != sourceSchemaField || sourceIsDynamicFieldReference || sourceIsExplicitFieldGlob)) break;
            }
        }
        if (null == sourceSchemaField && !sourceIsGlob && !sourceIsDynamicFieldReference) {
            msg = "copyField source :'" + source + "' is not a glob and doesn't match any explicit field or dynamicField.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (null == destSchemaField) {
            msg = "copyField dest :'" + dest + "' is not an explicit field and doesn't match a dynamicField.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (sourceIsGlob) {
            if (null != destDynamicField) {
                this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, destDynamicBase));
                this.incrementCopyFieldTargetCount(destSchemaField);
                return;
            }
            destDynamicField = new DynamicField(destSchemaField);
            this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, null));
            this.incrementCopyFieldTargetCount(destSchemaField);
            return;
        }
        if (sourceIsDynamicFieldReference) {
            if (null != destDynamicField) {
                this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, destDynamicBase));
                this.incrementCopyFieldTargetCount(destSchemaField);
                return;
            }
            sourceSchemaField = this.getField(source);
            this.registerExplicitSrcAndDestFields(source, maxChars, destSchemaField, sourceSchemaField);
            return;
        }
        if (null == destDynamicField) {
            this.registerExplicitSrcAndDestFields(source, maxChars, destSchemaField, sourceSchemaField);
            return;
        }
        if (destDynamicField.pattern instanceof DynamicReplacement.DynamicPattern.NameEquals) {
            this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, destDynamicBase));
            this.incrementCopyFieldTargetCount(destSchemaField);
            return;
        }
        msg = "copyField only supports a dynamic destination with an asterisk if the source also has an asterisk";
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    protected void registerExplicitSrcAndDestFields(String source, int maxChars, SchemaField destSchemaField, SchemaField sourceSchemaField) {
        List<CopyField> copyFieldList = this.copyFieldsMap.get(source);
        if (copyFieldList == null) {
            copyFieldList = new ArrayList<CopyField>();
            this.copyFieldsMap.put(source, copyFieldList);
        }
        copyFieldList.add(new CopyField(sourceSchemaField, destSchemaField, maxChars));
        this.incrementCopyFieldTargetCount(destSchemaField);
    }

    private void incrementCopyFieldTargetCount(SchemaField dest) {
        this.copyFieldTargetCounts.put(dest, this.copyFieldTargetCounts.containsKey(dest) ? this.copyFieldTargetCounts.get(dest) + 1 : 1);
    }

    private void registerDynamicCopyField(DynamicCopy dcopy) {
        if (this.dynamicCopyFields == null) {
            this.dynamicCopyFields = new DynamicCopy[]{dcopy};
        } else {
            DynamicCopy[] temp = new DynamicCopy[this.dynamicCopyFields.length + 1];
            System.arraycopy(this.dynamicCopyFields, 0, temp, 0, this.dynamicCopyFields.length);
            temp[temp.length - 1] = dcopy;
            this.dynamicCopyFields = temp;
        }
        log.trace("Dynamic Copy Field:" + dcopy);
    }

    static SimilarityFactory readSimilarity(SolrResourceLoader loader, Node node) {
        SimilarityFactory similarityFactory;
        if (node == null) {
            return null;
        }
        String classArg = ((Element)node).getAttribute("class");
        final Object obj = loader.newInstance(classArg, Object.class, "search.similarities.");
        if (obj instanceof SimilarityFactory) {
            NamedList<Object> namedList = DOMUtil.childNodesToNamedList(node);
            namedList.add("class", classArg);
            SolrParams params = SolrParams.toSolrParams(namedList);
            similarityFactory = (SimilarityFactory)obj;
            similarityFactory.init(params);
        } else {
            similarityFactory = new SimilarityFactory(){

                @Override
                public Similarity getSimilarity() {
                    return (Similarity)obj;
                }
            };
        }
        return similarityFactory;
    }

    public SchemaField[] getDynamicFieldPrototypes() {
        SchemaField[] df = new SchemaField[this.dynamicFields.length];
        for (int i = 0; i < this.dynamicFields.length; ++i) {
            df[i] = this.dynamicFields[i].prototype;
        }
        return df;
    }

    public String getDynamicPattern(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.getRegex();
        }
        return null;
    }

    public boolean hasExplicitField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return true;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!fieldName.equals(df.getRegex())) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return false;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return true;
        }
        return false;
    }

    public SchemaField getFieldOrNull(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.makeSchemaField(fieldName);
        }
        return f;
    }

    public SchemaField getField(String fieldName) {
        SchemaField f = this.getFieldOrNull(fieldName);
        if (f != null) {
            return f;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: \"" + fieldName + "\"");
    }

    public FieldType getFieldType(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.getDynamicFieldType(fieldName);
    }

    public FieldType getFieldTypeByName(String fieldTypeName) {
        return this.fieldTypes.get(fieldTypeName);
    }

    public FieldType getFieldTypeNoEx(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.dynFieldType(fieldName);
    }

    public FieldType getDynamicFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field " + fieldName);
    }

    private FieldType dynFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        return null;
    }

    public List<String> getCopySources(String destField) {
        SchemaField f = this.getField(destField);
        if (!this.isCopyFieldTarget(f)) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Map.Entry<String, List<CopyField>> cfs : this.copyFieldsMap.entrySet()) {
            for (CopyField copyField : cfs.getValue()) {
                if (!copyField.getDestination().getName().equals(destField)) continue;
                fieldNames.add(copyField.getSource().getName());
            }
        }
        if (null != this.dynamicCopyFields) {
            for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
                if (!dynamicCopy.getDestFieldName().equals(destField)) continue;
                fieldNames.add(dynamicCopy.getRegex());
            }
        }
        return fieldNames;
    }

    public List<CopyField> getCopyFieldsList(String sourceField) {
        List<CopyField> fixedCopyFields;
        ArrayList<CopyField> result = new ArrayList<CopyField>();
        if (null != this.dynamicCopyFields) {
            for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
                if (!dynamicCopy.matches(sourceField)) continue;
                result.add(new CopyField(this.getField(sourceField), dynamicCopy.getTargetField(sourceField), dynamicCopy.maxChars));
            }
        }
        if (null != (fixedCopyFields = this.copyFieldsMap.get(sourceField))) {
            result.addAll(fixedCopyFields);
        }
        return result;
    }

    public boolean isCopyFieldTarget(SchemaField f) {
        return this.copyFieldTargetCounts.containsKey(f);
    }

    public SimpleOrderedMap<Object> getNamedPropertyValues() {
        SimpleOrderedMap<Object> topLevel = new SimpleOrderedMap<Object>();
        topLevel.add(NAME, this.getSchemaName());
        topLevel.add(VERSION, Float.valueOf(this.getVersion()));
        if (null != this.uniqueKeyFieldName) {
            topLevel.add(UNIQUE_KEY, this.uniqueKeyFieldName);
        }
        if (null != this.defaultSearchFieldName) {
            topLevel.add(DEFAULT_SEARCH_FIELD, this.defaultSearchFieldName);
        }
        if (this.isExplicitQueryParserDefaultOperator) {
            SimpleOrderedMap<String> solrQueryParserProperties = new SimpleOrderedMap<String>();
            solrQueryParserProperties.add(DEFAULT_OPERATOR, this.queryParserDefaultOperator);
            topLevel.add(SOLR_QUERY_PARSER, solrQueryParserProperties);
        }
        if (this.isExplicitSimilarity) {
            topLevel.add(SIMILARITY, this.similarityFactory.getNamedPropertyValues());
        }
        ArrayList<SimpleOrderedMap<Object>> fieldTypeProperties = new ArrayList<SimpleOrderedMap<Object>>();
        TreeMap<String, FieldType> sortedFieldTypes = new TreeMap<String, FieldType>(this.fieldTypes);
        for (FieldType fieldType : sortedFieldTypes.values()) {
            fieldTypeProperties.add(fieldType.getNamedPropertyValues(false));
        }
        topLevel.add(FIELD_TYPES, fieldTypeProperties);
        ArrayList<SimpleOrderedMap<Object>> fieldProperties = new ArrayList<SimpleOrderedMap<Object>>();
        TreeSet<String> fieldNames = new TreeSet<String>(this.fields.keySet());
        for (String fieldName : fieldNames) {
            fieldProperties.add(this.fields.get(fieldName).getNamedPropertyValues(false));
        }
        topLevel.add(FIELDS, fieldProperties);
        ArrayList<SimpleOrderedMap<Object>> dynamicFieldProperties = new ArrayList<SimpleOrderedMap<Object>>();
        for (DynamicField dynamicField : this.dynamicFields) {
            if (dynamicField.getRegex().startsWith(INTERNAL_POLY_FIELD_PREFIX)) continue;
            dynamicFieldProperties.add(dynamicField.getPrototype().getNamedPropertyValues(false));
        }
        topLevel.add(DYNAMIC_FIELDS, dynamicFieldProperties);
        topLevel.add(COPY_FIELDS, this.getCopyFieldProperties(false, null, null));
        return topLevel;
    }

    public List<SimpleOrderedMap<Object>> getCopyFieldProperties(boolean showDetails, Set<String> requestedSourceFields, Set<String> requestedDestinationFields) {
        String destination;
        String source;
        ArrayList<SimpleOrderedMap<Object>> copyFieldProperties = new ArrayList<SimpleOrderedMap<Object>>();
        TreeMap<String, List<CopyField>> sortedCopyFields = new TreeMap<String, List<CopyField>>(this.copyFieldsMap);
        for (ArrayList copyFields : sortedCopyFields.values()) {
            copyFields = new ArrayList(copyFields);
            Collections.sort(copyFields, new Comparator<CopyField>(){

                @Override
                public int compare(CopyField cf1, CopyField cf2) {
                    return cf1.getDestination().getName().compareTo(cf2.getDestination().getName());
                }
            });
            for (CopyField copyField : copyFields) {
                source = copyField.getSource().getName();
                destination = copyField.getDestination().getName();
                if (null != requestedSourceFields && !requestedSourceFields.contains(source) || null != requestedDestinationFields && !requestedDestinationFields.contains(destination)) continue;
                SimpleOrderedMap<Object> props = new SimpleOrderedMap<Object>();
                props.add(SOURCE, source);
                props.add(DESTINATION, destination);
                if (0 != copyField.getMaxChars()) {
                    props.add(MAX_CHARS, copyField.getMaxChars());
                }
                copyFieldProperties.add(props);
            }
        }
        if (null != this.dynamicCopyFields) {
            for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
                DynamicField destDynamicBase;
                source = dynamicCopy.getRegex();
                destination = dynamicCopy.getDestFieldName();
                if (null != requestedSourceFields && !requestedSourceFields.contains(source) || null != requestedDestinationFields && !requestedDestinationFields.contains(destination)) continue;
                SimpleOrderedMap<Object> dynamicCopyProps = new SimpleOrderedMap<Object>();
                dynamicCopyProps.add(SOURCE, dynamicCopy.getRegex());
                if (showDetails) {
                    DynamicField sourceDynamicBase = dynamicCopy.getSourceDynamicBase();
                    if (null != sourceDynamicBase) {
                        dynamicCopyProps.add(SOURCE_DYNAMIC_BASE, sourceDynamicBase.getRegex());
                    } else if (source.contains("*")) {
                        ArrayList<String> sourceExplicitFields = new ArrayList<String>();
                        Pattern pattern = Pattern.compile(source.replace("*", ".*"));
                        for (String field : this.fields.keySet()) {
                            if (!pattern.matcher(field).matches()) continue;
                            sourceExplicitFields.add(field);
                        }
                        if (sourceExplicitFields.size() > 0) {
                            Collections.sort(sourceExplicitFields);
                            dynamicCopyProps.add(SOURCE_EXPLICIT_FIELDS, sourceExplicitFields);
                        }
                    }
                }
                dynamicCopyProps.add(DESTINATION, dynamicCopy.getDestFieldName());
                if (showDetails && null != (destDynamicBase = dynamicCopy.getDestDynamicBase())) {
                    dynamicCopyProps.add(DESTINATION_DYNAMIC_BASE, destDynamicBase.getRegex());
                }
                if (0 != dynamicCopy.getMaxChars()) {
                    dynamicCopyProps.add(MAX_CHARS, dynamicCopy.getMaxChars());
                }
                copyFieldProperties.add(dynamicCopyProps);
            }
        }
        return copyFieldProperties;
    }

    protected IndexSchema(SolrConfig solrConfig, SolrResourceLoader loader) {
        this.solrConfig = solrConfig;
        this.loader = loader;
    }

    public IndexSchema addField(SchemaField newField, boolean persist) {
        return this.addFields(Collections.singletonList(newField), Collections.EMPTY_MAP, persist);
    }

    public IndexSchema addField(SchemaField newField) {
        return this.addField(newField, true);
    }

    public IndexSchema addField(SchemaField newField, Collection<String> copyFieldNames) {
        return this.addFields(Collections.singletonList(newField), Collections.singletonMap(newField.getName(), copyFieldNames), true);
    }

    public IndexSchema addFields(Collection<SchemaField> newFields) {
        return this.addFields(newFields, Collections.emptyMap(), true);
    }

    public IndexSchema addFields(Collection<SchemaField> newFields, Map<String, Collection<String>> copyFieldNames, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteFields(Collection<String> names) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema replaceField(String fieldName, FieldType replacementFieldType, Map<String, ?> replacementArgs) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addDynamicFields(Collection<SchemaField> newDynamicFields, Map<String, Collection<String>> copyFieldNames, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteDynamicFields(Collection<String> fieldNamePatterns) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public ManagedIndexSchema replaceDynamicField(String fieldNamePattern, FieldType replacementFieldType, Map<String, ?> replacementArgs) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addCopyFields(Map<String, Collection<String>> copyFields, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addCopyFields(String source, Collection<String> destinations, int maxChars) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteCopyFields(Map<String, Collection<String>> copyFields) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public SchemaField newField(String fieldName, String fieldType, Map<String, ?> options) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public SchemaField newDynamicField(String fieldNamePattern, String fieldType, Map<String, ?> options) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public Object getSchemaUpdateLock() {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addFieldType(FieldType fieldType) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addFieldTypes(List<FieldType> fieldTypeList, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteFieldTypes(Collection<String> names) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema replaceFieldType(String typeName, String replacementClassName, Map<String, Object> replacementArgs) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public FieldType newFieldType(String typeName, String className, Map<String, ?> options) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    protected String getFieldTypeXPathExpressions() {
        String expression = this.stepsToPath(SCHEMA, FIELD_TYPE.toLowerCase(Locale.ROOT)) + XPATH_OR + this.stepsToPath(SCHEMA, FIELD_TYPE) + XPATH_OR + this.stepsToPath(SCHEMA, TYPES, FIELD_TYPE.toLowerCase(Locale.ROOT)) + XPATH_OR + this.stepsToPath(SCHEMA, TYPES, FIELD_TYPE);
        return expression;
    }

    public static class DynamicCopy
    extends DynamicReplacement {
        private final DynamicField destination;
        private final int maxChars;
        final DynamicField sourceDynamicBase;
        final DynamicField destDynamicBase;

        public int getMaxChars() {
            return this.maxChars;
        }

        public DynamicField getSourceDynamicBase() {
            return this.sourceDynamicBase;
        }

        public DynamicField getDestDynamicBase() {
            return this.destDynamicBase;
        }

        DynamicCopy(String sourceRegex, DynamicField destination, int maxChars, DynamicField sourceDynamicBase, DynamicField destDynamicBase) {
            super(sourceRegex);
            this.destination = destination;
            this.maxChars = maxChars;
            this.sourceDynamicBase = sourceDynamicBase;
            this.destDynamicBase = destDynamicBase;
        }

        public DynamicField getDestination() {
            return this.destination;
        }

        public String getDestFieldName() {
            return this.destination.getRegex();
        }

        public SchemaField getTargetField(String sourceField) {
            String remainder = this.pattern.remainder(sourceField);
            String targetFieldName = this.destination.pattern.subst(remainder);
            return this.destination.makeSchemaField(targetFieldName);
        }

        public String toString() {
            return this.destination.prototype.toString();
        }
    }

    public static final class DynamicField
    extends DynamicReplacement {
        private final SchemaField prototype;

        public SchemaField getPrototype() {
            return this.prototype;
        }

        DynamicField(SchemaField prototype) {
            super(prototype.name);
            this.prototype = prototype;
        }

        SchemaField makeSchemaField(String name) {
            return new SchemaField(this.prototype, name);
        }

        public String toString() {
            return this.prototype.toString();
        }
    }

    public static abstract class DynamicReplacement
    implements Comparable<DynamicReplacement> {
        protected DynamicPattern pattern;

        public boolean matches(String name) {
            return this.pattern.matches(name);
        }

        protected DynamicReplacement(String regex) {
            this.pattern = DynamicPattern.createPattern(regex);
        }

        @Override
        public int compareTo(DynamicReplacement other) {
            return other.pattern.length() - this.pattern.length();
        }

        public String getRegex() {
            return this.pattern.regex;
        }

        protected static abstract class DynamicPattern {
            protected final String regex;
            protected final String fixedStr;

            protected DynamicPattern(String regex, String fixedStr) {
                this.regex = regex;
                this.fixedStr = fixedStr;
            }

            static DynamicPattern createPattern(String regex) {
                if (regex.startsWith("*")) {
                    return new NameEndsWith(regex);
                }
                if (regex.endsWith("*")) {
                    return new NameStartsWith(regex);
                }
                return new NameEquals(regex);
            }

            abstract boolean matches(String var1);

            abstract String remainder(String var1);

            abstract String subst(String var1);

            public int length() {
                return this.regex.length();
            }

            private static class NameEquals
            extends DynamicPattern {
                NameEquals(String regex) {
                    super(regex, regex);
                }

                @Override
                boolean matches(String name) {
                    return this.regex.equals(name);
                }

                @Override
                String remainder(String name) {
                    return "";
                }

                @Override
                String subst(String replacement) {
                    return this.fixedStr;
                }
            }

            private static class NameEndsWith
            extends DynamicPattern {
                NameEndsWith(String regex) {
                    super(regex, regex.substring(1));
                }

                @Override
                boolean matches(String name) {
                    return name.endsWith(this.fixedStr);
                }

                @Override
                String remainder(String name) {
                    return name.substring(0, name.length() - this.fixedStr.length());
                }

                @Override
                String subst(String replacement) {
                    return replacement + this.fixedStr;
                }
            }

            private static class NameStartsWith
            extends DynamicPattern {
                NameStartsWith(String regex) {
                    super(regex, regex.substring(0, regex.length() - 1));
                }

                @Override
                boolean matches(String name) {
                    return name.startsWith(this.fixedStr);
                }

                @Override
                String remainder(String name) {
                    return name.substring(this.fixedStr.length());
                }

                @Override
                String subst(String replacement) {
                    return this.fixedStr + replacement;
                }
            }
        }
    }

    private class SolrQueryAnalyzer
    extends SolrIndexAnalyzer {
        SolrQueryAnalyzer() {
        }

        @Override
        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getQueryAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer = (Analyzer)this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getQueryAnalyzer();
        }
    }

    private class SolrIndexAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected final HashMap<String, Analyzer> analyzers;

        SolrIndexAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
            this.analyzers = this.analyzerCache();
        }

        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getIndexAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer = this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getIndexAnalyzer();
        }
    }
}

